(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["main-main-module"],{

/***/ "./node_modules/confetti-js/dist/index.es.js":
/*!***************************************************!*\
  !*** ./node_modules/confetti-js/dist/index.es.js ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function ConfettiGenerator(params) {
  //////////////
  // Defaults
  var appstate = {
    target: 'confetti-holder', // Id of the canvas
    max: 80, // Max itens to render
    size: 1, // prop size
    animate: true, // Should animate?
    respawn: true, // Should confettis be respawned when getting out of screen?
    props: ['circle', 'square', 'triangle', 'line'], // Types of confetti
    colors: [[165,104,246],[230,61,135],[0,199,228],[253,214,126]], // Colors to render confetti
    clock: 25, // Speed of confetti fall
    interval: null, // Draw interval holder
    rotate: false, // Whenever to rotate a prop
    start_from_edge: false, // Should confettis spawn at the top/bottom of the screen?
    width: window.innerWidth, // canvas width (as int, in px)
    height: window.innerHeight // canvas height (as int, in px)
  };

  //////////////
  // Setting parameters if received
  if(params) {
    if(params.target)
      appstate.target = params.target;
    if(params.max)
      appstate.max = params.max;
    if(params.size)
      appstate.size = params.size;
    if(params.animate !== undefined && params.animate !== null)
      appstate.animate = params.animate;
    if(params.respawn !== undefined && params.respawn !== null)
      appstate.respawn = params.respawn;
    if(params.props)
      appstate.props = params.props;
    if(params.colors)
      appstate.colors = params.colors;
    if(params.clock)
      appstate.clock = params.clock;
    if(params.start_from_edge !== undefined && params.start_from_edge !== null)
      appstate.start_from_edge = params.start_from_edge;
    if(params.width)
      appstate.width = params.width;
    if(params.height)
      appstate.height = params.height;
    if(params.rotate !== undefined && params.rotate !== null)
      appstate.rotate = params.rotate;
  }

  //////////////
  // Early exit if the target is not the correct type, or is null
  if(
    typeof appstate.target != 'object' &&
    typeof appstate.target != 'string'
  ) {
    throw new TypeError('The target parameter should be a node or string');
  }

  if(
    (typeof appstate.target == 'object' && (appstate.target === null || !appstate.target instanceof HTMLCanvasElement)) ||
    (typeof appstate.target == 'string' && (document.getElementById(appstate.target) === null || !document.getElementById(appstate.target) instanceof HTMLCanvasElement))
  ) {
    throw new ReferenceError('The target element does not exist or is not a canvas element');
  }

  //////////////
  // Properties
  var cv = typeof appstate.target == 'object'
    ? appstate.target
    : document.getElementById(appstate.target);
  var ctx = cv.getContext("2d");
  var particles = [];

  //////////////
  // Random helper (to minimize typing)
  function rand(limit, floor) {
    if(!limit) limit = 1;
    var rand = Math.random() * limit;
    return !floor ? rand : Math.floor(rand);
  }

  var totalWeight = appstate.props.reduce(function(weight, prop) {
    return weight + (prop.weight || 1);
  }, 0);
  function selectProp() {
    var rand = Math.random() * totalWeight;
    for (var i = 0; i < appstate.props.length; ++i) {
      var weight = appstate.props[i].weight || 1;
      if (rand < weight) return i;
      rand -= weight;
    }
  }

  //////////////
  // Confetti particle generator
  function particleFactory() {
    var prop = appstate.props[selectProp()];
    var p = {
      prop: prop.type ? prop.type : prop, //prop type
      x: rand(appstate.width), //x-coordinate
      y: appstate.start_from_edge ? (appstate.clock >= 0 ? -10 : parseFloat(appstate.height) + 10) : rand(appstate.height), //y-coordinate
      src: prop.src,
      radius: rand(4) + 1, //radius
      size: prop.size,
      rotate: appstate.rotate,
      line: Math.floor(rand(65) - 30), // line angle
      angles: [rand(10, true) + 2, rand(10, true) + 2, rand(10, true) + 2, rand(10, true) + 2], // triangle drawing angles
      color: appstate.colors[rand(appstate.colors.length, true)], // color
      rotation: rand(360, true) * Math.PI/180,
      speed: rand(appstate.clock / 7) + (appstate.clock / 30)
    };

    return p;
  }

  //////////////
  // Confetti drawing on canvas
  function particleDraw(p) {
    if (!p) {
      return;
    }

    var op = (p.radius <= 3) ? 0.4 : 0.8;

    ctx.fillStyle = ctx.strokeStyle = "rgba(" + p.color + ", "+ op +")";
    ctx.beginPath();

    switch(p.prop) {
      case 'circle':{
        ctx.moveTo(p.x, p.y);
        ctx.arc(p.x, p.y, p.radius * appstate.size, 0, Math.PI * 2, true);
        ctx.fill();
        break;
      }
      case 'triangle': {
        ctx.moveTo(p.x, p.y);
        ctx.lineTo(p.x + (p.angles[0] * appstate.size), p.y + (p.angles[1] * appstate.size));
        ctx.lineTo(p.x + (p.angles[2] * appstate.size), p.y + (p.angles[3] * appstate.size));
        ctx.closePath();
        ctx.fill();
        break;
      }
      case 'line':{
        ctx.moveTo(p.x, p.y);
        ctx.lineTo(p.x + (p.line * appstate.size), p.y + (p.radius * 5));
        ctx.lineWidth = 2 * appstate.size;
        ctx.stroke();
        break;
      }
      case 'square': {
        ctx.save();
        ctx.translate(p.x+15, p.y+5);
        ctx.rotate(p.rotation);
        ctx.fillRect(-15 * appstate.size,-5 * appstate.size,15 * appstate.size,5 * appstate.size);
        ctx.restore();
        break;
      }
      case 'svg': {
        ctx.save();
        var image = new window.Image();
        image.src = p.src;
        var size = p.size || 15;
        ctx.translate(p.x + size / 2, p.y + size / 2);
        if(p.rotate)
          ctx.rotate(p.rotation);
        ctx.drawImage(image, -(size/2) * appstate.size, -(size/2) * appstate.size, size * appstate.size, size * appstate.size);
        ctx.restore();
        break;
      }
    }
  }

  //////////////
  // Public itens
  //////////////

  //////////////
  // Clean actual state
  var _clear = function() {
    appstate.animate = false;
    clearInterval(appstate.interval);

    requestAnimationFrame(function() {
    	ctx.clearRect(0, 0, cv.width, cv.height);
      var w = cv.width;
      cv.width = 1;
      cv.width = w;
    });
  };

  //////////////
  // Render confetti on canvas
  var _render = function() {
      cv.width = appstate.width;
      cv.height = appstate.height;
      particles = [];

      for(var i = 0; i < appstate.max; i ++)
        particles.push(particleFactory());

      function draw(){
        ctx.clearRect(0, 0, appstate.width, appstate.height);

        for(var i in particles)
          particleDraw(particles[i]);

        update();

        if(appstate.animate) requestAnimationFrame(draw);
      }

      function update() {

        for (var i = 0; i < appstate.max; i++) {
          var p = particles[i];

          if (p) {
            if(appstate.animate)
              p.y += p.speed;

            if (p.rotate)
              p.rotation += p.speed / 35;

            if ((p.speed >= 0 && p.y > appstate.height) || (p.speed < 0 && p.y < 0)) {
              if(appstate.respawn) {
                particles[i] = p;
                particles[i].x = rand(appstate.width, true);
                particles[i].y = p.speed >= 0 ? -10 : parseFloat(appstate.height);
              } else {
                particles[i] = undefined;
              }
            }
          }
        }

        if (particles.every(function(p) { return p === undefined; })) {
          _clear();
        }
      }

      return requestAnimationFrame(draw);
  };

  return {
    render: _render,
    clear: _clear
  }
}

/* harmony default export */ __webpack_exports__["default"] = (ConfettiGenerator);


/***/ }),

/***/ "./node_modules/howler/dist/howler.js":
/*!********************************************!*\
  !*** ./node_modules/howler/dist/howler.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 *  howler.js v2.2.0
 *  howlerjs.com
 *
 *  (c) 2013-2020, James Simpson of GoldFire Studios
 *  goldfirestudios.com
 *
 *  MIT License
 */

(function() {

  'use strict';

  /** Global Methods **/
  /***************************************************************************/

  /**
   * Create the global controller. All contained methods and properties apply
   * to all sounds that are currently playing or will be in the future.
   */
  var HowlerGlobal = function() {
    this.init();
  };
  HowlerGlobal.prototype = {
    /**
     * Initialize the global Howler object.
     * @return {Howler}
     */
    init: function() {
      var self = this || Howler;

      // Create a global ID counter.
      self._counter = 1000;

      // Pool of unlocked HTML5 Audio objects.
      self._html5AudioPool = [];
      self.html5PoolSize = 10;

      // Internal properties.
      self._codecs = {};
      self._howls = [];
      self._muted = false;
      self._volume = 1;
      self._canPlayEvent = 'canplaythrough';
      self._navigator = (typeof window !== 'undefined' && window.navigator) ? window.navigator : null;

      // Public properties.
      self.masterGain = null;
      self.noAudio = false;
      self.usingWebAudio = true;
      self.autoSuspend = true;
      self.ctx = null;

      // Set to false to disable the auto audio unlocker.
      self.autoUnlock = true;

      // Setup the various state values for global tracking.
      self._setup();

      return self;
    },

    /**
     * Get/set the global volume for all sounds.
     * @param  {Float} vol Volume from 0.0 to 1.0.
     * @return {Howler/Float}     Returns self or current volume.
     */
    volume: function(vol) {
      var self = this || Howler;
      vol = parseFloat(vol);

      // If we don't have an AudioContext created yet, run the setup.
      if (!self.ctx) {
        setupAudioContext();
      }

      if (typeof vol !== 'undefined' && vol >= 0 && vol <= 1) {
        self._volume = vol;

        // Don't update any of the nodes if we are muted.
        if (self._muted) {
          return self;
        }

        // When using Web Audio, we just need to adjust the master gain.
        if (self.usingWebAudio) {
          self.masterGain.gain.setValueAtTime(vol, Howler.ctx.currentTime);
        }

        // Loop through and change volume for all HTML5 audio nodes.
        for (var i=0; i<self._howls.length; i++) {
          if (!self._howls[i]._webAudio) {
            // Get all of the sounds in this Howl group.
            var ids = self._howls[i]._getSoundIds();

            // Loop through all sounds and change the volumes.
            for (var j=0; j<ids.length; j++) {
              var sound = self._howls[i]._soundById(ids[j]);

              if (sound && sound._node) {
                sound._node.volume = sound._volume * vol;
              }
            }
          }
        }

        return self;
      }

      return self._volume;
    },

    /**
     * Handle muting and unmuting globally.
     * @param  {Boolean} muted Is muted or not.
     */
    mute: function(muted) {
      var self = this || Howler;

      // If we don't have an AudioContext created yet, run the setup.
      if (!self.ctx) {
        setupAudioContext();
      }

      self._muted = muted;

      // With Web Audio, we just need to mute the master gain.
      if (self.usingWebAudio) {
        self.masterGain.gain.setValueAtTime(muted ? 0 : self._volume, Howler.ctx.currentTime);
      }

      // Loop through and mute all HTML5 Audio nodes.
      for (var i=0; i<self._howls.length; i++) {
        if (!self._howls[i]._webAudio) {
          // Get all of the sounds in this Howl group.
          var ids = self._howls[i]._getSoundIds();

          // Loop through all sounds and mark the audio node as muted.
          for (var j=0; j<ids.length; j++) {
            var sound = self._howls[i]._soundById(ids[j]);

            if (sound && sound._node) {
              sound._node.muted = (muted) ? true : sound._muted;
            }
          }
        }
      }

      return self;
    },

    /**
     * Handle stopping all sounds globally.
     */
    stop: function() {
      var self = this || Howler;

      // Loop through all Howls and stop them.
      for (var i=0; i<self._howls.length; i++) {
        self._howls[i].stop();
      }

      return self;
    },

    /**
     * Unload and destroy all currently loaded Howl objects.
     * @return {Howler}
     */
    unload: function() {
      var self = this || Howler;

      for (var i=self._howls.length-1; i>=0; i--) {
        self._howls[i].unload();
      }

      // Create a new AudioContext to make sure it is fully reset.
      if (self.usingWebAudio && self.ctx && typeof self.ctx.close !== 'undefined') {
        self.ctx.close();
        self.ctx = null;
        setupAudioContext();
      }

      return self;
    },

    /**
     * Check for codec support of specific extension.
     * @param  {String} ext Audio file extention.
     * @return {Boolean}
     */
    codecs: function(ext) {
      return (this || Howler)._codecs[ext.replace(/^x-/, '')];
    },

    /**
     * Setup various state values for global tracking.
     * @return {Howler}
     */
    _setup: function() {
      var self = this || Howler;

      // Keeps track of the suspend/resume state of the AudioContext.
      self.state = self.ctx ? self.ctx.state || 'suspended' : 'suspended';

      // Automatically begin the 30-second suspend process
      self._autoSuspend();

      // Check if audio is available.
      if (!self.usingWebAudio) {
        // No audio is available on this system if noAudio is set to true.
        if (typeof Audio !== 'undefined') {
          try {
            var test = new Audio();

            // Check if the canplaythrough event is available.
            if (typeof test.oncanplaythrough === 'undefined') {
              self._canPlayEvent = 'canplay';
            }
          } catch(e) {
            self.noAudio = true;
          }
        } else {
          self.noAudio = true;
        }
      }

      // Test to make sure audio isn't disabled in Internet Explorer.
      try {
        var test = new Audio();
        if (test.muted) {
          self.noAudio = true;
        }
      } catch (e) {}

      // Check for supported codecs.
      if (!self.noAudio) {
        self._setupCodecs();
      }

      return self;
    },

    /**
     * Check for browser support for various codecs and cache the results.
     * @return {Howler}
     */
    _setupCodecs: function() {
      var self = this || Howler;
      var audioTest = null;

      // Must wrap in a try/catch because IE11 in server mode throws an error.
      try {
        audioTest = (typeof Audio !== 'undefined') ? new Audio() : null;
      } catch (err) {
        return self;
      }

      if (!audioTest || typeof audioTest.canPlayType !== 'function') {
        return self;
      }

      var mpegTest = audioTest.canPlayType('audio/mpeg;').replace(/^no$/, '');

      // Opera version <33 has mixed MP3 support, so we need to check for and block it.
      var checkOpera = self._navigator && self._navigator.userAgent.match(/OPR\/([0-6].)/g);
      var isOldOpera = (checkOpera && parseInt(checkOpera[0].split('/')[1], 10) < 33);

      self._codecs = {
        mp3: !!(!isOldOpera && (mpegTest || audioTest.canPlayType('audio/mp3;').replace(/^no$/, ''))),
        mpeg: !!mpegTest,
        opus: !!audioTest.canPlayType('audio/ogg; codecs="opus"').replace(/^no$/, ''),
        ogg: !!audioTest.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/, ''),
        oga: !!audioTest.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/, ''),
        wav: !!audioTest.canPlayType('audio/wav; codecs="1"').replace(/^no$/, ''),
        aac: !!audioTest.canPlayType('audio/aac;').replace(/^no$/, ''),
        caf: !!audioTest.canPlayType('audio/x-caf;').replace(/^no$/, ''),
        m4a: !!(audioTest.canPlayType('audio/x-m4a;') || audioTest.canPlayType('audio/m4a;') || audioTest.canPlayType('audio/aac;')).replace(/^no$/, ''),
        m4b: !!(audioTest.canPlayType('audio/x-m4b;') || audioTest.canPlayType('audio/m4b;') || audioTest.canPlayType('audio/aac;')).replace(/^no$/, ''),
        mp4: !!(audioTest.canPlayType('audio/x-mp4;') || audioTest.canPlayType('audio/mp4;') || audioTest.canPlayType('audio/aac;')).replace(/^no$/, ''),
        weba: !!audioTest.canPlayType('audio/webm; codecs="vorbis"').replace(/^no$/, ''),
        webm: !!audioTest.canPlayType('audio/webm; codecs="vorbis"').replace(/^no$/, ''),
        dolby: !!audioTest.canPlayType('audio/mp4; codecs="ec-3"').replace(/^no$/, ''),
        flac: !!(audioTest.canPlayType('audio/x-flac;') || audioTest.canPlayType('audio/flac;')).replace(/^no$/, '')
      };

      return self;
    },

    /**
     * Some browsers/devices will only allow audio to be played after a user interaction.
     * Attempt to automatically unlock audio on the first user interaction.
     * Concept from: http://paulbakaus.com/tutorials/html5/web-audio-on-ios/
     * @return {Howler}
     */
    _unlockAudio: function() {
      var self = this || Howler;

      // Only run this if Web Audio is supported and it hasn't already been unlocked.
      if (self._audioUnlocked || !self.ctx) {
        return;
      }

      self._audioUnlocked = false;
      self.autoUnlock = false;

      // Some mobile devices/platforms have distortion issues when opening/closing tabs and/or web views.
      // Bugs in the browser (especially Mobile Safari) can cause the sampleRate to change from 44100 to 48000.
      // By calling Howler.unload(), we create a new AudioContext with the correct sampleRate.
      if (!self._mobileUnloaded && self.ctx.sampleRate !== 44100) {
        self._mobileUnloaded = true;
        self.unload();
      }

      // Scratch buffer for enabling iOS to dispose of web audio buffers correctly, as per:
      // http://stackoverflow.com/questions/24119684
      self._scratchBuffer = self.ctx.createBuffer(1, 1, 22050);

      // Call this method on touch start to create and play a buffer,
      // then check if the audio actually played to determine if
      // audio has now been unlocked on iOS, Android, etc.
      var unlock = function(e) {
        // Create a pool of unlocked HTML5 Audio objects that can
        // be used for playing sounds without user interaction. HTML5
        // Audio objects must be individually unlocked, as opposed
        // to the WebAudio API which only needs a single activation.
        // This must occur before WebAudio setup or the source.onended
        // event will not fire.
        while (self._html5AudioPool.length < self.html5PoolSize) {
          try {
            var audioNode = new Audio();

            // Mark this Audio object as unlocked to ensure it can get returned
            // to the unlocked pool when released.
            audioNode._unlocked = true;

            // Add the audio node to the pool.
            self._releaseHtml5Audio(audioNode);
          } catch (e) {
            self.noAudio = true;
            break;
          }
        }

        // Loop through any assigned audio nodes and unlock them.
        for (var i=0; i<self._howls.length; i++) {
          if (!self._howls[i]._webAudio) {
            // Get all of the sounds in this Howl group.
            var ids = self._howls[i]._getSoundIds();

            // Loop through all sounds and unlock the audio nodes.
            for (var j=0; j<ids.length; j++) {
              var sound = self._howls[i]._soundById(ids[j]);

              if (sound && sound._node && !sound._node._unlocked) {
                sound._node._unlocked = true;
                sound._node.load();
              }
            }
          }
        }

        // Fix Android can not play in suspend state.
        self._autoResume();

        // Create an empty buffer.
        var source = self.ctx.createBufferSource();
        source.buffer = self._scratchBuffer;
        source.connect(self.ctx.destination);

        // Play the empty buffer.
        if (typeof source.start === 'undefined') {
          source.noteOn(0);
        } else {
          source.start(0);
        }

        // Calling resume() on a stack initiated by user gesture is what actually unlocks the audio on Android Chrome >= 55.
        if (typeof self.ctx.resume === 'function') {
          self.ctx.resume();
        }

        // Setup a timeout to check that we are unlocked on the next event loop.
        source.onended = function() {
          source.disconnect(0);

          // Update the unlocked state and prevent this check from happening again.
          self._audioUnlocked = true;

          // Remove the touch start listener.
          document.removeEventListener('touchstart', unlock, true);
          document.removeEventListener('touchend', unlock, true);
          document.removeEventListener('click', unlock, true);

          // Let all sounds know that audio has been unlocked.
          for (var i=0; i<self._howls.length; i++) {
            self._howls[i]._emit('unlock');
          }
        };
      };

      // Setup a touch start listener to attempt an unlock in.
      document.addEventListener('touchstart', unlock, true);
      document.addEventListener('touchend', unlock, true);
      document.addEventListener('click', unlock, true);

      return self;
    },

    /**
     * Get an unlocked HTML5 Audio object from the pool. If none are left,
     * return a new Audio object and throw a warning.
     * @return {Audio} HTML5 Audio object.
     */
    _obtainHtml5Audio: function() {
      var self = this || Howler;

      // Return the next object from the pool if one exists.
      if (self._html5AudioPool.length) {
        return self._html5AudioPool.pop();
      }

      //.Check if the audio is locked and throw a warning.
      var testPlay = new Audio().play();
      if (testPlay && typeof Promise !== 'undefined' && (testPlay instanceof Promise || typeof testPlay.then === 'function')) {
        testPlay.catch(function() {
          console.warn('HTML5 Audio pool exhausted, returning potentially locked audio object.');
        });
      }

      return new Audio();
    },

    /**
     * Return an activated HTML5 Audio object to the pool.
     * @return {Howler}
     */
    _releaseHtml5Audio: function(audio) {
      var self = this || Howler;

      // Don't add audio to the pool if we don't know if it has been unlocked.
      if (audio._unlocked) {
        self._html5AudioPool.push(audio);
      }

      return self;
    },

    /**
     * Automatically suspend the Web Audio AudioContext after no sound has played for 30 seconds.
     * This saves processing/energy and fixes various browser-specific bugs with audio getting stuck.
     * @return {Howler}
     */
    _autoSuspend: function() {
      var self = this;

      if (!self.autoSuspend || !self.ctx || typeof self.ctx.suspend === 'undefined' || !Howler.usingWebAudio) {
        return;
      }

      // Check if any sounds are playing.
      for (var i=0; i<self._howls.length; i++) {
        if (self._howls[i]._webAudio) {
          for (var j=0; j<self._howls[i]._sounds.length; j++) {
            if (!self._howls[i]._sounds[j]._paused) {
              return self;
            }
          }
        }
      }

      if (self._suspendTimer) {
        clearTimeout(self._suspendTimer);
      }

      // If no sound has played after 30 seconds, suspend the context.
      self._suspendTimer = setTimeout(function() {
        if (!self.autoSuspend) {
          return;
        }

        self._suspendTimer = null;
        self.state = 'suspending';

        // Handle updating the state of the audio context after suspending.
        var handleSuspension = function() {
          self.state = 'suspended';

          if (self._resumeAfterSuspend) {
            delete self._resumeAfterSuspend;
            self._autoResume();
          }
        };

        // Either the state gets suspended or it is interrupted.
        // Either way, we need to update the state to suspended.
        self.ctx.suspend().then(handleSuspension, handleSuspension);
      }, 30000);

      return self;
    },

    /**
     * Automatically resume the Web Audio AudioContext when a new sound is played.
     * @return {Howler}
     */
    _autoResume: function() {
      var self = this;

      if (!self.ctx || typeof self.ctx.resume === 'undefined' || !Howler.usingWebAudio) {
        return;
      }

      if (self.state === 'running' && self.ctx.state !== 'interrupted' && self._suspendTimer) {
        clearTimeout(self._suspendTimer);
        self._suspendTimer = null;
      } else if (self.state === 'suspended' || self.state === 'running' && self.ctx.state === 'interrupted') {
        self.ctx.resume().then(function() {
          self.state = 'running';

          // Emit to all Howls that the audio has resumed.
          for (var i=0; i<self._howls.length; i++) {
            self._howls[i]._emit('resume');
          }
        });

        if (self._suspendTimer) {
          clearTimeout(self._suspendTimer);
          self._suspendTimer = null;
        }
      } else if (self.state === 'suspending') {
        self._resumeAfterSuspend = true;
      }

      return self;
    }
  };

  // Setup the global audio controller.
  var Howler = new HowlerGlobal();

  /** Group Methods **/
  /***************************************************************************/

  /**
   * Create an audio group controller.
   * @param {Object} o Passed in properties for this group.
   */
  var Howl = function(o) {
    var self = this;

    // Throw an error if no source is provided.
    if (!o.src || o.src.length === 0) {
      console.error('An array of source files must be passed with any new Howl.');
      return;
    }

    self.init(o);
  };
  Howl.prototype = {
    /**
     * Initialize a new Howl group object.
     * @param  {Object} o Passed in properties for this group.
     * @return {Howl}
     */
    init: function(o) {
      var self = this;

      // If we don't have an AudioContext created yet, run the setup.
      if (!Howler.ctx) {
        setupAudioContext();
      }

      // Setup user-defined default properties.
      self._autoplay = o.autoplay || false;
      self._format = (typeof o.format !== 'string') ? o.format : [o.format];
      self._html5 = o.html5 || false;
      self._muted = o.mute || false;
      self._loop = o.loop || false;
      self._pool = o.pool || 5;
      self._preload = (typeof o.preload === 'boolean' || o.preload === 'metadata') ? o.preload : true;
      self._rate = o.rate || 1;
      self._sprite = o.sprite || {};
      self._src = (typeof o.src !== 'string') ? o.src : [o.src];
      self._volume = o.volume !== undefined ? o.volume : 1;
      self._xhr = {
        method: o.xhr && o.xhr.method ? o.xhr.method : 'GET',
        headers: o.xhr && o.xhr.headers ? o.xhr.headers : null,
        withCredentials: o.xhr && o.xhr.withCredentials ? o.xhr.withCredentials : false,
      };

      // Setup all other default properties.
      self._duration = 0;
      self._state = 'unloaded';
      self._sounds = [];
      self._endTimers = {};
      self._queue = [];
      self._playLock = false;

      // Setup event listeners.
      self._onend = o.onend ? [{fn: o.onend}] : [];
      self._onfade = o.onfade ? [{fn: o.onfade}] : [];
      self._onload = o.onload ? [{fn: o.onload}] : [];
      self._onloaderror = o.onloaderror ? [{fn: o.onloaderror}] : [];
      self._onplayerror = o.onplayerror ? [{fn: o.onplayerror}] : [];
      self._onpause = o.onpause ? [{fn: o.onpause}] : [];
      self._onplay = o.onplay ? [{fn: o.onplay}] : [];
      self._onstop = o.onstop ? [{fn: o.onstop}] : [];
      self._onmute = o.onmute ? [{fn: o.onmute}] : [];
      self._onvolume = o.onvolume ? [{fn: o.onvolume}] : [];
      self._onrate = o.onrate ? [{fn: o.onrate}] : [];
      self._onseek = o.onseek ? [{fn: o.onseek}] : [];
      self._onunlock = o.onunlock ? [{fn: o.onunlock}] : [];
      self._onresume = [];

      // Web Audio or HTML5 Audio?
      self._webAudio = Howler.usingWebAudio && !self._html5;

      // Automatically try to enable audio.
      if (typeof Howler.ctx !== 'undefined' && Howler.ctx && Howler.autoUnlock) {
        Howler._unlockAudio();
      }

      // Keep track of this Howl group in the global controller.
      Howler._howls.push(self);

      // If they selected autoplay, add a play event to the load queue.
      if (self._autoplay) {
        self._queue.push({
          event: 'play',
          action: function() {
            self.play();
          }
        });
      }

      // Load the source file unless otherwise specified.
      if (self._preload && self._preload !== 'none') {
        self.load();
      }

      return self;
    },

    /**
     * Load the audio file.
     * @return {Howler}
     */
    load: function() {
      var self = this;
      var url = null;

      // If no audio is available, quit immediately.
      if (Howler.noAudio) {
        self._emit('loaderror', null, 'No audio support.');
        return;
      }

      // Make sure our source is in an array.
      if (typeof self._src === 'string') {
        self._src = [self._src];
      }

      // Loop through the sources and pick the first one that is compatible.
      for (var i=0; i<self._src.length; i++) {
        var ext, str;

        if (self._format && self._format[i]) {
          // If an extension was specified, use that instead.
          ext = self._format[i];
        } else {
          // Make sure the source is a string.
          str = self._src[i];
          if (typeof str !== 'string') {
            self._emit('loaderror', null, 'Non-string found in selected audio sources - ignoring.');
            continue;
          }

          // Extract the file extension from the URL or base64 data URI.
          ext = /^data:audio\/([^;,]+);/i.exec(str);
          if (!ext) {
            ext = /\.([^.]+)$/.exec(str.split('?', 1)[0]);
          }

          if (ext) {
            ext = ext[1].toLowerCase();
          }
        }

        // Log a warning if no extension was found.
        if (!ext) {
          console.warn('No file extension was found. Consider using the "format" property or specify an extension.');
        }

        // Check if this extension is available.
        if (ext && Howler.codecs(ext)) {
          url = self._src[i];
          break;
        }
      }

      if (!url) {
        self._emit('loaderror', null, 'No codec support for selected audio sources.');
        return;
      }

      self._src = url;
      self._state = 'loading';

      // If the hosting page is HTTPS and the source isn't,
      // drop down to HTML5 Audio to avoid Mixed Content errors.
      if (window.location.protocol === 'https:' && url.slice(0, 5) === 'http:') {
        self._html5 = true;
        self._webAudio = false;
      }

      // Create a new sound object and add it to the pool.
      new Sound(self);

      // Load and decode the audio data for playback.
      if (self._webAudio) {
        loadBuffer(self);
      }

      return self;
    },

    /**
     * Play a sound or resume previous playback.
     * @param  {String/Number} sprite   Sprite name for sprite playback or sound id to continue previous.
     * @param  {Boolean} internal Internal Use: true prevents event firing.
     * @return {Number}          Sound ID.
     */
    play: function(sprite, internal) {
      var self = this;
      var id = null;

      // Determine if a sprite, sound id or nothing was passed
      if (typeof sprite === 'number') {
        id = sprite;
        sprite = null;
      } else if (typeof sprite === 'string' && self._state === 'loaded' && !self._sprite[sprite]) {
        // If the passed sprite doesn't exist, do nothing.
        return null;
      } else if (typeof sprite === 'undefined') {
        // Use the default sound sprite (plays the full audio length).
        sprite = '__default';

        // Check if there is a single paused sound that isn't ended.
        // If there is, play that sound. If not, continue as usual.
        if (!self._playLock) {
          var num = 0;
          for (var i=0; i<self._sounds.length; i++) {
            if (self._sounds[i]._paused && !self._sounds[i]._ended) {
              num++;
              id = self._sounds[i]._id;
            }
          }

          if (num === 1) {
            sprite = null;
          } else {
            id = null;
          }
        }
      }

      // Get the selected node, or get one from the pool.
      var sound = id ? self._soundById(id) : self._inactiveSound();

      // If the sound doesn't exist, do nothing.
      if (!sound) {
        return null;
      }

      // Select the sprite definition.
      if (id && !sprite) {
        sprite = sound._sprite || '__default';
      }

      // If the sound hasn't loaded, we must wait to get the audio's duration.
      // We also need to wait to make sure we don't run into race conditions with
      // the order of function calls.
      if (self._state !== 'loaded') {
        // Set the sprite value on this sound.
        sound._sprite = sprite;

        // Mark this sound as not ended in case another sound is played before this one loads.
        sound._ended = false;

        // Add the sound to the queue to be played on load.
        var soundId = sound._id;
        self._queue.push({
          event: 'play',
          action: function() {
            self.play(soundId);
          }
        });

        return soundId;
      }

      // Don't play the sound if an id was passed and it is already playing.
      if (id && !sound._paused) {
        // Trigger the play event, in order to keep iterating through queue.
        if (!internal) {
          self._loadQueue('play');
        }

        return sound._id;
      }

      // Make sure the AudioContext isn't suspended, and resume it if it is.
      if (self._webAudio) {
        Howler._autoResume();
      }

      // Determine how long to play for and where to start playing.
      var seek = Math.max(0, sound._seek > 0 ? sound._seek : self._sprite[sprite][0] / 1000);
      var duration = Math.max(0, ((self._sprite[sprite][0] + self._sprite[sprite][1]) / 1000) - seek);
      var timeout = (duration * 1000) / Math.abs(sound._rate);
      var start = self._sprite[sprite][0] / 1000;
      var stop = (self._sprite[sprite][0] + self._sprite[sprite][1]) / 1000;
      sound._sprite = sprite;

      // Mark the sound as ended instantly so that this async playback
      // doesn't get grabbed by another call to play while this one waits to start.
      sound._ended = false;

      // Update the parameters of the sound.
      var setParams = function() {
        sound._paused = false;
        sound._seek = seek;
        sound._start = start;
        sound._stop = stop;
        sound._loop = !!(sound._loop || self._sprite[sprite][2]);
      };

      // End the sound instantly if seek is at the end.
      if (seek >= stop) {
        self._ended(sound);
        return;
      }

      // Begin the actual playback.
      var node = sound._node;
      if (self._webAudio) {
        // Fire this when the sound is ready to play to begin Web Audio playback.
        var playWebAudio = function() {
          self._playLock = false;
          setParams();
          self._refreshBuffer(sound);

          // Setup the playback params.
          var vol = (sound._muted || self._muted) ? 0 : sound._volume;
          node.gain.setValueAtTime(vol, Howler.ctx.currentTime);
          sound._playStart = Howler.ctx.currentTime;

          // Play the sound using the supported method.
          if (typeof node.bufferSource.start === 'undefined') {
            sound._loop ? node.bufferSource.noteGrainOn(0, seek, 86400) : node.bufferSource.noteGrainOn(0, seek, duration);
          } else {
            sound._loop ? node.bufferSource.start(0, seek, 86400) : node.bufferSource.start(0, seek, duration);
          }

          // Start a new timer if none is present.
          if (timeout !== Infinity) {
            self._endTimers[sound._id] = setTimeout(self._ended.bind(self, sound), timeout);
          }

          if (!internal) {
            setTimeout(function() {
              self._emit('play', sound._id);
              self._loadQueue();
            }, 0);
          }
        };

        if (Howler.state === 'running' && Howler.ctx.state !== 'interrupted') {
          playWebAudio();
        } else {
          self._playLock = true;

          // Wait for the audio context to resume before playing.
          self.once('resume', playWebAudio);

          // Cancel the end timer.
          self._clearTimer(sound._id);
        }
      } else {
        // Fire this when the sound is ready to play to begin HTML5 Audio playback.
        var playHtml5 = function() {
          node.currentTime = seek;
          node.muted = sound._muted || self._muted || Howler._muted || node.muted;
          node.volume = sound._volume * Howler.volume();
          node.playbackRate = sound._rate;

          // Some browsers will throw an error if this is called without user interaction.
          try {
            var play = node.play();

            // Support older browsers that don't support promises, and thus don't have this issue.
            if (play && typeof Promise !== 'undefined' && (play instanceof Promise || typeof play.then === 'function')) {
              // Implements a lock to prevent DOMException: The play() request was interrupted by a call to pause().
              self._playLock = true;

              // Set param values immediately.
              setParams();

              // Releases the lock and executes queued actions.
              play
                .then(function() {
                  self._playLock = false;
                  node._unlocked = true;
                  if (!internal) {
                    self._emit('play', sound._id);
                    self._loadQueue();
                  }
                })
                .catch(function() {
                  self._playLock = false;
                  self._emit('playerror', sound._id, 'Playback was unable to start. This is most commonly an issue ' +
                    'on mobile devices and Chrome where playback was not within a user interaction.');

                  // Reset the ended and paused values.
                  sound._ended = true;
                  sound._paused = true;
                });
            } else if (!internal) {
              self._playLock = false;
              setParams();
              self._emit('play', sound._id);
              self._loadQueue();
            }

            // Setting rate before playing won't work in IE, so we set it again here.
            node.playbackRate = sound._rate;

            // If the node is still paused, then we can assume there was a playback issue.
            if (node.paused) {
              self._emit('playerror', sound._id, 'Playback was unable to start. This is most commonly an issue ' +
                'on mobile devices and Chrome where playback was not within a user interaction.');
              return;
            }

            // Setup the end timer on sprites or listen for the ended event.
            if (sprite !== '__default' || sound._loop) {
              self._endTimers[sound._id] = setTimeout(self._ended.bind(self, sound), timeout);
            } else {
              self._endTimers[sound._id] = function() {
                // Fire ended on this audio node.
                self._ended(sound);

                // Clear this listener.
                node.removeEventListener('ended', self._endTimers[sound._id], false);
              };
              node.addEventListener('ended', self._endTimers[sound._id], false);
            }
          } catch (err) {
            self._emit('playerror', sound._id, err);
          }
        };

        // If this is streaming audio, make sure the src is set and load again.
        if (node.src === 'data:audio/wav;base64,UklGRigAAABXQVZFZm10IBIAAAABAAEARKwAAIhYAQACABAAAABkYXRhAgAAAAEA') {
          node.src = self._src;
          node.load();
        }

        // Play immediately if ready, or wait for the 'canplaythrough'e vent.
        var loadedNoReadyState = (window && window.ejecta) || (!node.readyState && Howler._navigator.isCocoonJS);
        if (node.readyState >= 3 || loadedNoReadyState) {
          playHtml5();
        } else {
          self._playLock = true;

          var listener = function() {
            // Begin playback.
            playHtml5();

            // Clear this listener.
            node.removeEventListener(Howler._canPlayEvent, listener, false);
          };
          node.addEventListener(Howler._canPlayEvent, listener, false);

          // Cancel the end timer.
          self._clearTimer(sound._id);
        }
      }

      return sound._id;
    },

    /**
     * Pause playback and save current position.
     * @param  {Number} id The sound ID (empty to pause all in group).
     * @return {Howl}
     */
    pause: function(id) {
      var self = this;

      // If the sound hasn't loaded or a play() promise is pending, add it to the load queue to pause when capable.
      if (self._state !== 'loaded' || self._playLock) {
        self._queue.push({
          event: 'pause',
          action: function() {
            self.pause(id);
          }
        });

        return self;
      }

      // If no id is passed, get all ID's to be paused.
      var ids = self._getSoundIds(id);

      for (var i=0; i<ids.length; i++) {
        // Clear the end timer.
        self._clearTimer(ids[i]);

        // Get the sound.
        var sound = self._soundById(ids[i]);

        if (sound && !sound._paused) {
          // Reset the seek position.
          sound._seek = self.seek(ids[i]);
          sound._rateSeek = 0;
          sound._paused = true;

          // Stop currently running fades.
          self._stopFade(ids[i]);

          if (sound._node) {
            if (self._webAudio) {
              // Make sure the sound has been created.
              if (!sound._node.bufferSource) {
                continue;
              }

              if (typeof sound._node.bufferSource.stop === 'undefined') {
                sound._node.bufferSource.noteOff(0);
              } else {
                sound._node.bufferSource.stop(0);
              }

              // Clean up the buffer source.
              self._cleanBuffer(sound._node);
            } else if (!isNaN(sound._node.duration) || sound._node.duration === Infinity) {
              sound._node.pause();
            }
          }
        }

        // Fire the pause event, unless `true` is passed as the 2nd argument.
        if (!arguments[1]) {
          self._emit('pause', sound ? sound._id : null);
        }
      }

      return self;
    },

    /**
     * Stop playback and reset to start.
     * @param  {Number} id The sound ID (empty to stop all in group).
     * @param  {Boolean} internal Internal Use: true prevents event firing.
     * @return {Howl}
     */
    stop: function(id, internal) {
      var self = this;

      // If the sound hasn't loaded, add it to the load queue to stop when capable.
      if (self._state !== 'loaded' || self._playLock) {
        self._queue.push({
          event: 'stop',
          action: function() {
            self.stop(id);
          }
        });

        return self;
      }

      // If no id is passed, get all ID's to be stopped.
      var ids = self._getSoundIds(id);

      for (var i=0; i<ids.length; i++) {
        // Clear the end timer.
        self._clearTimer(ids[i]);

        // Get the sound.
        var sound = self._soundById(ids[i]);

        if (sound) {
          // Reset the seek position.
          sound._seek = sound._start || 0;
          sound._rateSeek = 0;
          sound._paused = true;
          sound._ended = true;

          // Stop currently running fades.
          self._stopFade(ids[i]);

          if (sound._node) {
            if (self._webAudio) {
              // Make sure the sound's AudioBufferSourceNode has been created.
              if (sound._node.bufferSource) {
                if (typeof sound._node.bufferSource.stop === 'undefined') {
                  sound._node.bufferSource.noteOff(0);
                } else {
                  sound._node.bufferSource.stop(0);
                }

                // Clean up the buffer source.
                self._cleanBuffer(sound._node);
              }
            } else if (!isNaN(sound._node.duration) || sound._node.duration === Infinity) {
              sound._node.currentTime = sound._start || 0;
              sound._node.pause();

              // If this is a live stream, stop download once the audio is stopped.
              if (sound._node.duration === Infinity) {
                self._clearSound(sound._node);
              }
            }
          }

          if (!internal) {
            self._emit('stop', sound._id);
          }
        }
      }

      return self;
    },

    /**
     * Mute/unmute a single sound or all sounds in this Howl group.
     * @param  {Boolean} muted Set to true to mute and false to unmute.
     * @param  {Number} id    The sound ID to update (omit to mute/unmute all).
     * @return {Howl}
     */
    mute: function(muted, id) {
      var self = this;

      // If the sound hasn't loaded, add it to the load queue to mute when capable.
      if (self._state !== 'loaded'|| self._playLock) {
        self._queue.push({
          event: 'mute',
          action: function() {
            self.mute(muted, id);
          }
        });

        return self;
      }

      // If applying mute/unmute to all sounds, update the group's value.
      if (typeof id === 'undefined') {
        if (typeof muted === 'boolean') {
          self._muted = muted;
        } else {
          return self._muted;
        }
      }

      // If no id is passed, get all ID's to be muted.
      var ids = self._getSoundIds(id);

      for (var i=0; i<ids.length; i++) {
        // Get the sound.
        var sound = self._soundById(ids[i]);

        if (sound) {
          sound._muted = muted;

          // Cancel active fade and set the volume to the end value.
          if (sound._interval) {
            self._stopFade(sound._id);
          }

          if (self._webAudio && sound._node) {
            sound._node.gain.setValueAtTime(muted ? 0 : sound._volume, Howler.ctx.currentTime);
          } else if (sound._node) {
            sound._node.muted = Howler._muted ? true : muted;
          }

          self._emit('mute', sound._id);
        }
      }

      return self;
    },

    /**
     * Get/set the volume of this sound or of the Howl group. This method can optionally take 0, 1 or 2 arguments.
     *   volume() -> Returns the group's volume value.
     *   volume(id) -> Returns the sound id's current volume.
     *   volume(vol) -> Sets the volume of all sounds in this Howl group.
     *   volume(vol, id) -> Sets the volume of passed sound id.
     * @return {Howl/Number} Returns self or current volume.
     */
    volume: function() {
      var self = this;
      var args = arguments;
      var vol, id;

      // Determine the values based on arguments.
      if (args.length === 0) {
        // Return the value of the groups' volume.
        return self._volume;
      } else if (args.length === 1 || args.length === 2 && typeof args[1] === 'undefined') {
        // First check if this is an ID, and if not, assume it is a new volume.
        var ids = self._getSoundIds();
        var index = ids.indexOf(args[0]);
        if (index >= 0) {
          id = parseInt(args[0], 10);
        } else {
          vol = parseFloat(args[0]);
        }
      } else if (args.length >= 2) {
        vol = parseFloat(args[0]);
        id = parseInt(args[1], 10);
      }

      // Update the volume or return the current volume.
      var sound;
      if (typeof vol !== 'undefined' && vol >= 0 && vol <= 1) {
        // If the sound hasn't loaded, add it to the load queue to change volume when capable.
        if (self._state !== 'loaded'|| self._playLock) {
          self._queue.push({
            event: 'volume',
            action: function() {
              self.volume.apply(self, args);
            }
          });

          return self;
        }

        // Set the group volume.
        if (typeof id === 'undefined') {
          self._volume = vol;
        }

        // Update one or all volumes.
        id = self._getSoundIds(id);
        for (var i=0; i<id.length; i++) {
          // Get the sound.
          sound = self._soundById(id[i]);

          if (sound) {
            sound._volume = vol;

            // Stop currently running fades.
            if (!args[2]) {
              self._stopFade(id[i]);
            }

            if (self._webAudio && sound._node && !sound._muted) {
              sound._node.gain.setValueAtTime(vol, Howler.ctx.currentTime);
            } else if (sound._node && !sound._muted) {
              sound._node.volume = vol * Howler.volume();
            }

            self._emit('volume', sound._id);
          }
        }
      } else {
        sound = id ? self._soundById(id) : self._sounds[0];
        return sound ? sound._volume : 0;
      }

      return self;
    },

    /**
     * Fade a currently playing sound between two volumes (if no id is passed, all sounds will fade).
     * @param  {Number} from The value to fade from (0.0 to 1.0).
     * @param  {Number} to   The volume to fade to (0.0 to 1.0).
     * @param  {Number} len  Time in milliseconds to fade.
     * @param  {Number} id   The sound id (omit to fade all sounds).
     * @return {Howl}
     */
    fade: function(from, to, len, id) {
      var self = this;

      // If the sound hasn't loaded, add it to the load queue to fade when capable.
      if (self._state !== 'loaded' || self._playLock) {
        self._queue.push({
          event: 'fade',
          action: function() {
            self.fade(from, to, len, id);
          }
        });

        return self;
      }

      // Make sure the to/from/len values are numbers.
      from = Math.min(Math.max(0, parseFloat(from)), 1);
      to = Math.min(Math.max(0, parseFloat(to)), 1);
      len = parseFloat(len);

      // Set the volume to the start position.
      self.volume(from, id);

      // Fade the volume of one or all sounds.
      var ids = self._getSoundIds(id);
      for (var i=0; i<ids.length; i++) {
        // Get the sound.
        var sound = self._soundById(ids[i]);

        // Create a linear fade or fall back to timeouts with HTML5 Audio.
        if (sound) {
          // Stop the previous fade if no sprite is being used (otherwise, volume handles this).
          if (!id) {
            self._stopFade(ids[i]);
          }

          // If we are using Web Audio, let the native methods do the actual fade.
          if (self._webAudio && !sound._muted) {
            var currentTime = Howler.ctx.currentTime;
            var end = currentTime + (len / 1000);
            sound._volume = from;
            sound._node.gain.setValueAtTime(from, currentTime);
            sound._node.gain.linearRampToValueAtTime(to, end);
          }

          self._startFadeInterval(sound, from, to, len, ids[i], typeof id === 'undefined');
        }
      }

      return self;
    },

    /**
     * Starts the internal interval to fade a sound.
     * @param  {Object} sound Reference to sound to fade.
     * @param  {Number} from The value to fade from (0.0 to 1.0).
     * @param  {Number} to   The volume to fade to (0.0 to 1.0).
     * @param  {Number} len  Time in milliseconds to fade.
     * @param  {Number} id   The sound id to fade.
     * @param  {Boolean} isGroup   If true, set the volume on the group.
     */
    _startFadeInterval: function(sound, from, to, len, id, isGroup) {
      var self = this;
      var vol = from;
      var diff = to - from;
      var steps = Math.abs(diff / 0.01);
      var stepLen = Math.max(4, (steps > 0) ? len / steps : len);
      var lastTick = Date.now();

      // Store the value being faded to.
      sound._fadeTo = to;

      // Update the volume value on each interval tick.
      sound._interval = setInterval(function() {
        // Update the volume based on the time since the last tick.
        var tick = (Date.now() - lastTick) / len;
        lastTick = Date.now();
        vol += diff * tick;

        // Make sure the volume is in the right bounds.
        if (diff < 0) {
          vol = Math.max(to, vol);
        } else {
          vol = Math.min(to, vol);
        }

        // Round to within 2 decimal points.
        vol = Math.round(vol * 100) / 100;

        // Change the volume.
        if (self._webAudio) {
          sound._volume = vol;
        } else {
          self.volume(vol, sound._id, true);
        }

        // Set the group's volume.
        if (isGroup) {
          self._volume = vol;
        }

        // When the fade is complete, stop it and fire event.
        if ((to < from && vol <= to) || (to > from && vol >= to)) {
          clearInterval(sound._interval);
          sound._interval = null;
          sound._fadeTo = null;
          self.volume(to, sound._id);
          self._emit('fade', sound._id);
        }
      }, stepLen);
    },

    /**
     * Internal method that stops the currently playing fade when
     * a new fade starts, volume is changed or the sound is stopped.
     * @param  {Number} id The sound id.
     * @return {Howl}
     */
    _stopFade: function(id) {
      var self = this;
      var sound = self._soundById(id);

      if (sound && sound._interval) {
        if (self._webAudio) {
          sound._node.gain.cancelScheduledValues(Howler.ctx.currentTime);
        }

        clearInterval(sound._interval);
        sound._interval = null;
        self.volume(sound._fadeTo, id);
        sound._fadeTo = null;
        self._emit('fade', id);
      }

      return self;
    },

    /**
     * Get/set the loop parameter on a sound. This method can optionally take 0, 1 or 2 arguments.
     *   loop() -> Returns the group's loop value.
     *   loop(id) -> Returns the sound id's loop value.
     *   loop(loop) -> Sets the loop value for all sounds in this Howl group.
     *   loop(loop, id) -> Sets the loop value of passed sound id.
     * @return {Howl/Boolean} Returns self or current loop value.
     */
    loop: function() {
      var self = this;
      var args = arguments;
      var loop, id, sound;

      // Determine the values for loop and id.
      if (args.length === 0) {
        // Return the grou's loop value.
        return self._loop;
      } else if (args.length === 1) {
        if (typeof args[0] === 'boolean') {
          loop = args[0];
          self._loop = loop;
        } else {
          // Return this sound's loop value.
          sound = self._soundById(parseInt(args[0], 10));
          return sound ? sound._loop : false;
        }
      } else if (args.length === 2) {
        loop = args[0];
        id = parseInt(args[1], 10);
      }

      // If no id is passed, get all ID's to be looped.
      var ids = self._getSoundIds(id);
      for (var i=0; i<ids.length; i++) {
        sound = self._soundById(ids[i]);

        if (sound) {
          sound._loop = loop;
          if (self._webAudio && sound._node && sound._node.bufferSource) {
            sound._node.bufferSource.loop = loop;
            if (loop) {
              sound._node.bufferSource.loopStart = sound._start || 0;
              sound._node.bufferSource.loopEnd = sound._stop;
            }
          }
        }
      }

      return self;
    },

    /**
     * Get/set the playback rate of a sound. This method can optionally take 0, 1 or 2 arguments.
     *   rate() -> Returns the first sound node's current playback rate.
     *   rate(id) -> Returns the sound id's current playback rate.
     *   rate(rate) -> Sets the playback rate of all sounds in this Howl group.
     *   rate(rate, id) -> Sets the playback rate of passed sound id.
     * @return {Howl/Number} Returns self or the current playback rate.
     */
    rate: function() {
      var self = this;
      var args = arguments;
      var rate, id;

      // Determine the values based on arguments.
      if (args.length === 0) {
        // We will simply return the current rate of the first node.
        id = self._sounds[0]._id;
      } else if (args.length === 1) {
        // First check if this is an ID, and if not, assume it is a new rate value.
        var ids = self._getSoundIds();
        var index = ids.indexOf(args[0]);
        if (index >= 0) {
          id = parseInt(args[0], 10);
        } else {
          rate = parseFloat(args[0]);
        }
      } else if (args.length === 2) {
        rate = parseFloat(args[0]);
        id = parseInt(args[1], 10);
      }

      // Update the playback rate or return the current value.
      var sound;
      if (typeof rate === 'number') {
        // If the sound hasn't loaded, add it to the load queue to change playback rate when capable.
        if (self._state !== 'loaded' || self._playLock) {
          self._queue.push({
            event: 'rate',
            action: function() {
              self.rate.apply(self, args);
            }
          });

          return self;
        }

        // Set the group rate.
        if (typeof id === 'undefined') {
          self._rate = rate;
        }

        // Update one or all volumes.
        id = self._getSoundIds(id);
        for (var i=0; i<id.length; i++) {
          // Get the sound.
          sound = self._soundById(id[i]);

          if (sound) {
            // Keep track of our position when the rate changed and update the playback
            // start position so we can properly adjust the seek position for time elapsed.
            if (self.playing(id[i])) {
              sound._rateSeek = self.seek(id[i]);
              sound._playStart = self._webAudio ? Howler.ctx.currentTime : sound._playStart;
            }
            sound._rate = rate;

            // Change the playback rate.
            if (self._webAudio && sound._node && sound._node.bufferSource) {
              sound._node.bufferSource.playbackRate.setValueAtTime(rate, Howler.ctx.currentTime);
            } else if (sound._node) {
              sound._node.playbackRate = rate;
            }

            // Reset the timers.
            var seek = self.seek(id[i]);
            var duration = ((self._sprite[sound._sprite][0] + self._sprite[sound._sprite][1]) / 1000) - seek;
            var timeout = (duration * 1000) / Math.abs(sound._rate);

            // Start a new end timer if sound is already playing.
            if (self._endTimers[id[i]] || !sound._paused) {
              self._clearTimer(id[i]);
              self._endTimers[id[i]] = setTimeout(self._ended.bind(self, sound), timeout);
            }

            self._emit('rate', sound._id);
          }
        }
      } else {
        sound = self._soundById(id);
        return sound ? sound._rate : self._rate;
      }

      return self;
    },

    /**
     * Get/set the seek position of a sound. This method can optionally take 0, 1 or 2 arguments.
     *   seek() -> Returns the first sound node's current seek position.
     *   seek(id) -> Returns the sound id's current seek position.
     *   seek(seek) -> Sets the seek position of the first sound node.
     *   seek(seek, id) -> Sets the seek position of passed sound id.
     * @return {Howl/Number} Returns self or the current seek position.
     */
    seek: function() {
      var self = this;
      var args = arguments;
      var seek, id;

      // Determine the values based on arguments.
      if (args.length === 0) {
        // We will simply return the current position of the first node.
        id = self._sounds[0]._id;
      } else if (args.length === 1) {
        // First check if this is an ID, and if not, assume it is a new seek position.
        var ids = self._getSoundIds();
        var index = ids.indexOf(args[0]);
        if (index >= 0) {
          id = parseInt(args[0], 10);
        } else if (self._sounds.length) {
          id = self._sounds[0]._id;
          seek = parseFloat(args[0]);
        }
      } else if (args.length === 2) {
        seek = parseFloat(args[0]);
        id = parseInt(args[1], 10);
      }

      // If there is no ID, bail out.
      if (typeof id === 'undefined') {
        return self;
      }

      // If the sound hasn't loaded, add it to the load queue to seek when capable.
      if (self._state !== 'loaded' || self._playLock) {
        self._queue.push({
          event: 'seek',
          action: function() {
            self.seek.apply(self, args);
          }
        });

        return self;
      }

      // Get the sound.
      var sound = self._soundById(id);

      if (sound) {
        if (typeof seek === 'number' && seek >= 0) {
          // Pause the sound and update position for restarting playback.
          var playing = self.playing(id);
          if (playing) {
            self.pause(id, true);
          }

          // Move the position of the track and cancel timer.
          sound._seek = seek;
          sound._ended = false;
          self._clearTimer(id);

          // Update the seek position for HTML5 Audio.
          if (!self._webAudio && sound._node && !isNaN(sound._node.duration)) {
            sound._node.currentTime = seek;
          }

          // Seek and emit when ready.
          var seekAndEmit = function() {
            self._emit('seek', id);

            // Restart the playback if the sound was playing.
            if (playing) {
              self.play(id, true);
            }
          };

          // Wait for the play lock to be unset before emitting (HTML5 Audio).
          if (playing && !self._webAudio) {
            var emitSeek = function() {
              if (!self._playLock) {
                seekAndEmit();
              } else {
                setTimeout(emitSeek, 0);
              }
            };
            setTimeout(emitSeek, 0);
          } else {
            seekAndEmit();
          }
        } else {
          if (self._webAudio) {
            var realTime = self.playing(id) ? Howler.ctx.currentTime - sound._playStart : 0;
            var rateSeek = sound._rateSeek ? sound._rateSeek - sound._seek : 0;
            return sound._seek + (rateSeek + realTime * Math.abs(sound._rate));
          } else {
            return sound._node.currentTime;
          }
        }
      }

      return self;
    },

    /**
     * Check if a specific sound is currently playing or not (if id is provided), or check if at least one of the sounds in the group is playing or not.
     * @param  {Number}  id The sound id to check. If none is passed, the whole sound group is checked.
     * @return {Boolean} True if playing and false if not.
     */
    playing: function(id) {
      var self = this;

      // Check the passed sound ID (if any).
      if (typeof id === 'number') {
        var sound = self._soundById(id);
        return sound ? !sound._paused : false;
      }

      // Otherwise, loop through all sounds and check if any are playing.
      for (var i=0; i<self._sounds.length; i++) {
        if (!self._sounds[i]._paused) {
          return true;
        }
      }

      return false;
    },

    /**
     * Get the duration of this sound. Passing a sound id will return the sprite duration.
     * @param  {Number} id The sound id to check. If none is passed, return full source duration.
     * @return {Number} Audio duration in seconds.
     */
    duration: function(id) {
      var self = this;
      var duration = self._duration;

      // If we pass an ID, get the sound and return the sprite length.
      var sound = self._soundById(id);
      if (sound) {
        duration = self._sprite[sound._sprite][1] / 1000;
      }

      return duration;
    },

    /**
     * Returns the current loaded state of this Howl.
     * @return {String} 'unloaded', 'loading', 'loaded'
     */
    state: function() {
      return this._state;
    },

    /**
     * Unload and destroy the current Howl object.
     * This will immediately stop all sound instances attached to this group.
     */
    unload: function() {
      var self = this;

      // Stop playing any active sounds.
      var sounds = self._sounds;
      for (var i=0; i<sounds.length; i++) {
        // Stop the sound if it is currently playing.
        if (!sounds[i]._paused) {
          self.stop(sounds[i]._id);
        }

        // Remove the source or disconnect.
        if (!self._webAudio) {
          // Set the source to 0-second silence to stop any downloading (except in IE).
          self._clearSound(sounds[i]._node);

          // Remove any event listeners.
          sounds[i]._node.removeEventListener('error', sounds[i]._errorFn, false);
          sounds[i]._node.removeEventListener(Howler._canPlayEvent, sounds[i]._loadFn, false);

          // Release the Audio object back to the pool.
          Howler._releaseHtml5Audio(sounds[i]._node);
        }

        // Empty out all of the nodes.
        delete sounds[i]._node;

        // Make sure all timers are cleared out.
        self._clearTimer(sounds[i]._id);
      }

      // Remove the references in the global Howler object.
      var index = Howler._howls.indexOf(self);
      if (index >= 0) {
        Howler._howls.splice(index, 1);
      }

      // Delete this sound from the cache (if no other Howl is using it).
      var remCache = true;
      for (i=0; i<Howler._howls.length; i++) {
        if (Howler._howls[i]._src === self._src || self._src.indexOf(Howler._howls[i]._src) >= 0) {
          remCache = false;
          break;
        }
      }

      if (cache && remCache) {
        delete cache[self._src];
      }

      // Clear global errors.
      Howler.noAudio = false;

      // Clear out `self`.
      self._state = 'unloaded';
      self._sounds = [];
      self = null;

      return null;
    },

    /**
     * Listen to a custom event.
     * @param  {String}   event Event name.
     * @param  {Function} fn    Listener to call.
     * @param  {Number}   id    (optional) Only listen to events for this sound.
     * @param  {Number}   once  (INTERNAL) Marks event to fire only once.
     * @return {Howl}
     */
    on: function(event, fn, id, once) {
      var self = this;
      var events = self['_on' + event];

      if (typeof fn === 'function') {
        events.push(once ? {id: id, fn: fn, once: once} : {id: id, fn: fn});
      }

      return self;
    },

    /**
     * Remove a custom event. Call without parameters to remove all events.
     * @param  {String}   event Event name.
     * @param  {Function} fn    Listener to remove. Leave empty to remove all.
     * @param  {Number}   id    (optional) Only remove events for this sound.
     * @return {Howl}
     */
    off: function(event, fn, id) {
      var self = this;
      var events = self['_on' + event];
      var i = 0;

      // Allow passing just an event and ID.
      if (typeof fn === 'number') {
        id = fn;
        fn = null;
      }

      if (fn || id) {
        // Loop through event store and remove the passed function.
        for (i=0; i<events.length; i++) {
          var isId = (id === events[i].id);
          if (fn === events[i].fn && isId || !fn && isId) {
            events.splice(i, 1);
            break;
          }
        }
      } else if (event) {
        // Clear out all events of this type.
        self['_on' + event] = [];
      } else {
        // Clear out all events of every type.
        var keys = Object.keys(self);
        for (i=0; i<keys.length; i++) {
          if ((keys[i].indexOf('_on') === 0) && Array.isArray(self[keys[i]])) {
            self[keys[i]] = [];
          }
        }
      }

      return self;
    },

    /**
     * Listen to a custom event and remove it once fired.
     * @param  {String}   event Event name.
     * @param  {Function} fn    Listener to call.
     * @param  {Number}   id    (optional) Only listen to events for this sound.
     * @return {Howl}
     */
    once: function(event, fn, id) {
      var self = this;

      // Setup the event listener.
      self.on(event, fn, id, 1);

      return self;
    },

    /**
     * Emit all events of a specific type and pass the sound id.
     * @param  {String} event Event name.
     * @param  {Number} id    Sound ID.
     * @param  {Number} msg   Message to go with event.
     * @return {Howl}
     */
    _emit: function(event, id, msg) {
      var self = this;
      var events = self['_on' + event];

      // Loop through event store and fire all functions.
      for (var i=events.length-1; i>=0; i--) {
        // Only fire the listener if the correct ID is used.
        if (!events[i].id || events[i].id === id || event === 'load') {
          setTimeout(function(fn) {
            fn.call(this, id, msg);
          }.bind(self, events[i].fn), 0);

          // If this event was setup with `once`, remove it.
          if (events[i].once) {
            self.off(event, events[i].fn, events[i].id);
          }
        }
      }

      // Pass the event type into load queue so that it can continue stepping.
      self._loadQueue(event);

      return self;
    },

    /**
     * Queue of actions initiated before the sound has loaded.
     * These will be called in sequence, with the next only firing
     * after the previous has finished executing (even if async like play).
     * @return {Howl}
     */
    _loadQueue: function(event) {
      var self = this;

      if (self._queue.length > 0) {
        var task = self._queue[0];

        // Remove this task if a matching event was passed.
        if (task.event === event) {
          self._queue.shift();
          self._loadQueue();
        }

        // Run the task if no event type is passed.
        if (!event) {
          task.action();
        }
      }

      return self;
    },

    /**
     * Fired when playback ends at the end of the duration.
     * @param  {Sound} sound The sound object to work with.
     * @return {Howl}
     */
    _ended: function(sound) {
      var self = this;
      var sprite = sound._sprite;

      // If we are using IE and there was network latency we may be clipping
      // audio before it completes playing. Lets check the node to make sure it
      // believes it has completed, before ending the playback.
      if (!self._webAudio && sound._node && !sound._node.paused && !sound._node.ended && sound._node.currentTime < sound._stop) {
        setTimeout(self._ended.bind(self, sound), 100);
        return self;
      }

      // Should this sound loop?
      var loop = !!(sound._loop || self._sprite[sprite][2]);

      // Fire the ended event.
      self._emit('end', sound._id);

      // Restart the playback for HTML5 Audio loop.
      if (!self._webAudio && loop) {
        self.stop(sound._id, true).play(sound._id);
      }

      // Restart this timer if on a Web Audio loop.
      if (self._webAudio && loop) {
        self._emit('play', sound._id);
        sound._seek = sound._start || 0;
        sound._rateSeek = 0;
        sound._playStart = Howler.ctx.currentTime;

        var timeout = ((sound._stop - sound._start) * 1000) / Math.abs(sound._rate);
        self._endTimers[sound._id] = setTimeout(self._ended.bind(self, sound), timeout);
      }

      // Mark the node as paused.
      if (self._webAudio && !loop) {
        sound._paused = true;
        sound._ended = true;
        sound._seek = sound._start || 0;
        sound._rateSeek = 0;
        self._clearTimer(sound._id);

        // Clean up the buffer source.
        self._cleanBuffer(sound._node);

        // Attempt to auto-suspend AudioContext if no sounds are still playing.
        Howler._autoSuspend();
      }

      // When using a sprite, end the track.
      if (!self._webAudio && !loop) {
        self.stop(sound._id, true);
      }

      return self;
    },

    /**
     * Clear the end timer for a sound playback.
     * @param  {Number} id The sound ID.
     * @return {Howl}
     */
    _clearTimer: function(id) {
      var self = this;

      if (self._endTimers[id]) {
        // Clear the timeout or remove the ended listener.
        if (typeof self._endTimers[id] !== 'function') {
          clearTimeout(self._endTimers[id]);
        } else {
          var sound = self._soundById(id);
          if (sound && sound._node) {
            sound._node.removeEventListener('ended', self._endTimers[id], false);
          }
        }

        delete self._endTimers[id];
      }

      return self;
    },

    /**
     * Return the sound identified by this ID, or return null.
     * @param  {Number} id Sound ID
     * @return {Object}    Sound object or null.
     */
    _soundById: function(id) {
      var self = this;

      // Loop through all sounds and find the one with this ID.
      for (var i=0; i<self._sounds.length; i++) {
        if (id === self._sounds[i]._id) {
          return self._sounds[i];
        }
      }

      return null;
    },

    /**
     * Return an inactive sound from the pool or create a new one.
     * @return {Sound} Sound playback object.
     */
    _inactiveSound: function() {
      var self = this;

      self._drain();

      // Find the first inactive node to recycle.
      for (var i=0; i<self._sounds.length; i++) {
        if (self._sounds[i]._ended) {
          return self._sounds[i].reset();
        }
      }

      // If no inactive node was found, create a new one.
      return new Sound(self);
    },

    /**
     * Drain excess inactive sounds from the pool.
     */
    _drain: function() {
      var self = this;
      var limit = self._pool;
      var cnt = 0;
      var i = 0;

      // If there are less sounds than the max pool size, we are done.
      if (self._sounds.length < limit) {
        return;
      }

      // Count the number of inactive sounds.
      for (i=0; i<self._sounds.length; i++) {
        if (self._sounds[i]._ended) {
          cnt++;
        }
      }

      // Remove excess inactive sounds, going in reverse order.
      for (i=self._sounds.length - 1; i>=0; i--) {
        if (cnt <= limit) {
          return;
        }

        if (self._sounds[i]._ended) {
          // Disconnect the audio source when using Web Audio.
          if (self._webAudio && self._sounds[i]._node) {
            self._sounds[i]._node.disconnect(0);
          }

          // Remove sounds until we have the pool size.
          self._sounds.splice(i, 1);
          cnt--;
        }
      }
    },

    /**
     * Get all ID's from the sounds pool.
     * @param  {Number} id Only return one ID if one is passed.
     * @return {Array}    Array of IDs.
     */
    _getSoundIds: function(id) {
      var self = this;

      if (typeof id === 'undefined') {
        var ids = [];
        for (var i=0; i<self._sounds.length; i++) {
          ids.push(self._sounds[i]._id);
        }

        return ids;
      } else {
        return [id];
      }
    },

    /**
     * Load the sound back into the buffer source.
     * @param  {Sound} sound The sound object to work with.
     * @return {Howl}
     */
    _refreshBuffer: function(sound) {
      var self = this;

      // Setup the buffer source for playback.
      sound._node.bufferSource = Howler.ctx.createBufferSource();
      sound._node.bufferSource.buffer = cache[self._src];

      // Connect to the correct node.
      if (sound._panner) {
        sound._node.bufferSource.connect(sound._panner);
      } else {
        sound._node.bufferSource.connect(sound._node);
      }

      // Setup looping and playback rate.
      sound._node.bufferSource.loop = sound._loop;
      if (sound._loop) {
        sound._node.bufferSource.loopStart = sound._start || 0;
        sound._node.bufferSource.loopEnd = sound._stop || 0;
      }
      sound._node.bufferSource.playbackRate.setValueAtTime(sound._rate, Howler.ctx.currentTime);

      return self;
    },

    /**
     * Prevent memory leaks by cleaning up the buffer source after playback.
     * @param  {Object} node Sound's audio node containing the buffer source.
     * @return {Howl}
     */
    _cleanBuffer: function(node) {
      var self = this;
      var isIOS = Howler._navigator && Howler._navigator.vendor.indexOf('Apple') >= 0;

      if (Howler._scratchBuffer && node.bufferSource) {
        node.bufferSource.onended = null;
        node.bufferSource.disconnect(0);
        if (isIOS) {
          try { node.bufferSource.buffer = Howler._scratchBuffer; } catch(e) {}
        }
      }
      node.bufferSource = null;

      return self;
    },

    /**
     * Set the source to a 0-second silence to stop any downloading (except in IE).
     * @param  {Object} node Audio node to clear.
     */
    _clearSound: function(node) {
      var checkIE = /MSIE |Trident\//.test(Howler._navigator && Howler._navigator.userAgent);
      if (!checkIE) {
        node.src = 'data:audio/wav;base64,UklGRigAAABXQVZFZm10IBIAAAABAAEARKwAAIhYAQACABAAAABkYXRhAgAAAAEA';
      }
    }
  };

  /** Single Sound Methods **/
  /***************************************************************************/

  /**
   * Setup the sound object, which each node attached to a Howl group is contained in.
   * @param {Object} howl The Howl parent group.
   */
  var Sound = function(howl) {
    this._parent = howl;
    this.init();
  };
  Sound.prototype = {
    /**
     * Initialize a new Sound object.
     * @return {Sound}
     */
    init: function() {
      var self = this;
      var parent = self._parent;

      // Setup the default parameters.
      self._muted = parent._muted;
      self._loop = parent._loop;
      self._volume = parent._volume;
      self._rate = parent._rate;
      self._seek = 0;
      self._paused = true;
      self._ended = true;
      self._sprite = '__default';

      // Generate a unique ID for this sound.
      self._id = ++Howler._counter;

      // Add itself to the parent's pool.
      parent._sounds.push(self);

      // Create the new node.
      self.create();

      return self;
    },

    /**
     * Create and setup a new sound object, whether HTML5 Audio or Web Audio.
     * @return {Sound}
     */
    create: function() {
      var self = this;
      var parent = self._parent;
      var volume = (Howler._muted || self._muted || self._parent._muted) ? 0 : self._volume;

      if (parent._webAudio) {
        // Create the gain node for controlling volume (the source will connect to this).
        self._node = (typeof Howler.ctx.createGain === 'undefined') ? Howler.ctx.createGainNode() : Howler.ctx.createGain();
        self._node.gain.setValueAtTime(volume, Howler.ctx.currentTime);
        self._node.paused = true;
        self._node.connect(Howler.masterGain);
      } else if (!Howler.noAudio) {
        // Get an unlocked Audio object from the pool.
        self._node = Howler._obtainHtml5Audio();

        // Listen for errors (http://dev.w3.org/html5/spec-author-view/spec.html#mediaerror).
        self._errorFn = self._errorListener.bind(self);
        self._node.addEventListener('error', self._errorFn, false);

        // Listen for 'canplaythrough' event to let us know the sound is ready.
        self._loadFn = self._loadListener.bind(self);
        self._node.addEventListener(Howler._canPlayEvent, self._loadFn, false);

        // Setup the new audio node.
        self._node.src = parent._src;
        self._node.preload = parent._preload === true ? 'auto' : parent._preload;
        self._node.volume = volume * Howler.volume();

        // Begin loading the source.
        self._node.load();
      }

      return self;
    },

    /**
     * Reset the parameters of this sound to the original state (for recycle).
     * @return {Sound}
     */
    reset: function() {
      var self = this;
      var parent = self._parent;

      // Reset all of the parameters of this sound.
      self._muted = parent._muted;
      self._loop = parent._loop;
      self._volume = parent._volume;
      self._rate = parent._rate;
      self._seek = 0;
      self._rateSeek = 0;
      self._paused = true;
      self._ended = true;
      self._sprite = '__default';

      // Generate a new ID so that it isn't confused with the previous sound.
      self._id = ++Howler._counter;

      return self;
    },

    /**
     * HTML5 Audio error listener callback.
     */
    _errorListener: function() {
      var self = this;

      // Fire an error event and pass back the code.
      self._parent._emit('loaderror', self._id, self._node.error ? self._node.error.code : 0);

      // Clear the event listener.
      self._node.removeEventListener('error', self._errorFn, false);
    },

    /**
     * HTML5 Audio canplaythrough listener callback.
     */
    _loadListener: function() {
      var self = this;
      var parent = self._parent;

      // Round up the duration to account for the lower precision in HTML5 Audio.
      parent._duration = Math.ceil(self._node.duration * 10) / 10;

      // Setup a sprite if none is defined.
      if (Object.keys(parent._sprite).length === 0) {
        parent._sprite = {__default: [0, parent._duration * 1000]};
      }

      if (parent._state !== 'loaded') {
        parent._state = 'loaded';
        parent._emit('load');
        parent._loadQueue();
      }

      // Clear the event listener.
      self._node.removeEventListener(Howler._canPlayEvent, self._loadFn, false);
    }
  };

  /** Helper Methods **/
  /***************************************************************************/

  var cache = {};

  /**
   * Buffer a sound from URL, Data URI or cache and decode to audio source (Web Audio API).
   * @param  {Howl} self
   */
  var loadBuffer = function(self) {
    var url = self._src;

    // Check if the buffer has already been cached and use it instead.
    if (cache[url]) {
      // Set the duration from the cache.
      self._duration = cache[url].duration;

      // Load the sound into this Howl.
      loadSound(self);

      return;
    }

    if (/^data:[^;]+;base64,/.test(url)) {
      // Decode the base64 data URI without XHR, since some browsers don't support it.
      var data = atob(url.split(',')[1]);
      var dataView = new Uint8Array(data.length);
      for (var i=0; i<data.length; ++i) {
        dataView[i] = data.charCodeAt(i);
      }

      decodeAudioData(dataView.buffer, self);
    } else {
      // Load the buffer from the URL.
      var xhr = new XMLHttpRequest();
      xhr.open(self._xhr.method, url, true);
      xhr.withCredentials = self._xhr.withCredentials;
      xhr.responseType = 'arraybuffer';

      // Apply any custom headers to the request.
      if (self._xhr.headers) {
        Object.keys(self._xhr.headers).forEach(function(key) {
          xhr.setRequestHeader(key, self._xhr.headers[key]);
        });
      }

      xhr.onload = function() {
        // Make sure we get a successful response back.
        var code = (xhr.status + '')[0];
        if (code !== '0' && code !== '2' && code !== '3') {
          self._emit('loaderror', null, 'Failed loading audio file with status: ' + xhr.status + '.');
          return;
        }

        decodeAudioData(xhr.response, self);
      };
      xhr.onerror = function() {
        // If there is an error, switch to HTML5 Audio.
        if (self._webAudio) {
          self._html5 = true;
          self._webAudio = false;
          self._sounds = [];
          delete cache[url];
          self.load();
        }
      };
      safeXhrSend(xhr);
    }
  };

  /**
   * Send the XHR request wrapped in a try/catch.
   * @param  {Object} xhr XHR to send.
   */
  var safeXhrSend = function(xhr) {
    try {
      xhr.send();
    } catch (e) {
      xhr.onerror();
    }
  };

  /**
   * Decode audio data from an array buffer.
   * @param  {ArrayBuffer} arraybuffer The audio data.
   * @param  {Howl}        self
   */
  var decodeAudioData = function(arraybuffer, self) {
    // Fire a load error if something broke.
    var error = function() {
      self._emit('loaderror', null, 'Decoding audio data failed.');
    };

    // Load the sound on success.
    var success = function(buffer) {
      if (buffer && self._sounds.length > 0) {
        cache[self._src] = buffer;
        loadSound(self, buffer);
      } else {
        error();
      }
    };

    // Decode the buffer into an audio source.
    if (typeof Promise !== 'undefined' && Howler.ctx.decodeAudioData.length === 1) {
      Howler.ctx.decodeAudioData(arraybuffer).then(success).catch(error);
    } else {
      Howler.ctx.decodeAudioData(arraybuffer, success, error);
    }
  }

  /**
   * Sound is now loaded, so finish setting everything up and fire the loaded event.
   * @param  {Howl} self
   * @param  {Object} buffer The decoded buffer sound source.
   */
  var loadSound = function(self, buffer) {
    // Set the duration.
    if (buffer && !self._duration) {
      self._duration = buffer.duration;
    }

    // Setup a sprite if none is defined.
    if (Object.keys(self._sprite).length === 0) {
      self._sprite = {__default: [0, self._duration * 1000]};
    }

    // Fire the loaded event.
    if (self._state !== 'loaded') {
      self._state = 'loaded';
      self._emit('load');
      self._loadQueue();
    }
  };

  /**
   * Setup the audio context when available, or switch to HTML5 Audio mode.
   */
  var setupAudioContext = function() {
    // If we have already detected that Web Audio isn't supported, don't run this step again.
    if (!Howler.usingWebAudio) {
      return;
    }

    // Check if we are using Web Audio and setup the AudioContext if we are.
    try {
      if (typeof AudioContext !== 'undefined') {
        Howler.ctx = new AudioContext();
      } else if (typeof webkitAudioContext !== 'undefined') {
        Howler.ctx = new webkitAudioContext();
      } else {
        Howler.usingWebAudio = false;
      }
    } catch(e) {
      Howler.usingWebAudio = false;
    }

    // If the audio context creation still failed, set using web audio to false.
    if (!Howler.ctx) {
      Howler.usingWebAudio = false;
    }

    // Check if a webview is being used on iOS8 or earlier (rather than the browser).
    // If it is, disable Web Audio as it causes crashing.
    var iOS = (/iP(hone|od|ad)/.test(Howler._navigator && Howler._navigator.platform));
    var appVersion = Howler._navigator && Howler._navigator.appVersion.match(/OS (\d+)_(\d+)_?(\d+)?/);
    var version = appVersion ? parseInt(appVersion[1], 10) : null;
    if (iOS && version && version < 9) {
      var safari = /safari/.test(Howler._navigator && Howler._navigator.userAgent.toLowerCase());
      if (Howler._navigator && !safari) {
        Howler.usingWebAudio = false;
      }
    }

    // Create and expose the master GainNode when using Web Audio (useful for plugins or advanced usage).
    if (Howler.usingWebAudio) {
      Howler.masterGain = (typeof Howler.ctx.createGain === 'undefined') ? Howler.ctx.createGainNode() : Howler.ctx.createGain();
      Howler.masterGain.gain.setValueAtTime(Howler._muted ? 0 : Howler._volume, Howler.ctx.currentTime);
      Howler.masterGain.connect(Howler.ctx.destination);
    }

    // Re-run the setup on Howler.
    Howler._setup();
  };

  // Add support for AMD (Asynchronous Module Definition) libraries such as require.js.
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
      return {
        Howler: Howler,
        Howl: Howl
      };
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  }

  // Add support for CommonJS libraries such as browserify.
  if (true) {
    exports.Howler = Howler;
    exports.Howl = Howl;
  }

  // Add to global in Node.js (for testing, etc).
  if (typeof global !== 'undefined') {
    global.HowlerGlobal = HowlerGlobal;
    global.Howler = Howler;
    global.Howl = Howl;
    global.Sound = Sound;
  } else if (typeof window !== 'undefined') {  // Define globally in case AMD is not available or unused.
    window.HowlerGlobal = HowlerGlobal;
    window.Howler = Howler;
    window.Howl = Howl;
    window.Sound = Sound;
  }
})();


/*!
 *  Spatial Plugin - Adds support for stereo and 3D audio where Web Audio is supported.
 *  
 *  howler.js v2.2.0
 *  howlerjs.com
 *
 *  (c) 2013-2020, James Simpson of GoldFire Studios
 *  goldfirestudios.com
 *
 *  MIT License
 */

(function() {

  'use strict';

  // Setup default properties.
  HowlerGlobal.prototype._pos = [0, 0, 0];
  HowlerGlobal.prototype._orientation = [0, 0, -1, 0, 1, 0];

  /** Global Methods **/
  /***************************************************************************/

  /**
   * Helper method to update the stereo panning position of all current Howls.
   * Future Howls will not use this value unless explicitly set.
   * @param  {Number} pan A value of -1.0 is all the way left and 1.0 is all the way right.
   * @return {Howler/Number}     Self or current stereo panning value.
   */
  HowlerGlobal.prototype.stereo = function(pan) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self.ctx || !self.ctx.listener) {
      return self;
    }

    // Loop through all Howls and update their stereo panning.
    for (var i=self._howls.length-1; i>=0; i--) {
      self._howls[i].stereo(pan);
    }

    return self;
  };

  /**
   * Get/set the position of the listener in 3D cartesian space. Sounds using
   * 3D position will be relative to the listener's position.
   * @param  {Number} x The x-position of the listener.
   * @param  {Number} y The y-position of the listener.
   * @param  {Number} z The z-position of the listener.
   * @return {Howler/Array}   Self or current listener position.
   */
  HowlerGlobal.prototype.pos = function(x, y, z) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self.ctx || !self.ctx.listener) {
      return self;
    }

    // Set the defaults for optional 'y' & 'z'.
    y = (typeof y !== 'number') ? self._pos[1] : y;
    z = (typeof z !== 'number') ? self._pos[2] : z;

    if (typeof x === 'number') {
      self._pos = [x, y, z];

      if (typeof self.ctx.listener.positionX !== 'undefined') {
        self.ctx.listener.positionX.setTargetAtTime(self._pos[0], Howler.ctx.currentTime, 0.1);
        self.ctx.listener.positionY.setTargetAtTime(self._pos[1], Howler.ctx.currentTime, 0.1);
        self.ctx.listener.positionZ.setTargetAtTime(self._pos[2], Howler.ctx.currentTime, 0.1);
      } else {
        self.ctx.listener.setPosition(self._pos[0], self._pos[1], self._pos[2]);
      }
    } else {
      return self._pos;
    }

    return self;
  };

  /**
   * Get/set the direction the listener is pointing in the 3D cartesian space.
   * A front and up vector must be provided. The front is the direction the
   * face of the listener is pointing, and up is the direction the top of the
   * listener is pointing. Thus, these values are expected to be at right angles
   * from each other.
   * @param  {Number} x   The x-orientation of the listener.
   * @param  {Number} y   The y-orientation of the listener.
   * @param  {Number} z   The z-orientation of the listener.
   * @param  {Number} xUp The x-orientation of the top of the listener.
   * @param  {Number} yUp The y-orientation of the top of the listener.
   * @param  {Number} zUp The z-orientation of the top of the listener.
   * @return {Howler/Array}     Returns self or the current orientation vectors.
   */
  HowlerGlobal.prototype.orientation = function(x, y, z, xUp, yUp, zUp) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self.ctx || !self.ctx.listener) {
      return self;
    }

    // Set the defaults for optional 'y' & 'z'.
    var or = self._orientation;
    y = (typeof y !== 'number') ? or[1] : y;
    z = (typeof z !== 'number') ? or[2] : z;
    xUp = (typeof xUp !== 'number') ? or[3] : xUp;
    yUp = (typeof yUp !== 'number') ? or[4] : yUp;
    zUp = (typeof zUp !== 'number') ? or[5] : zUp;

    if (typeof x === 'number') {
      self._orientation = [x, y, z, xUp, yUp, zUp];

      if (typeof self.ctx.listener.forwardX !== 'undefined') {
        self.ctx.listener.forwardX.setTargetAtTime(x, Howler.ctx.currentTime, 0.1);
        self.ctx.listener.forwardY.setTargetAtTime(y, Howler.ctx.currentTime, 0.1);
        self.ctx.listener.forwardZ.setTargetAtTime(z, Howler.ctx.currentTime, 0.1);
        self.ctx.listener.upX.setTargetAtTime(xUp, Howler.ctx.currentTime, 0.1);
        self.ctx.listener.upY.setTargetAtTime(yUp, Howler.ctx.currentTime, 0.1);
        self.ctx.listener.upZ.setTargetAtTime(zUp, Howler.ctx.currentTime, 0.1);
      } else {
        self.ctx.listener.setOrientation(x, y, z, xUp, yUp, zUp);
      }
    } else {
      return or;
    }

    return self;
  };

  /** Group Methods **/
  /***************************************************************************/

  /**
   * Add new properties to the core init.
   * @param  {Function} _super Core init method.
   * @return {Howl}
   */
  Howl.prototype.init = (function(_super) {
    return function(o) {
      var self = this;

      // Setup user-defined default properties.
      self._orientation = o.orientation || [1, 0, 0];
      self._stereo = o.stereo || null;
      self._pos = o.pos || null;
      self._pannerAttr = {
        coneInnerAngle: typeof o.coneInnerAngle !== 'undefined' ? o.coneInnerAngle : 360,
        coneOuterAngle: typeof o.coneOuterAngle !== 'undefined' ? o.coneOuterAngle : 360,
        coneOuterGain: typeof o.coneOuterGain !== 'undefined' ? o.coneOuterGain : 0,
        distanceModel: typeof o.distanceModel !== 'undefined' ? o.distanceModel : 'inverse',
        maxDistance: typeof o.maxDistance !== 'undefined' ? o.maxDistance : 10000,
        panningModel: typeof o.panningModel !== 'undefined' ? o.panningModel : 'HRTF',
        refDistance: typeof o.refDistance !== 'undefined' ? o.refDistance : 1,
        rolloffFactor: typeof o.rolloffFactor !== 'undefined' ? o.rolloffFactor : 1
      };

      // Setup event listeners.
      self._onstereo = o.onstereo ? [{fn: o.onstereo}] : [];
      self._onpos = o.onpos ? [{fn: o.onpos}] : [];
      self._onorientation = o.onorientation ? [{fn: o.onorientation}] : [];

      // Complete initilization with howler.js core's init function.
      return _super.call(this, o);
    };
  })(Howl.prototype.init);

  /**
   * Get/set the stereo panning of the audio source for this sound or all in the group.
   * @param  {Number} pan  A value of -1.0 is all the way left and 1.0 is all the way right.
   * @param  {Number} id (optional) The sound ID. If none is passed, all in group will be updated.
   * @return {Howl/Number}    Returns self or the current stereo panning value.
   */
  Howl.prototype.stereo = function(pan, id) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self._webAudio) {
      return self;
    }

    // If the sound hasn't loaded, add it to the load queue to change stereo pan when capable.
    if (self._state !== 'loaded') {
      self._queue.push({
        event: 'stereo',
        action: function() {
          self.stereo(pan, id);
        }
      });

      return self;
    }

    // Check for PannerStereoNode support and fallback to PannerNode if it doesn't exist.
    var pannerType = (typeof Howler.ctx.createStereoPanner === 'undefined') ? 'spatial' : 'stereo';

    // Setup the group's stereo panning if no ID is passed.
    if (typeof id === 'undefined') {
      // Return the group's stereo panning if no parameters are passed.
      if (typeof pan === 'number') {
        self._stereo = pan;
        self._pos = [pan, 0, 0];
      } else {
        return self._stereo;
      }
    }

    // Change the streo panning of one or all sounds in group.
    var ids = self._getSoundIds(id);
    for (var i=0; i<ids.length; i++) {
      // Get the sound.
      var sound = self._soundById(ids[i]);

      if (sound) {
        if (typeof pan === 'number') {
          sound._stereo = pan;
          sound._pos = [pan, 0, 0];

          if (sound._node) {
            // If we are falling back, make sure the panningModel is equalpower.
            sound._pannerAttr.panningModel = 'equalpower';

            // Check if there is a panner setup and create a new one if not.
            if (!sound._panner || !sound._panner.pan) {
              setupPanner(sound, pannerType);
            }

            if (pannerType === 'spatial') {
              if (typeof sound._panner.positionX !== 'undefined') {
                sound._panner.positionX.setValueAtTime(pan, Howler.ctx.currentTime);
                sound._panner.positionY.setValueAtTime(0, Howler.ctx.currentTime);
                sound._panner.positionZ.setValueAtTime(0, Howler.ctx.currentTime);
              } else {
                sound._panner.setPosition(pan, 0, 0);
              }
            } else {
              sound._panner.pan.setValueAtTime(pan, Howler.ctx.currentTime);
            }
          }

          self._emit('stereo', sound._id);
        } else {
          return sound._stereo;
        }
      }
    }

    return self;
  };

  /**
   * Get/set the 3D spatial position of the audio source for this sound or group relative to the global listener.
   * @param  {Number} x  The x-position of the audio source.
   * @param  {Number} y  The y-position of the audio source.
   * @param  {Number} z  The z-position of the audio source.
   * @param  {Number} id (optional) The sound ID. If none is passed, all in group will be updated.
   * @return {Howl/Array}    Returns self or the current 3D spatial position: [x, y, z].
   */
  Howl.prototype.pos = function(x, y, z, id) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self._webAudio) {
      return self;
    }

    // If the sound hasn't loaded, add it to the load queue to change position when capable.
    if (self._state !== 'loaded') {
      self._queue.push({
        event: 'pos',
        action: function() {
          self.pos(x, y, z, id);
        }
      });

      return self;
    }

    // Set the defaults for optional 'y' & 'z'.
    y = (typeof y !== 'number') ? 0 : y;
    z = (typeof z !== 'number') ? -0.5 : z;

    // Setup the group's spatial position if no ID is passed.
    if (typeof id === 'undefined') {
      // Return the group's spatial position if no parameters are passed.
      if (typeof x === 'number') {
        self._pos = [x, y, z];
      } else {
        return self._pos;
      }
    }

    // Change the spatial position of one or all sounds in group.
    var ids = self._getSoundIds(id);
    for (var i=0; i<ids.length; i++) {
      // Get the sound.
      var sound = self._soundById(ids[i]);

      if (sound) {
        if (typeof x === 'number') {
          sound._pos = [x, y, z];

          if (sound._node) {
            // Check if there is a panner setup and create a new one if not.
            if (!sound._panner || sound._panner.pan) {
              setupPanner(sound, 'spatial');
            }

            if (typeof sound._panner.positionX !== 'undefined') {
              sound._panner.positionX.setValueAtTime(x, Howler.ctx.currentTime);
              sound._panner.positionY.setValueAtTime(y, Howler.ctx.currentTime);
              sound._panner.positionZ.setValueAtTime(z, Howler.ctx.currentTime);
            } else {
              sound._panner.setPosition(x, y, z);
            }
          }

          self._emit('pos', sound._id);
        } else {
          return sound._pos;
        }
      }
    }

    return self;
  };

  /**
   * Get/set the direction the audio source is pointing in the 3D cartesian coordinate
   * space. Depending on how direction the sound is, based on the `cone` attributes,
   * a sound pointing away from the listener can be quiet or silent.
   * @param  {Number} x  The x-orientation of the source.
   * @param  {Number} y  The y-orientation of the source.
   * @param  {Number} z  The z-orientation of the source.
   * @param  {Number} id (optional) The sound ID. If none is passed, all in group will be updated.
   * @return {Howl/Array}    Returns self or the current 3D spatial orientation: [x, y, z].
   */
  Howl.prototype.orientation = function(x, y, z, id) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self._webAudio) {
      return self;
    }

    // If the sound hasn't loaded, add it to the load queue to change orientation when capable.
    if (self._state !== 'loaded') {
      self._queue.push({
        event: 'orientation',
        action: function() {
          self.orientation(x, y, z, id);
        }
      });

      return self;
    }

    // Set the defaults for optional 'y' & 'z'.
    y = (typeof y !== 'number') ? self._orientation[1] : y;
    z = (typeof z !== 'number') ? self._orientation[2] : z;

    // Setup the group's spatial orientation if no ID is passed.
    if (typeof id === 'undefined') {
      // Return the group's spatial orientation if no parameters are passed.
      if (typeof x === 'number') {
        self._orientation = [x, y, z];
      } else {
        return self._orientation;
      }
    }

    // Change the spatial orientation of one or all sounds in group.
    var ids = self._getSoundIds(id);
    for (var i=0; i<ids.length; i++) {
      // Get the sound.
      var sound = self._soundById(ids[i]);

      if (sound) {
        if (typeof x === 'number') {
          sound._orientation = [x, y, z];

          if (sound._node) {
            // Check if there is a panner setup and create a new one if not.
            if (!sound._panner) {
              // Make sure we have a position to setup the node with.
              if (!sound._pos) {
                sound._pos = self._pos || [0, 0, -0.5];
              }

              setupPanner(sound, 'spatial');
            }

            if (typeof sound._panner.orientationX !== 'undefined') {
              sound._panner.orientationX.setValueAtTime(x, Howler.ctx.currentTime);
              sound._panner.orientationY.setValueAtTime(y, Howler.ctx.currentTime);
              sound._panner.orientationZ.setValueAtTime(z, Howler.ctx.currentTime);
            } else {
              sound._panner.setOrientation(x, y, z);
            }
          }

          self._emit('orientation', sound._id);
        } else {
          return sound._orientation;
        }
      }
    }

    return self;
  };

  /**
   * Get/set the panner node's attributes for a sound or group of sounds.
   * This method can optionall take 0, 1 or 2 arguments.
   *   pannerAttr() -> Returns the group's values.
   *   pannerAttr(id) -> Returns the sound id's values.
   *   pannerAttr(o) -> Set's the values of all sounds in this Howl group.
   *   pannerAttr(o, id) -> Set's the values of passed sound id.
   *
   *   Attributes:
   *     coneInnerAngle - (360 by default) A parameter for directional audio sources, this is an angle, in degrees,
   *                      inside of which there will be no volume reduction.
   *     coneOuterAngle - (360 by default) A parameter for directional audio sources, this is an angle, in degrees,
   *                      outside of which the volume will be reduced to a constant value of `coneOuterGain`.
   *     coneOuterGain - (0 by default) A parameter for directional audio sources, this is the gain outside of the
   *                     `coneOuterAngle`. It is a linear value in the range `[0, 1]`.
   *     distanceModel - ('inverse' by default) Determines algorithm used to reduce volume as audio moves away from
   *                     listener. Can be `linear`, `inverse` or `exponential.
   *     maxDistance - (10000 by default) The maximum distance between source and listener, after which the volume
   *                   will not be reduced any further.
   *     refDistance - (1 by default) A reference distance for reducing volume as source moves further from the listener.
   *                   This is simply a variable of the distance model and has a different effect depending on which model
   *                   is used and the scale of your coordinates. Generally, volume will be equal to 1 at this distance.
   *     rolloffFactor - (1 by default) How quickly the volume reduces as source moves from listener. This is simply a
   *                     variable of the distance model and can be in the range of `[0, 1]` with `linear` and `[0, ∞]`
   *                     with `inverse` and `exponential`.
   *     panningModel - ('HRTF' by default) Determines which spatialization algorithm is used to position audio.
   *                     Can be `HRTF` or `equalpower`.
   *
   * @return {Howl/Object} Returns self or current panner attributes.
   */
  Howl.prototype.pannerAttr = function() {
    var self = this;
    var args = arguments;
    var o, id, sound;

    // Stop right here if not using Web Audio.
    if (!self._webAudio) {
      return self;
    }

    // Determine the values based on arguments.
    if (args.length === 0) {
      // Return the group's panner attribute values.
      return self._pannerAttr;
    } else if (args.length === 1) {
      if (typeof args[0] === 'object') {
        o = args[0];

        // Set the grou's panner attribute values.
        if (typeof id === 'undefined') {
          if (!o.pannerAttr) {
            o.pannerAttr = {
              coneInnerAngle: o.coneInnerAngle,
              coneOuterAngle: o.coneOuterAngle,
              coneOuterGain: o.coneOuterGain,
              distanceModel: o.distanceModel,
              maxDistance: o.maxDistance,
              refDistance: o.refDistance,
              rolloffFactor: o.rolloffFactor,
              panningModel: o.panningModel
            };
          }

          self._pannerAttr = {
            coneInnerAngle: typeof o.pannerAttr.coneInnerAngle !== 'undefined' ? o.pannerAttr.coneInnerAngle : self._coneInnerAngle,
            coneOuterAngle: typeof o.pannerAttr.coneOuterAngle !== 'undefined' ? o.pannerAttr.coneOuterAngle : self._coneOuterAngle,
            coneOuterGain: typeof o.pannerAttr.coneOuterGain !== 'undefined' ? o.pannerAttr.coneOuterGain : self._coneOuterGain,
            distanceModel: typeof o.pannerAttr.distanceModel !== 'undefined' ? o.pannerAttr.distanceModel : self._distanceModel,
            maxDistance: typeof o.pannerAttr.maxDistance !== 'undefined' ? o.pannerAttr.maxDistance : self._maxDistance,
            refDistance: typeof o.pannerAttr.refDistance !== 'undefined' ? o.pannerAttr.refDistance : self._refDistance,
            rolloffFactor: typeof o.pannerAttr.rolloffFactor !== 'undefined' ? o.pannerAttr.rolloffFactor : self._rolloffFactor,
            panningModel: typeof o.pannerAttr.panningModel !== 'undefined' ? o.pannerAttr.panningModel : self._panningModel
          };
        }
      } else {
        // Return this sound's panner attribute values.
        sound = self._soundById(parseInt(args[0], 10));
        return sound ? sound._pannerAttr : self._pannerAttr;
      }
    } else if (args.length === 2) {
      o = args[0];
      id = parseInt(args[1], 10);
    }

    // Update the values of the specified sounds.
    var ids = self._getSoundIds(id);
    for (var i=0; i<ids.length; i++) {
      sound = self._soundById(ids[i]);

      if (sound) {
        // Merge the new values into the sound.
        var pa = sound._pannerAttr;
        pa = {
          coneInnerAngle: typeof o.coneInnerAngle !== 'undefined' ? o.coneInnerAngle : pa.coneInnerAngle,
          coneOuterAngle: typeof o.coneOuterAngle !== 'undefined' ? o.coneOuterAngle : pa.coneOuterAngle,
          coneOuterGain: typeof o.coneOuterGain !== 'undefined' ? o.coneOuterGain : pa.coneOuterGain,
          distanceModel: typeof o.distanceModel !== 'undefined' ? o.distanceModel : pa.distanceModel,
          maxDistance: typeof o.maxDistance !== 'undefined' ? o.maxDistance : pa.maxDistance,
          refDistance: typeof o.refDistance !== 'undefined' ? o.refDistance : pa.refDistance,
          rolloffFactor: typeof o.rolloffFactor !== 'undefined' ? o.rolloffFactor : pa.rolloffFactor,
          panningModel: typeof o.panningModel !== 'undefined' ? o.panningModel : pa.panningModel
        };

        // Update the panner values or create a new panner if none exists.
        var panner = sound._panner;
        if (panner) {
          panner.coneInnerAngle = pa.coneInnerAngle;
          panner.coneOuterAngle = pa.coneOuterAngle;
          panner.coneOuterGain = pa.coneOuterGain;
          panner.distanceModel = pa.distanceModel;
          panner.maxDistance = pa.maxDistance;
          panner.refDistance = pa.refDistance;
          panner.rolloffFactor = pa.rolloffFactor;
          panner.panningModel = pa.panningModel;
        } else {
          // Make sure we have a position to setup the node with.
          if (!sound._pos) {
            sound._pos = self._pos || [0, 0, -0.5];
          }

          // Create a new panner node.
          setupPanner(sound, 'spatial');
        }
      }
    }

    return self;
  };

  /** Single Sound Methods **/
  /***************************************************************************/

  /**
   * Add new properties to the core Sound init.
   * @param  {Function} _super Core Sound init method.
   * @return {Sound}
   */
  Sound.prototype.init = (function(_super) {
    return function() {
      var self = this;
      var parent = self._parent;

      // Setup user-defined default properties.
      self._orientation = parent._orientation;
      self._stereo = parent._stereo;
      self._pos = parent._pos;
      self._pannerAttr = parent._pannerAttr;

      // Complete initilization with howler.js core Sound's init function.
      _super.call(this);

      // If a stereo or position was specified, set it up.
      if (self._stereo) {
        parent.stereo(self._stereo);
      } else if (self._pos) {
        parent.pos(self._pos[0], self._pos[1], self._pos[2], self._id);
      }
    };
  })(Sound.prototype.init);

  /**
   * Override the Sound.reset method to clean up properties from the spatial plugin.
   * @param  {Function} _super Sound reset method.
   * @return {Sound}
   */
  Sound.prototype.reset = (function(_super) {
    return function() {
      var self = this;
      var parent = self._parent;

      // Reset all spatial plugin properties on this sound.
      self._orientation = parent._orientation;
      self._stereo = parent._stereo;
      self._pos = parent._pos;
      self._pannerAttr = parent._pannerAttr;

      // If a stereo or position was specified, set it up.
      if (self._stereo) {
        parent.stereo(self._stereo);
      } else if (self._pos) {
        parent.pos(self._pos[0], self._pos[1], self._pos[2], self._id);
      } else if (self._panner) {
        // Disconnect the panner.
        self._panner.disconnect(0);
        self._panner = undefined;
        parent._refreshBuffer(self);
      }

      // Complete resetting of the sound.
      return _super.call(this);
    };
  })(Sound.prototype.reset);

  /** Helper Methods **/
  /***************************************************************************/

  /**
   * Create a new panner node and save it on the sound.
   * @param  {Sound} sound Specific sound to setup panning on.
   * @param {String} type Type of panner to create: 'stereo' or 'spatial'.
   */
  var setupPanner = function(sound, type) {
    type = type || 'spatial';

    // Create the new panner node.
    if (type === 'spatial') {
      sound._panner = Howler.ctx.createPanner();
      sound._panner.coneInnerAngle = sound._pannerAttr.coneInnerAngle;
      sound._panner.coneOuterAngle = sound._pannerAttr.coneOuterAngle;
      sound._panner.coneOuterGain = sound._pannerAttr.coneOuterGain;
      sound._panner.distanceModel = sound._pannerAttr.distanceModel;
      sound._panner.maxDistance = sound._pannerAttr.maxDistance;
      sound._panner.refDistance = sound._pannerAttr.refDistance;
      sound._panner.rolloffFactor = sound._pannerAttr.rolloffFactor;
      sound._panner.panningModel = sound._pannerAttr.panningModel;

      if (typeof sound._panner.positionX !== 'undefined') {
        sound._panner.positionX.setValueAtTime(sound._pos[0], Howler.ctx.currentTime);
        sound._panner.positionY.setValueAtTime(sound._pos[1], Howler.ctx.currentTime);
        sound._panner.positionZ.setValueAtTime(sound._pos[2], Howler.ctx.currentTime);
      } else {
        sound._panner.setPosition(sound._pos[0], sound._pos[1], sound._pos[2]);
      }

      if (typeof sound._panner.orientationX !== 'undefined') {
        sound._panner.orientationX.setValueAtTime(sound._orientation[0], Howler.ctx.currentTime);
        sound._panner.orientationY.setValueAtTime(sound._orientation[1], Howler.ctx.currentTime);
        sound._panner.orientationZ.setValueAtTime(sound._orientation[2], Howler.ctx.currentTime);
      } else {
        sound._panner.setOrientation(sound._orientation[0], sound._orientation[1], sound._orientation[2]);
      }
    } else {
      sound._panner = Howler.ctx.createStereoPanner();
      sound._panner.pan.setValueAtTime(sound._stereo, Howler.ctx.currentTime);
    }

    sound._panner.connect(sound._node);

    // Update the connections.
    if (!sound._paused) {
      sound._parent.pause(sound._id, true).play(sound._id, true);
    }
  };
})();


/***/ }),

/***/ "./src/app/core/services/sound-manager.service.ts":
/*!********************************************************!*\
  !*** ./src/app/core/services/sound-manager.service.ts ***!
  \********************************************************/
/*! exports provided: SoundManagerService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SoundManagerService", function() { return SoundManagerService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var howler__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! howler */ "./node_modules/howler/dist/howler.js");
/* harmony import */ var howler__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(howler__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ "./node_modules/rxjs/_esm5/index.js");




var SoundManagerService = /** @class */ (function () {
    function SoundManagerService() {
        var _this = this;
        this.backgroundPaused = true;
        this.loadedSounds = new rxjs__WEBPACK_IMPORTED_MODULE_3__["BehaviorSubject"](0);
        if (!this.backgroundMusic) {
            this.backgroundMusic = new howler__WEBPACK_IMPORTED_MODULE_2__["Howl"]({
                src: ['assets/sounds/BGM1.mp3', 'assets/sounds/BGM2.mp3'],
                autoplay: false,
                loop: true,
                volume: 0.5,
                onload: function () { return _this.loadedSounds.next(_this.loadedSounds.getValue() + 1); }
            });
            this.sound = {
                win: new howler__WEBPACK_IMPORTED_MODULE_2__["Howl"]({
                    src: ['assets/sounds/win.mp3'],
                    autoplay: false,
                    loop: false,
                    volume: 0.5,
                    onload: function () { return _this.loadedSounds.next(_this.loadedSounds.getValue() + 1); }
                }),
                lose: new howler__WEBPACK_IMPORTED_MODULE_2__["Howl"]({
                    src: ['assets/sounds/lose.mp3'],
                    autoplay: false,
                    loop: false,
                    volume: 0.5,
                    onload: function () { return _this.loadedSounds.next(_this.loadedSounds.getValue() + 1); }
                }),
                correct: new howler__WEBPACK_IMPORTED_MODULE_2__["Howl"]({
                    src: ['assets/sounds/correct.mp3'],
                    autoplay: false,
                    loop: false,
                    volume: 0.5,
                    onload: function () { return _this.loadedSounds.next(_this.loadedSounds.getValue() + 1); }
                }),
                wrong: new howler__WEBPACK_IMPORTED_MODULE_2__["Howl"]({
                    src: ['assets/sounds/wrong.mp3'],
                    autoplay: false,
                    loop: false,
                    volume: 0.5,
                    onload: function () { return _this.loadedSounds.next(_this.loadedSounds.getValue() + 1); }
                })
            };
        }
    }
    Object.defineProperty(SoundManagerService.prototype, "sounds", {
        get: function () {
            return this.loadedSounds;
        },
        enumerable: true,
        configurable: true
    });
    SoundManagerService.prototype.stopBackgroundMusic = function () {
        this.backgroundPaused = true;
        this.backgroundMusic.pause();
    };
    SoundManagerService.prototype.playBackgroundMusic = function () {
        if (this.backgroundPaused) {
            this.backgroundPaused = false;
            this.backgroundMusic.play();
        }
    };
    SoundManagerService.prototype.stopAllSounds = function () {
        // Object.keys(this.sound).forEach((key) => this.sound[key].stop());
        this.sound.win.stop();
    };
    SoundManagerService.prototype.playSoundByPath = function (path) {
        this.sound[path].play();
    };
    SoundManagerService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [])
    ], SoundManagerService);
    return SoundManagerService;
}());



/***/ }),

/***/ "./src/app/core/utils/shuffle-array.ts":
/*!*********************************************!*\
  !*** ./src/app/core/utils/shuffle-array.ts ***!
  \*********************************************/
/*! exports provided: shuffleArray */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "shuffleArray", function() { return shuffleArray; });
function shuffleArray(array) {
    var currentIndex = array.length, temporaryValue, randomIndex;
    while (0 !== currentIndex) {
        randomIndex = Math.floor(Math.random() * currentIndex);
        currentIndex -= 1;
        temporaryValue = array[currentIndex];
        array[currentIndex] = array[randomIndex];
        array[randomIndex] = temporaryValue;
    }
    return array;
}


/***/ }),

/***/ "./src/app/main/congrats/congrats.component.html":
/*!*******************************************************!*\
  !*** ./src/app/main/congrats/congrats.component.html ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pa-congrats\">\r\n  <canvas id=\"confetti\">\r\n  </canvas>\r\n\r\n  <div class=\"pa-congrats__container\">\r\n    <span>\r\n      CONGRATULATIONS!\r\n    </span>\r\n    <p>\r\n      {{ score }}/5\r\n    </p>\r\n    <span>\r\n      YOU EARNED A GIFT!\r\n    </span>\r\n    <div\r\n    (click)=\"tryItAgain()\"\r\n    class=\"pa-congrats__try-it-again animate__bounceInUp animate__animated animate__delay-1s\"\r\n  >\r\n    PLAY AGAIN\r\n  </div>\r\n  </div>\r\n</div>"

/***/ }),

/***/ "./src/app/main/congrats/congrats.component.scss":
/*!*******************************************************!*\
  !*** ./src/app/main/congrats/congrats.component.scss ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pa-congrats {\n  min-height: 100vh;\n  width: 100%;\n  background-image: url('bg.png');\n  background-size: cover;\n  background-position: center;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  font-family: 'Abbott'; }\n  .pa-congrats__try-it-again {\n    background-color: #45275A;\n    color: #fefefe;\n    font-weight: bold;\n    padding-top: 10px;\n    padding-left: 18px;\n    padding-right: 18px;\n    padding-bottom: 10px;\n    transition: 0.2s linear;\n    border-radius: 24px;\n    cursor: pointer; }\n  @media (min-width: 320px) {\n      .pa-congrats__try-it-again {\n        font-size: 20px;\n        margin-top: 30px; } }\n  @media (min-width: 640px) {\n      .pa-congrats__try-it-again {\n        font-size: 28px;\n        margin-top: 48px; } }\n  @media (min-width: 992px) {\n      .pa-congrats__try-it-again {\n        font-size: 32px;\n        margin-top: 72px; } }\n  @media (min-width: 1200px) {\n      .pa-congrats__try-it-again {\n        font-size: 36px;\n        margin-top: 84px; } }\n  @media (min-width: 1600px) {\n      .pa-congrats__try-it-again {\n        font-size: 42px;\n        margin-top: 100px; } }\n  .pa-congrats__try-it-again:hover {\n      padding-top: 12px;\n      padding-left: 20px;\n      padding-right: 20px;\n      padding-bottom: 12px; }\n  .pa-congrats__try-it-again:active {\n      padding-top: 8px;\n      padding-left: 16px;\n      padding-right: 16px;\n      padding-bottom: 8px; }\n  .pa-congrats__container {\n    display: flex;\n    flex-direction: column;\n    justify-content: center;\n    align-items: center;\n    height: -webkit-fit-content;\n    height: -moz-fit-content;\n    height: fit-content;\n    width: -webkit-fit-content;\n    width: -moz-fit-content;\n    width: fit-content;\n    color: #45275A; }\n  .pa-congrats__container span {\n      font-weight: bolder; }\n  @media (min-width: 320px) {\n        .pa-congrats__container span {\n          font-size: 36px; } }\n  @media (min-width: 640px) {\n        .pa-congrats__container span {\n          font-size: 42px; } }\n  @media (min-width: 992px) {\n        .pa-congrats__container span {\n          font-size: 48px; } }\n  @media (min-width: 1200px) {\n        .pa-congrats__container span {\n          font-size: 64px; } }\n  @media (min-width: 1600px) {\n        .pa-congrats__container span {\n          font-size: 72px; } }\n  .pa-congrats__container p {\n      font-weight: 800;\n      margin-top: 10px;\n      margin-bottom: 10px; }\n  @media (min-width: 320px) {\n        .pa-congrats__container p {\n          font-size: 48px; } }\n  @media (min-width: 640px) {\n        .pa-congrats__container p {\n          font-size: 64px; } }\n  @media (min-width: 992px) {\n        .pa-congrats__container p {\n          font-size: 84px; } }\n  @media (min-width: 1200px) {\n        .pa-congrats__container p {\n          font-size: 100px; } }\n  @media (min-width: 1600px) {\n        .pa-congrats__container p {\n          font-size: 120px; } }\n  #confetti {\n  position: absolute;\n  top: 0;\n  left: 0; }\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/main/congrats/congrats.component.ts":
/*!*****************************************************!*\
  !*** ./src/app/main/congrats/congrats.component.ts ***!
  \*****************************************************/
/*! exports provided: CongratsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CongratsComponent", function() { return CongratsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var confetti_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! confetti-js */ "./node_modules/confetti-js/dist/index.es.js");
/* harmony import */ var _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/services/sound-manager.service */ "./src/app/core/services/sound-manager.service.ts");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");





var CongratsComponent = /** @class */ (function () {
    function CongratsComponent(soundManagerService, router) {
        this.soundManagerService = soundManagerService;
        this.router = router;
    }
    CongratsComponent.prototype.ngOnInit = function () {
        if (localStorage.getItem('congrats')) {
            this.score = localStorage.getItem('score');
            this.initConffetti();
        }
        else {
            this.router.navigate(['']);
        }
    };
    CongratsComponent.prototype.tryItAgain = function () {
        this.soundManagerService.stopAllSounds();
        this.router.navigate(['']);
    };
    CongratsComponent.prototype.resizeWindow = function () {
        this.initConffetti();
    };
    CongratsComponent.prototype.initConffetti = function () {
        var confettiSettings = { target: 'confetti', size: 3, rotate: true, props: ['square', 'line'], max: 120 };
        this.confetti = new confetti_js__WEBPACK_IMPORTED_MODULE_2__["default"](confettiSettings);
        this.confetti.render();
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["HostListener"])('window:resize', ['$event']),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Function),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", []),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:returntype", void 0)
    ], CongratsComponent.prototype, "resizeWindow", null);
    CongratsComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pa-congrats',
            template: __webpack_require__(/*! ./congrats.component.html */ "./src/app/main/congrats/congrats.component.html"),
            styles: [__webpack_require__(/*! ./congrats.component.scss */ "./src/app/main/congrats/congrats.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__["SoundManagerService"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"]])
    ], CongratsComponent);
    return CongratsComponent;
}());



/***/ }),

/***/ "./src/app/main/game/game.component.html":
/*!***********************************************!*\
  !*** ./src/app/main/game/game.component.html ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pa-game\">\r\n  <div *ngIf=\"startTimer > 0\" class=\"pa-game__timer-container-2\">\r\n    <span class=\"pa-game__are-you-ready\">\r\n      ARE YOU READY?\r\n    </span>\r\n    <span class=\"pa-game__timer\">\r\n      {{ startTimer }}\r\n    </span>\r\n  </div>\r\n\r\n  <div *ngIf=\"startTimer <= 0\" class=\"pa-game__container \">\r\n    <div class=\"pa-game__timer-container animate__bounceInDown animate__animated\">\r\n      <img src=\"assets/images/emphasis.png\" alt=\"Timer\" />\r\n      <div>\r\n        <span>00:{{ time }}</span>\r\n      </div>\r\n    </div>\r\n\r\n    <div class=\"pa-game__food-container\">\r\n      <ng-container *ngFor=\"let food of foods; let i = index\" > \r\n          <img class=\"pa-game__food-{{ i + 1 }} animate__bounceInLeft animate__animated\" [src]=\"food.path\" alt=\"Food\" />\r\n          <div (click)=\"selectFood(food)\" class=\"pa-game__food-{{ i + 1 }}-clickable\"> </div>\r\n        <img (click)=\"selectFood(food)\" *ngIf=\"food.selected\" class=\"pa-game__food-{{ i + 1 }}-overlay animate__zoomIn animate__animated\" [src]=\"food.correct ? 'assets/images/overlay-2.png':'assets/images/overlay.png'\" alt=\"Food\" />\r\n      </ng-container>\r\n    </div>\r\n  </div>\r\n</div>\r\n"

/***/ }),

/***/ "./src/app/main/game/game.component.scss":
/*!***********************************************!*\
  !*** ./src/app/main/game/game.component.scss ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pa-game {\n  min-height: 100vh;\n  width: 100%;\n  background-image: url('bg.png');\n  background-size: cover;\n  background-position: center;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  font-family: 'Abbott'; }\n  .pa-game__timer-container-2 {\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center; }\n  .pa-game__are-you-ready {\n    color: #45275A;\n    font-weight: bolder; }\n  @media (min-width: 320px) {\n      .pa-game__are-you-ready {\n        font-size: 32px; } }\n  @media (min-width: 640px) {\n      .pa-game__are-you-ready {\n        font-size: 36px; } }\n  @media (min-width: 992px) {\n      .pa-game__are-you-ready {\n        font-size: 42px; } }\n  @media (min-width: 1200px) {\n      .pa-game__are-you-ready {\n        font-size: 48px; } }\n  @media (min-width: 1600px) {\n      .pa-game__are-you-ready {\n        font-size: 64px; } }\n  .pa-game__container {\n    height: 100%;\n    width: 100%; }\n  .pa-game__timer-container {\n    height: -webkit-fit-content;\n    height: -moz-fit-content;\n    height: fit-content;\n    width: -webkit-fit-content;\n    width: -moz-fit-content;\n    width: fit-content;\n    position: absolute;\n    display: flex;\n    justify-content: center;\n    right: 0;\n    top: 0; }\n  .pa-game__timer-container img {\n      height: 40vh; }\n  .pa-game__timer-container div {\n      font-family: \"Digital\";\n      color: #fefefe;\n      font-weight: bold;\n      position: absolute;\n      height: 100%;\n      width: 100%;\n      display: flex;\n      justify-content: center;\n      margin-left: 11%; }\n  @media (min-width: 320px) {\n        .pa-game__timer-container div {\n          font-size: 42px;\n          margin-top: 10px; } }\n  @media (min-width: 640px) {\n        .pa-game__timer-container div {\n          font-size: 48px;\n          margin-top: 15px; } }\n  @media (min-width: 992px) {\n        .pa-game__timer-container div {\n          font-size: 72px;\n          margin-top: 20px; } }\n  @media (min-width: 1200px) {\n        .pa-game__timer-container div {\n          font-size: 84px;\n          margin-top: 25px; } }\n  @media (min-width: 1600px) {\n        .pa-game__timer-container div {\n          font-size: 120px;\n          margin-top: 30px; } }\n  .pa-game__food-container img {\n    cursor: pointer;\n    height: 34vh;\n    position: absolute;\n    transition: 0.2s linear; }\n  .pa-game__food-1 {\n    position: absolute;\n    top: 15vh;\n    left: 17vh; }\n  .pa-game__food-1-overlay {\n      position: absolute;\n      top: 15vh;\n      left: 17vh;\n      opacity: 0.5; }\n  .pa-game__food-1-clickable {\n      height: 24vh;\n      width: 24vh;\n      transform: rotate(45deg);\n      position: absolute;\n      top: 20vh;\n      left: 23vh;\n      z-index: 999;\n      cursor: pointer; }\n  .pa-game__food-2 {\n    -webkit-animation-delay: 0.1s;\n            animation-delay: 0.1s;\n    position: absolute;\n    top: 15vh;\n    left: 85vh; }\n  .pa-game__food-2-overlay {\n      position: absolute;\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s;\n      top: 15vh;\n      left: 85vh;\n      opacity: 0.5; }\n  .pa-game__food-2-clickable {\n      height: 24vh;\n      width: 24vh;\n      position: absolute;\n      top: 20vh;\n      left: 91vh;\n      transform: rotate(45deg);\n      z-index: 999;\n      cursor: pointer; }\n  .pa-game__food-3 {\n    -webkit-animation-delay: 0.15s;\n            animation-delay: 0.15s;\n    position: absolute;\n    top: 32vh;\n    left: 0; }\n  .pa-game__food-3-overlay {\n      position: absolute;\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s;\n      top: 32vh;\n      left: 0;\n      opacity: 0.5; }\n  .pa-game__food-3-clickable {\n      height: 24vh;\n      width: 24vh;\n      position: absolute;\n      top: 37vh;\n      transform: rotate(45deg);\n      z-index: 999;\n      left: 6vh;\n      cursor: pointer; }\n  .pa-game__food-4 {\n    -webkit-animation-delay: 0.2s;\n            animation-delay: 0.2s;\n    position: absolute;\n    top: 32vh;\n    left: 34vh; }\n  .pa-game__food-4-overlay {\n      position: absolute;\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s;\n      top: 32vh;\n      left: 34vh;\n      opacity: 0.5; }\n  .pa-game__food-4-clickable {\n      height: 24vh;\n      width: 24vh;\n      position: absolute;\n      top: 37vh;\n      left: 40vh;\n      transform: rotate(45deg);\n      z-index: 999;\n      cursor: pointer; }\n  .pa-game__food-5 {\n    -webkit-animation-delay: 0.25s;\n            animation-delay: 0.25s;\n    position: absolute;\n    top: 32vh;\n    left: 68vh; }\n  .pa-game__food-5-overlay {\n      position: absolute;\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s;\n      top: 32vh;\n      left: 68vh;\n      opacity: 0.5; }\n  .pa-game__food-5-clickable {\n      height: 24vh;\n      width: 24vh;\n      position: absolute;\n      top: 37vh;\n      left: 74vh;\n      transform: rotate(45deg);\n      z-index: 999;\n      cursor: pointer; }\n  .pa-game__food-6 {\n    position: absolute;\n    top: 32vh;\n    left: 102vh; }\n  .pa-game__food-6-overlay {\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s;\n      position: absolute;\n      top: 32vh;\n      left: 102vh;\n      opacity: 0.5; }\n  .pa-game__food-6-clickable {\n      height: 24vh;\n      width: 24vh;\n      position: absolute;\n      top: 37vh;\n      transform: rotate(45deg);\n      z-index: 999;\n      left: 108vh;\n      cursor: pointer; }\n  .pa-game__food-7 {\n    -webkit-animation-delay: 0.1s;\n            animation-delay: 0.1s;\n    position: absolute;\n    top: 49vh;\n    left: 17vh; }\n  .pa-game__food-7-overlay {\n      position: absolute;\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s;\n      top: 49vh;\n      left: 17vh;\n      opacity: 0.5; }\n  .pa-game__food-7-clickable {\n      height: 24vh;\n      width: 24vh;\n      position: absolute;\n      top: 54vh;\n      z-index: 999;\n      left: 23vh;\n      cursor: pointer;\n      transform: rotate(45deg); }\n  .pa-game__food-8 {\n    -webkit-animation-delay: 0.15s;\n            animation-delay: 0.15s;\n    position: absolute;\n    top: 49vh;\n    left: 51vh; }\n  .pa-game__food-8-overlay {\n      position: absolute;\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s;\n      top: 49vh;\n      left: 51vh;\n      opacity: 0.5; }\n  .pa-game__food-8-clickable {\n      height: 24vh;\n      width: 24vh;\n      position: absolute;\n      transform: rotate(45deg);\n      z-index: 999;\n      top: 54vh;\n      left: 56vh;\n      cursor: pointer; }\n  .pa-game__food-9 {\n    -webkit-animation-delay: 0.2s;\n            animation-delay: 0.2s;\n    position: absolute;\n    top: 49vh;\n    left: 85vh; }\n  .pa-game__food-9-overlay {\n      position: absolute;\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s;\n      top: 49vh;\n      left: 85vh;\n      opacity: 0.5; }\n  .pa-game__food-9-clickable {\n      height: 24vh;\n      width: 24vh;\n      position: absolute;\n      transform: rotate(45deg);\n      z-index: 999;\n      top: 54vh;\n      left: 90vh;\n      cursor: pointer; }\n  .pa-game__food-10 {\n    -webkit-animation-delay: 0.25s;\n            animation-delay: 0.25s;\n    position: absolute;\n    top: 49vh;\n    left: 119vh; }\n  .pa-game__food-10-overlay {\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s;\n      position: absolute;\n      top: 49vh;\n      left: 119vh;\n      opacity: 0.5; }\n  .pa-game__food-10-clickable {\n      height: 24vh;\n      width: 24vh;\n      position: absolute;\n      top: 54vh;\n      transform: rotate(45deg);\n      z-index: 999;\n      left: 125vh;\n      cursor: pointer; }\n  .pa-game__food-11 {\n    position: absolute;\n    top: 66vh;\n    left: 34vh; }\n  .pa-game__food-11-overlay {\n      position: absolute;\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s;\n      top: 66vh;\n      left: 34vh;\n      opacity: 0.5; }\n  .pa-game__food-11-clickable {\n      height: 24vh;\n      width: 24vh;\n      z-index: 999;\n      position: absolute;\n      top: 71vh;\n      left: 40vh;\n      transform: rotate(45deg);\n      cursor: pointer; }\n  .pa-game__food-12 {\n    position: absolute;\n    top: 66vh;\n    left: 102vh; }\n  .pa-game__food-12-overlay {\n      position: absolute;\n      top: 66vh;\n      left: 102vh;\n      opacity: 0.5;\n      -webkit-animation-duration: 0.2s;\n              animation-duration: 0.2s; }\n  .pa-game__food-12-clickable {\n      height: 24vh;\n      width: 24vh;\n      position: absolute;\n      transform: rotate(45deg);\n      z-index: 999;\n      top: 71vh;\n      left: 110vh;\n      cursor: pointer; }\n  .pa-game__timer {\n    color: #45275A;\n    font-weight: 800; }\n  @media (min-width: 320px) {\n      .pa-game__timer {\n        font-size: 64px; } }\n  @media (min-width: 640px) {\n      .pa-game__timer {\n        font-size: 72px; } }\n  @media (min-width: 992px) {\n      .pa-game__timer {\n        font-size: 84px; } }\n  @media (min-width: 1200px) {\n      .pa-game__timer {\n        font-size: 100px; } }\n  @media (min-width: 1600px) {\n      .pa-game__timer {\n        font-size: 140px; } }\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvbWFpbi9nYW1lL0Q6XFxQcm9qZWN0IEZpbGVzXFxwZWRpYXN1cmUtYXJnaW5pbmUvc3JjXFxhcHBcXG1haW5cXGdhbWVcXGdhbWUuY29tcG9uZW50LnNjc3MiLCJzcmMvYXBwL21haW4vZ2FtZS9EOlxcUHJvamVjdCBGaWxlc1xccGVkaWFzdXJlLWFyZ2luaW5lL3NyY1xcYXNzZXRzXFxzY3NzXFx0aGVtZS1jb25maWcuc2NzcyIsInNyYy9hcHAvbWFpbi9nYW1lL0Q6XFxQcm9qZWN0IEZpbGVzXFxwZWRpYXN1cmUtYXJnaW5pbmUvc3JjXFxhc3NldHNcXHNjc3NcXG1peGluc1xcbWl4aW5zLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBR0E7RUFDQyxpQkFBaUI7RUFDakIsV0FBVztFQUNYLCtCQUFnRDtFQUNoRCxzQkFBc0I7RUFDdEIsMkJBQTJCO0VBQzNCLGFBQWE7RUFDYixtQkFBbUI7RUFDbkIsdUJBQXVCO0VBQ3ZCLHFCQUFxQixFQUFBO0VBRXJCO0lBQ0MsYUFBYTtJQUNiLHNCQUFzQjtJQUN0QixtQkFBbUI7SUFDbkIsdUJBQXVCLEVBQUE7RUFHeEI7SUFDQyxjQ25CZTtJRG9CZixtQkFBbUIsRUFBQTtFRUNuQjtNRkhEO1FBS0UsZUFBZSxFQUFBLEVBa0JoQjtFRWRBO01GVEQ7UUFTRSxlQUFlLEVBQUEsRUFjaEI7RUVGQTtNRnJCRDtRQWFFLGVBQWUsRUFBQSxFQVVoQjtFRVJBO01GZkQ7UUFpQkUsZUFBZSxFQUFBLEVBTWhCO0VFSUE7TUYzQkQ7UUFxQkUsZUFBZSxFQUFBLEVBRWhCO0VBRUQ7SUFDQyxZQUFZO0lBQ1osV0FBVyxFQUFBO0VBR1o7SUFDQywyQkFBbUI7SUFBbkIsd0JBQW1CO0lBQW5CLG1CQUFtQjtJQUNuQiwwQkFBa0I7SUFBbEIsdUJBQWtCO0lBQWxCLGtCQUFrQjtJQUNsQixrQkFBa0I7SUFDbEIsYUFBYTtJQUNiLHVCQUF1QjtJQUV2QixRQUFRO0lBQ1IsTUFBTSxFQUFBO0VBUk47TUFXQyxZQUFZLEVBQUE7RUFYYjtNQWVDLHNCQUFzQjtNQUN0QixjQzlEWTtNRCtEWixpQkFBaUI7TUFDakIsa0JBQWtCO01BQ2xCLFlBQVk7TUFDWixXQUFXO01BQ1gsYUFBYTtNQUNiLHVCQUF1QjtNQUN2QixnQkFBZ0IsRUFBQTtFRWxEakI7UUYyQkE7VUEwQkUsZUFBZTtVQUNmLGdCQUFnQixFQUFBLEVBc0JqQjtFRXRFRDtRRnFCQTtVQStCRSxlQUFlO1VBQ2YsZ0JBQWdCLEVBQUEsRUFpQmpCO0VFMUREO1FGU0E7VUFvQ0UsZUFBZTtVQUNmLGdCQUFnQixFQUFBLEVBWWpCO0VFaEVEO1FGZUE7VUF5Q0UsZUFBZTtVQUNmLGdCQUFnQixFQUFBLEVBT2pCO0VFcEREO1FGR0E7VUE4Q0UsZ0JBQWdCO1VBQ2hCLGdCQUFnQixFQUFBLEVBRWpCO0VBR0Q7SUFFQyxlQUFlO0lBQ2YsWUFBWTtJQUNaLGtCQUFrQjtJQUNsQix1QkFBdUIsRUFBQTtFQVF6QjtJQUNDLGtCQUFrQjtJQUNsQixTQUFTO0lBQ1QsVUFBVSxFQUFBO0VBRVY7TUFDQyxrQkFBa0I7TUFDbEIsU0FBUztNQUNULFVBQVU7TUFDVixZQUFZLEVBQUE7RUFPYjtNQUNDLFlBQVk7TUFDWixXQUFXO01BQ1gsd0JBQXdCO01BQ3hCLGtCQUFrQjtNQUNsQixTQUFTO01BQ1QsVUFBVTtNQUNWLFlBQVk7TUFDWixlQUFlLEVBQUE7RUFJakI7SUFDQyw2QkFBcUI7WUFBckIscUJBQXFCO0lBQ3JCLGtCQUFrQjtJQUNsQixTQUFTO0lBQ1QsVUFBVSxFQUFBO0VBRVY7TUFDQyxrQkFBa0I7TUFDbEIsZ0NBQXdCO2NBQXhCLHdCQUF3QjtNQUV4QixTQUFTO01BQ1QsVUFBVTtNQUNWLFlBQVksRUFBQTtFQU9iO01BQ0MsWUFBWTtNQUNaLFdBQVc7TUFDWCxrQkFBa0I7TUFDbEIsU0FBUztNQUNULFVBQVU7TUFDVix3QkFBd0I7TUFDeEIsWUFBWTtNQUVaLGVBQWUsRUFBQTtFQUlqQjtJQUNDLDhCQUFzQjtZQUF0QixzQkFBc0I7SUFDdEIsa0JBQWtCO0lBQ2xCLFNBQVM7SUFDVCxPQUFPLEVBQUE7RUFFUDtNQUNDLGtCQUFrQjtNQUNsQixnQ0FBd0I7Y0FBeEIsd0JBQXdCO01BRXhCLFNBQVM7TUFDVCxPQUFPO01BQ1AsWUFBWSxFQUFBO0VBT2I7TUFDQyxZQUFZO01BQ1osV0FBVztNQUNYLGtCQUFrQjtNQUNsQixTQUFTO01BQ1Qsd0JBQXdCO01BQ3hCLFlBQVk7TUFFWixTQUFTO01BQ1QsZUFBZSxFQUFBO0VBSWpCO0lBQ0MsNkJBQXFCO1lBQXJCLHFCQUFxQjtJQUNyQixrQkFBa0I7SUFDbEIsU0FBUztJQUNULFVBQVUsRUFBQTtFQUVWO01BQ0Msa0JBQWtCO01BQ2xCLGdDQUF3QjtjQUF4Qix3QkFBd0I7TUFFeEIsU0FBUztNQUNULFVBQVU7TUFDVixZQUFZLEVBQUE7RUFPYjtNQUNDLFlBQVk7TUFDWixXQUFXO01BQ1gsa0JBQWtCO01BQ2xCLFNBQVM7TUFDVCxVQUFVO01BQ1Ysd0JBQXdCO01BQ3hCLFlBQVk7TUFFWixlQUFlLEVBQUE7RUFJakI7SUFDQyw4QkFBc0I7WUFBdEIsc0JBQXNCO0lBQ3RCLGtCQUFrQjtJQUNsQixTQUFTO0lBQ1QsVUFBVSxFQUFBO0VBRVY7TUFDQyxrQkFBa0I7TUFDbEIsZ0NBQXdCO2NBQXhCLHdCQUF3QjtNQUV4QixTQUFTO01BQ1QsVUFBVTtNQUNWLFlBQVksRUFBQTtFQU9iO01BQ0MsWUFBWTtNQUNaLFdBQVc7TUFDWCxrQkFBa0I7TUFDbEIsU0FBUztNQUNULFVBQVU7TUFDVix3QkFBd0I7TUFDeEIsWUFBWTtNQUVaLGVBQWUsRUFBQTtFQUlqQjtJQUNDLGtCQUFrQjtJQUNsQixTQUFTO0lBQ1QsV0FBVyxFQUFBO0VBRVg7TUFDQyxnQ0FBd0I7Y0FBeEIsd0JBQXdCO01BRXhCLGtCQUFrQjtNQUNsQixTQUFTO01BQ1QsV0FBVztNQUNYLFlBQVksRUFBQTtFQU9iO01BQ0MsWUFBWTtNQUNaLFdBQVc7TUFDWCxrQkFBa0I7TUFDbEIsU0FBUztNQUNULHdCQUF3QjtNQUN4QixZQUFZO01BRVosV0FBVztNQUNYLGVBQWUsRUFBQTtFQUlqQjtJQUNDLDZCQUFxQjtZQUFyQixxQkFBcUI7SUFDckIsa0JBQWtCO0lBQ2xCLFNBQVM7SUFDVCxVQUFVLEVBQUE7RUFFVjtNQUNDLGtCQUFrQjtNQUNsQixnQ0FBd0I7Y0FBeEIsd0JBQXdCO01BRXhCLFNBQVM7TUFDVCxVQUFVO01BQ1YsWUFBWSxFQUFBO0VBT2I7TUFDQyxZQUFZO01BQ1osV0FBVztNQUNYLGtCQUFrQjtNQUNsQixTQUFTO01BQ1QsWUFBWTtNQUNaLFVBQVU7TUFDVixlQUFlO01BQ2Ysd0JBQXdCLEVBQUE7RUFHMUI7SUFDQyw4QkFBc0I7WUFBdEIsc0JBQXNCO0lBQ3RCLGtCQUFrQjtJQUNsQixTQUFTO0lBQ1QsVUFBVSxFQUFBO0VBRVY7TUFDQyxrQkFBa0I7TUFDbEIsZ0NBQXdCO2NBQXhCLHdCQUF3QjtNQUV4QixTQUFTO01BQ1QsVUFBVTtNQUNWLFlBQVksRUFBQTtFQU1iO01BQ0MsWUFBWTtNQUNaLFdBQVc7TUFDWCxrQkFBa0I7TUFDbEIsd0JBQXdCO01BQ3hCLFlBQVk7TUFDWixTQUFTO01BQ1QsVUFBVTtNQUNWLGVBQWUsRUFBQTtFQUdqQjtJQUNDLDZCQUFxQjtZQUFyQixxQkFBcUI7SUFDckIsa0JBQWtCO0lBQ2xCLFNBQVM7SUFDVCxVQUFVLEVBQUE7RUFFVjtNQUNDLGtCQUFrQjtNQUNsQixnQ0FBd0I7Y0FBeEIsd0JBQXdCO01BRXhCLFNBQVM7TUFDVCxVQUFVO01BQ1YsWUFBWSxFQUFBO0VBT2I7TUFDQyxZQUFZO01BQ1osV0FBVztNQUNYLGtCQUFrQjtNQUNsQix3QkFBd0I7TUFDeEIsWUFBWTtNQUVaLFNBQVM7TUFDVCxVQUFVO01BQ1YsZUFBZSxFQUFBO0VBR2pCO0lBQ0MsOEJBQXNCO1lBQXRCLHNCQUFzQjtJQUN0QixrQkFBa0I7SUFDbEIsU0FBUztJQUNULFdBQVcsRUFBQTtFQUVYO01BQ0MsZ0NBQXdCO2NBQXhCLHdCQUF3QjtNQUV4QixrQkFBa0I7TUFDbEIsU0FBUztNQUNULFdBQVc7TUFDWCxZQUFZLEVBQUE7RUFNYjtNQUNDLFlBQVk7TUFDWixXQUFXO01BQ1gsa0JBQWtCO01BQ2xCLFNBQVM7TUFDVCx3QkFBd0I7TUFDeEIsWUFBWTtNQUVaLFdBQVc7TUFDWCxlQUFlLEVBQUE7RUFJakI7SUFDQyxrQkFBa0I7SUFDbEIsU0FBUztJQUNULFVBQVUsRUFBQTtFQUVWO01BQ0Msa0JBQWtCO01BQ2xCLGdDQUF3QjtjQUF4Qix3QkFBd0I7TUFFeEIsU0FBUztNQUNULFVBQVU7TUFDVixZQUFZLEVBQUE7RUFPYjtNQUNDLFlBQVk7TUFDWixXQUFXO01BQ1gsWUFBWTtNQUNaLGtCQUFrQjtNQUNsQixTQUFTO01BQ1QsVUFBVTtNQUNWLHdCQUF3QjtNQUV4QixlQUFlLEVBQUE7RUFHakI7SUFDQyxrQkFBa0I7SUFDbEIsU0FBUztJQUNULFdBQVcsRUFBQTtFQUVYO01BQ0Msa0JBQWtCO01BQ2xCLFNBQVM7TUFDVCxXQUFXO01BQ1gsWUFBWTtNQUNaLGdDQUF3QjtjQUF4Qix3QkFBd0IsRUFBQTtFQU16QjtNQUNDLFlBQVk7TUFDWixXQUFXO01BQ1gsa0JBQWtCO01BQ2xCLHdCQUF3QjtNQUN4QixZQUFZO01BRVosU0FBUztNQUNULFdBQVc7TUFDWCxlQUFlLEVBQUE7RUFJakI7SUFDQyxjQ2plZTtJRGtlZixnQkFBZ0IsRUFBQTtFRTdjaEI7TUYyY0Q7UUFLRSxlQUFlLEVBQUEsRUFrQmhCO0VFNWRBO01GcWNEO1FBU0UsZUFBZSxFQUFBLEVBY2hCO0VFaGRBO01GeWJEO1FBYUUsZUFBZSxFQUFBLEVBVWhCO0VFdGRBO01GK2JEO1FBaUJFLGdCQUFnQixFQUFBLEVBTWpCO0VFMWNBO01GbWJEO1FBcUJFLGdCQUFnQixFQUFBLEVBRWpCIiwiZmlsZSI6InNyYy9hcHAvbWFpbi9nYW1lL2dhbWUuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyJAaW1wb3J0IFwifnNyYy9hc3NldHMvc2Nzcy90aGVtZS1jb25maWdcIjtcclxuQGltcG9ydCBcIn5zcmMvYXNzZXRzL3Njc3MvY29uZmlnXCI7XHJcblxyXG4uI3skc3R5bGUtcHJlZml4fS1nYW1lIHtcclxuXHRtaW4taGVpZ2h0OiAxMDB2aDtcclxuXHR3aWR0aDogMTAwJTtcclxuXHRiYWNrZ3JvdW5kLWltYWdlOiB1cmwofnNyYy9hc3NldHMvaW1hZ2VzL2JnLnBuZyk7XHJcblx0YmFja2dyb3VuZC1zaXplOiBjb3ZlcjtcclxuXHRiYWNrZ3JvdW5kLXBvc2l0aW9uOiBjZW50ZXI7XHJcblx0ZGlzcGxheTogZmxleDtcclxuXHRhbGlnbi1pdGVtczogY2VudGVyO1xyXG5cdGp1c3RpZnktY29udGVudDogY2VudGVyO1xyXG5cdGZvbnQtZmFtaWx5OiAnQWJib3R0JztcclxuXHJcblx0Jl9fdGltZXItY29udGFpbmVyLTIge1xyXG5cdFx0ZGlzcGxheTogZmxleDtcclxuXHRcdGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XHJcblx0XHRhbGlnbi1pdGVtczogY2VudGVyO1xyXG5cdFx0anVzdGlmeS1jb250ZW50OiBjZW50ZXI7XHJcblx0fVxyXG5cclxuXHQmX19hcmUteW91LXJlYWR5IHtcclxuXHRcdGNvbG9yOiAkcHJpbWFyeTtcclxuXHRcdGZvbnQtd2VpZ2h0OiBib2xkZXI7XHJcblxyXG5cdFx0QGluY2x1ZGUgZm9yLXBob25lIHtcclxuXHRcdFx0Zm9udC1zaXplOiAzMnB4O1xyXG5cdFx0fVxyXG5cclxuXHRcdEBpbmNsdWRlIGZvci10YWJsZXQge1xyXG5cdFx0XHRmb250LXNpemU6IDM2cHg7XHJcblx0XHR9XHJcblxyXG5cdFx0QGluY2x1ZGUgZm9yLXNtYWxsLWRlc2t0b3Age1xyXG5cdFx0XHRmb250LXNpemU6IDQycHg7XHJcblx0XHR9XHJcblxyXG5cdFx0QGluY2x1ZGUgZm9yLWRlc2t0b3Age1xyXG5cdFx0XHRmb250LXNpemU6IDQ4cHg7XHJcblx0XHR9XHJcblxyXG5cdFx0QGluY2x1ZGUgZm9yLWJpZy1kZXNrdG9wIHtcclxuXHRcdFx0Zm9udC1zaXplOiA2NHB4O1xyXG5cdFx0fVxyXG5cdH1cclxuXHJcblx0Jl9fY29udGFpbmVyIHtcclxuXHRcdGhlaWdodDogMTAwJTtcclxuXHRcdHdpZHRoOiAxMDAlO1xyXG5cdH1cclxuXHJcblx0Jl9fdGltZXItY29udGFpbmVyIHtcclxuXHRcdGhlaWdodDogZml0LWNvbnRlbnQ7XHJcblx0XHR3aWR0aDogZml0LWNvbnRlbnQ7XHJcblx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHRkaXNwbGF5OiBmbGV4O1xyXG5cdFx0anVzdGlmeS1jb250ZW50OiBjZW50ZXI7XHJcblx0XHQvLyBhbGlnbi1pdGVtczogY2VudGVyO1xyXG5cdFx0cmlnaHQ6IDA7XHJcblx0XHR0b3A6IDA7XHJcblxyXG5cdFx0aW1nIHtcclxuXHRcdFx0aGVpZ2h0OiA0MHZoO1xyXG5cdFx0fVxyXG5cclxuXHRcdGRpdiB7XHJcblx0XHRcdGZvbnQtZmFtaWx5OiBcIkRpZ2l0YWxcIjtcclxuXHRcdFx0Y29sb3I6ICRsaWdodDtcclxuXHRcdFx0Zm9udC13ZWlnaHQ6IGJvbGQ7XHJcblx0XHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdFx0aGVpZ2h0OiAxMDAlO1xyXG5cdFx0XHR3aWR0aDogMTAwJTtcclxuXHRcdFx0ZGlzcGxheTogZmxleDtcclxuXHRcdFx0anVzdGlmeS1jb250ZW50OiBjZW50ZXI7XHJcblx0XHRcdG1hcmdpbi1sZWZ0OiAxMSU7XHJcblxyXG5cdFx0XHRAaW5jbHVkZSBmb3ItcGhvbmUge1xyXG5cdFx0XHRcdGZvbnQtc2l6ZTogNDJweDtcclxuXHRcdFx0XHRtYXJnaW4tdG9wOiAxMHB4O1xyXG5cdFx0XHR9XHJcblxyXG5cdFx0XHRAaW5jbHVkZSBmb3ItdGFibGV0IHtcclxuXHRcdFx0XHRmb250LXNpemU6IDQ4cHg7XHJcblx0XHRcdFx0bWFyZ2luLXRvcDogMTVweDtcclxuXHRcdFx0fVxyXG5cclxuXHRcdFx0QGluY2x1ZGUgZm9yLXNtYWxsLWRlc2t0b3Age1xyXG5cdFx0XHRcdGZvbnQtc2l6ZTogNzJweDtcclxuXHRcdFx0XHRtYXJnaW4tdG9wOiAyMHB4O1xyXG5cdFx0XHR9XHJcblxyXG5cdFx0XHRAaW5jbHVkZSBmb3ItZGVza3RvcCB7XHJcblx0XHRcdFx0Zm9udC1zaXplOiA4NHB4O1xyXG5cdFx0XHRcdG1hcmdpbi10b3A6IDI1cHg7XHJcblx0XHRcdH1cclxuXHJcblx0XHRcdEBpbmNsdWRlIGZvci1iaWctZGVza3RvcCB7XHJcblx0XHRcdFx0Zm9udC1zaXplOiAxMjBweDtcclxuXHRcdFx0XHRtYXJnaW4tdG9wOiAzMHB4O1xyXG5cdFx0XHR9XHJcblx0XHR9XHJcblx0fVxyXG5cclxuXHQmX19mb29kLWNvbnRhaW5lciB7XHJcblx0XHRpbWcge1xyXG5cdFx0XHRjdXJzb3I6IHBvaW50ZXI7XHJcblx0XHRcdGhlaWdodDogMzR2aDtcclxuXHRcdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0XHR0cmFuc2l0aW9uOiAwLjJzIGxpbmVhcjtcclxuXHJcblx0XHRcdC8vICY6aG92ZXIge1xyXG5cdFx0XHQvLyBcdGhlaWdodDogMzV2aDtcclxuXHRcdFx0Ly8gfVxyXG5cdFx0fVxyXG5cdH1cclxuXHJcblx0Jl9fZm9vZC0xIHtcclxuXHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdHRvcDogMTV2aDtcclxuXHRcdGxlZnQ6IDE3dmg7XHJcblxyXG5cdFx0Ji1vdmVybGF5IHtcclxuXHRcdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0XHR0b3A6IDE1dmg7XHJcblx0XHRcdGxlZnQ6IDE3dmg7XHJcblx0XHRcdG9wYWNpdHk6IDAuNTtcclxuXHJcblx0XHRcdC8vICY6aG92ZXIge1xyXG5cdFx0XHQvLyBoZWlnaHQ6IDM0dmg7XHJcblx0XHRcdC8vIH1cclxuXHRcdH1cclxuXHJcblx0XHQmLWNsaWNrYWJsZSB7XHJcblx0XHRcdGhlaWdodDogMjR2aDtcclxuXHRcdFx0d2lkdGg6IDI0dmg7XHJcblx0XHRcdHRyYW5zZm9ybTogcm90YXRlKDQ1ZGVnKTtcclxuXHRcdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0XHR0b3A6IDIwdmg7XHJcblx0XHRcdGxlZnQ6IDIzdmg7XHJcblx0XHRcdHotaW5kZXg6IDk5OTtcclxuXHRcdFx0Y3Vyc29yOiBwb2ludGVyO1xyXG5cdFx0fVxyXG5cdH1cclxuXHJcblx0Jl9fZm9vZC0yIHtcclxuXHRcdGFuaW1hdGlvbi1kZWxheTogMC4xcztcclxuXHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdHRvcDogMTV2aDtcclxuXHRcdGxlZnQ6IDg1dmg7XHJcblxyXG5cdFx0Ji1vdmVybGF5IHtcclxuXHRcdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0XHRhbmltYXRpb24tZHVyYXRpb246IDAuMnM7XHJcblxyXG5cdFx0XHR0b3A6IDE1dmg7XHJcblx0XHRcdGxlZnQ6IDg1dmg7XHJcblx0XHRcdG9wYWNpdHk6IDAuNTtcclxuXHJcblx0XHRcdC8vICY6aG92ZXIge1xyXG5cdFx0XHQvLyAgIGhlaWdodDogMzR2aDtcclxuXHRcdFx0Ly8gICB9XHJcblx0XHR9XHJcblxyXG5cdFx0Ji1jbGlja2FibGUge1xyXG5cdFx0XHRoZWlnaHQ6IDI0dmg7XHJcblx0XHRcdHdpZHRoOiAyNHZoO1xyXG5cdFx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHRcdHRvcDogMjB2aDtcclxuXHRcdFx0bGVmdDogOTF2aDtcclxuXHRcdFx0dHJhbnNmb3JtOiByb3RhdGUoNDVkZWcpO1xyXG5cdFx0XHR6LWluZGV4OiA5OTk7XHJcblxyXG5cdFx0XHRjdXJzb3I6IHBvaW50ZXI7XHJcblx0XHR9XHJcblx0fVxyXG5cclxuXHQmX19mb29kLTMge1xyXG5cdFx0YW5pbWF0aW9uLWRlbGF5OiAwLjE1cztcclxuXHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdHRvcDogMzJ2aDtcclxuXHRcdGxlZnQ6IDA7XHJcblxyXG5cdFx0Ji1vdmVybGF5IHtcclxuXHRcdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0XHRhbmltYXRpb24tZHVyYXRpb246IDAuMnM7XHJcblxyXG5cdFx0XHR0b3A6IDMydmg7XHJcblx0XHRcdGxlZnQ6IDA7XHJcblx0XHRcdG9wYWNpdHk6IDAuNTtcclxuXHJcblx0XHRcdC8vICY6aG92ZXIge1xyXG5cdFx0XHQvLyAgIGhlaWdodDogMzR2aDtcclxuXHRcdFx0Ly8gICB9XHJcblx0XHR9XHJcblxyXG5cdFx0Ji1jbGlja2FibGUge1xyXG5cdFx0XHRoZWlnaHQ6IDI0dmg7XHJcblx0XHRcdHdpZHRoOiAyNHZoO1xyXG5cdFx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHRcdHRvcDogMzd2aDtcclxuXHRcdFx0dHJhbnNmb3JtOiByb3RhdGUoNDVkZWcpO1xyXG5cdFx0XHR6LWluZGV4OiA5OTk7XHJcblxyXG5cdFx0XHRsZWZ0OiA2dmg7XHJcblx0XHRcdGN1cnNvcjogcG9pbnRlcjtcclxuXHRcdH1cclxuXHR9XHJcblxyXG5cdCZfX2Zvb2QtNCB7XHJcblx0XHRhbmltYXRpb24tZGVsYXk6IDAuMnM7XHJcblx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHR0b3A6IDMydmg7XHJcblx0XHRsZWZ0OiAzNHZoO1xyXG5cclxuXHRcdCYtb3ZlcmxheSB7XHJcblx0XHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdFx0YW5pbWF0aW9uLWR1cmF0aW9uOiAwLjJzO1xyXG5cclxuXHRcdFx0dG9wOiAzMnZoO1xyXG5cdFx0XHRsZWZ0OiAzNHZoO1xyXG5cdFx0XHRvcGFjaXR5OiAwLjU7XHJcblxyXG5cdFx0XHQvLyAmOmhvdmVyIHtcclxuXHRcdFx0Ly8gICBoZWlnaHQ6IDM0dmg7XHJcblx0XHRcdC8vICAgfVxyXG5cdFx0fVxyXG5cclxuXHRcdCYtY2xpY2thYmxlIHtcclxuXHRcdFx0aGVpZ2h0OiAyNHZoO1xyXG5cdFx0XHR3aWR0aDogMjR2aDtcclxuXHRcdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0XHR0b3A6IDM3dmg7XHJcblx0XHRcdGxlZnQ6IDQwdmg7XHJcblx0XHRcdHRyYW5zZm9ybTogcm90YXRlKDQ1ZGVnKTtcclxuXHRcdFx0ei1pbmRleDogOTk5O1xyXG5cclxuXHRcdFx0Y3Vyc29yOiBwb2ludGVyO1xyXG5cdFx0fVxyXG5cdH1cclxuXHJcblx0Jl9fZm9vZC01IHtcclxuXHRcdGFuaW1hdGlvbi1kZWxheTogMC4yNXM7XHJcblx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHR0b3A6IDMydmg7XHJcblx0XHRsZWZ0OiA2OHZoO1xyXG5cclxuXHRcdCYtb3ZlcmxheSB7XHJcblx0XHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdFx0YW5pbWF0aW9uLWR1cmF0aW9uOiAwLjJzO1xyXG5cclxuXHRcdFx0dG9wOiAzMnZoO1xyXG5cdFx0XHRsZWZ0OiA2OHZoO1xyXG5cdFx0XHRvcGFjaXR5OiAwLjU7XHJcblxyXG5cdFx0XHQvLyAmOmhvdmVyIHtcclxuXHRcdFx0Ly8gICBoZWlnaHQ6IDM0dmg7XHJcblx0XHRcdC8vICAgfVxyXG5cdFx0fVxyXG5cclxuXHRcdCYtY2xpY2thYmxlIHtcclxuXHRcdFx0aGVpZ2h0OiAyNHZoO1xyXG5cdFx0XHR3aWR0aDogMjR2aDtcclxuXHRcdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0XHR0b3A6IDM3dmg7XHJcblx0XHRcdGxlZnQ6IDc0dmg7XHJcblx0XHRcdHRyYW5zZm9ybTogcm90YXRlKDQ1ZGVnKTtcclxuXHRcdFx0ei1pbmRleDogOTk5O1xyXG5cclxuXHRcdFx0Y3Vyc29yOiBwb2ludGVyO1xyXG5cdFx0fVxyXG5cdH1cclxuXHJcblx0Jl9fZm9vZC02IHtcclxuXHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdHRvcDogMzJ2aDtcclxuXHRcdGxlZnQ6IDEwMnZoO1xyXG5cclxuXHRcdCYtb3ZlcmxheSB7XHJcblx0XHRcdGFuaW1hdGlvbi1kdXJhdGlvbjogMC4ycztcclxuXHJcblx0XHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdFx0dG9wOiAzMnZoO1xyXG5cdFx0XHRsZWZ0OiAxMDJ2aDtcclxuXHRcdFx0b3BhY2l0eTogMC41O1xyXG5cclxuXHRcdFx0Ly8gJjpob3ZlciB7XHJcblx0XHRcdC8vICAgaGVpZ2h0OiAzNHZoO1xyXG5cdFx0XHQvLyAgIH1cclxuXHRcdH1cclxuXHJcblx0XHQmLWNsaWNrYWJsZSB7XHJcblx0XHRcdGhlaWdodDogMjR2aDtcclxuXHRcdFx0d2lkdGg6IDI0dmg7XHJcblx0XHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdFx0dG9wOiAzN3ZoO1xyXG5cdFx0XHR0cmFuc2Zvcm06IHJvdGF0ZSg0NWRlZyk7XHJcblx0XHRcdHotaW5kZXg6IDk5OTtcclxuXHJcblx0XHRcdGxlZnQ6IDEwOHZoO1xyXG5cdFx0XHRjdXJzb3I6IHBvaW50ZXI7XHJcblx0XHR9XHJcblx0fVxyXG5cclxuXHQmX19mb29kLTcge1xyXG5cdFx0YW5pbWF0aW9uLWRlbGF5OiAwLjFzO1xyXG5cdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0dG9wOiA0OXZoO1xyXG5cdFx0bGVmdDogMTd2aDtcclxuXHJcblx0XHQmLW92ZXJsYXkge1xyXG5cdFx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHRcdGFuaW1hdGlvbi1kdXJhdGlvbjogMC4ycztcclxuXHJcblx0XHRcdHRvcDogNDl2aDtcclxuXHRcdFx0bGVmdDogMTd2aDtcclxuXHRcdFx0b3BhY2l0eTogMC41O1xyXG5cclxuXHRcdFx0Ly8gJjpob3ZlciB7XHJcblx0XHRcdC8vICAgaGVpZ2h0OiAzNHZoO1xyXG5cdFx0XHQvLyAgIH1cclxuXHRcdH1cclxuXHJcblx0XHQmLWNsaWNrYWJsZSB7XHJcblx0XHRcdGhlaWdodDogMjR2aDtcclxuXHRcdFx0d2lkdGg6IDI0dmg7XHJcblx0XHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdFx0dG9wOiA1NHZoO1xyXG5cdFx0XHR6LWluZGV4OiA5OTk7XHJcblx0XHRcdGxlZnQ6IDIzdmg7XHJcblx0XHRcdGN1cnNvcjogcG9pbnRlcjtcclxuXHRcdFx0dHJhbnNmb3JtOiByb3RhdGUoNDVkZWcpO1xyXG5cdFx0fVxyXG5cdH1cclxuXHQmX19mb29kLTgge1xyXG5cdFx0YW5pbWF0aW9uLWRlbGF5OiAwLjE1cztcclxuXHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdHRvcDogNDl2aDtcclxuXHRcdGxlZnQ6IDUxdmg7XHJcblxyXG5cdFx0Ji1vdmVybGF5IHtcclxuXHRcdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0XHRhbmltYXRpb24tZHVyYXRpb246IDAuMnM7XHJcblxyXG5cdFx0XHR0b3A6IDQ5dmg7XHJcblx0XHRcdGxlZnQ6IDUxdmg7XHJcblx0XHRcdG9wYWNpdHk6IDAuNTtcclxuXHJcblx0XHRcdC8vICY6aG92ZXIge1xyXG5cdFx0XHQvLyAgIGhlaWdodDogMzR2aDtcclxuXHRcdFx0Ly8gICB9XHJcblx0XHR9XHJcblx0XHQmLWNsaWNrYWJsZSB7XHJcblx0XHRcdGhlaWdodDogMjR2aDtcclxuXHRcdFx0d2lkdGg6IDI0dmg7XHJcblx0XHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdFx0dHJhbnNmb3JtOiByb3RhdGUoNDVkZWcpO1xyXG5cdFx0XHR6LWluZGV4OiA5OTk7XHJcblx0XHRcdHRvcDogNTR2aDtcclxuXHRcdFx0bGVmdDogNTZ2aDtcclxuXHRcdFx0Y3Vyc29yOiBwb2ludGVyO1xyXG5cdFx0fVxyXG5cdH1cclxuXHQmX19mb29kLTkge1xyXG5cdFx0YW5pbWF0aW9uLWRlbGF5OiAwLjJzO1xyXG5cdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0dG9wOiA0OXZoO1xyXG5cdFx0bGVmdDogODV2aDtcclxuXHJcblx0XHQmLW92ZXJsYXkge1xyXG5cdFx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHRcdGFuaW1hdGlvbi1kdXJhdGlvbjogMC4ycztcclxuXHJcblx0XHRcdHRvcDogNDl2aDtcclxuXHRcdFx0bGVmdDogODV2aDtcclxuXHRcdFx0b3BhY2l0eTogMC41O1xyXG5cclxuXHRcdFx0Ly8gJjpob3ZlciB7XHJcblx0XHRcdC8vICAgaGVpZ2h0OiAzNHZoO1xyXG5cdFx0XHQvLyAgIH1cclxuXHRcdH1cclxuXHJcblx0XHQmLWNsaWNrYWJsZSB7XHJcblx0XHRcdGhlaWdodDogMjR2aDtcclxuXHRcdFx0d2lkdGg6IDI0dmg7XHJcblx0XHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdFx0dHJhbnNmb3JtOiByb3RhdGUoNDVkZWcpO1xyXG5cdFx0XHR6LWluZGV4OiA5OTk7XHJcblxyXG5cdFx0XHR0b3A6IDU0dmg7XHJcblx0XHRcdGxlZnQ6IDkwdmg7XHJcblx0XHRcdGN1cnNvcjogcG9pbnRlcjtcclxuXHRcdH1cclxuXHR9XHJcblx0Jl9fZm9vZC0xMCB7XHJcblx0XHRhbmltYXRpb24tZGVsYXk6IDAuMjVzO1xyXG5cdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0dG9wOiA0OXZoO1xyXG5cdFx0bGVmdDogMTE5dmg7XHJcblxyXG5cdFx0Ji1vdmVybGF5IHtcclxuXHRcdFx0YW5pbWF0aW9uLWR1cmF0aW9uOiAwLjJzO1xyXG5cclxuXHRcdFx0cG9zaXRpb246IGFic29sdXRlO1xyXG5cdFx0XHR0b3A6IDQ5dmg7XHJcblx0XHRcdGxlZnQ6IDExOXZoO1xyXG5cdFx0XHRvcGFjaXR5OiAwLjU7XHJcblxyXG5cdFx0XHQvLyAmOmhvdmVyIHtcclxuXHRcdFx0Ly8gICBoZWlnaHQ6IDM0dmg7XHJcblx0XHRcdC8vICAgfVxyXG5cdFx0fVxyXG5cdFx0Ji1jbGlja2FibGUge1xyXG5cdFx0XHRoZWlnaHQ6IDI0dmg7XHJcblx0XHRcdHdpZHRoOiAyNHZoO1xyXG5cdFx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHRcdHRvcDogNTR2aDtcclxuXHRcdFx0dHJhbnNmb3JtOiByb3RhdGUoNDVkZWcpO1xyXG5cdFx0XHR6LWluZGV4OiA5OTk7XHJcblxyXG5cdFx0XHRsZWZ0OiAxMjV2aDtcclxuXHRcdFx0Y3Vyc29yOiBwb2ludGVyO1xyXG5cdFx0fVxyXG5cdH1cclxuXHJcblx0Jl9fZm9vZC0xMSB7XHJcblx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHR0b3A6IDY2dmg7XHJcblx0XHRsZWZ0OiAzNHZoO1xyXG5cclxuXHRcdCYtb3ZlcmxheSB7XHJcblx0XHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdFx0YW5pbWF0aW9uLWR1cmF0aW9uOiAwLjJzO1xyXG5cclxuXHRcdFx0dG9wOiA2NnZoO1xyXG5cdFx0XHRsZWZ0OiAzNHZoO1xyXG5cdFx0XHRvcGFjaXR5OiAwLjU7XHJcblxyXG5cdFx0XHQvLyAmOmhvdmVyIHtcclxuXHRcdFx0Ly8gICBoZWlnaHQ6IDM0dmg7XHJcblx0XHRcdC8vICAgfVxyXG5cdFx0fVxyXG5cclxuXHRcdCYtY2xpY2thYmxlIHtcclxuXHRcdFx0aGVpZ2h0OiAyNHZoO1xyXG5cdFx0XHR3aWR0aDogMjR2aDtcclxuXHRcdFx0ei1pbmRleDogOTk5O1xyXG5cdFx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHRcdHRvcDogNzF2aDtcclxuXHRcdFx0bGVmdDogNDB2aDtcclxuXHRcdFx0dHJhbnNmb3JtOiByb3RhdGUoNDVkZWcpO1xyXG5cclxuXHRcdFx0Y3Vyc29yOiBwb2ludGVyO1xyXG5cdFx0fVxyXG5cdH1cclxuXHQmX19mb29kLTEyIHtcclxuXHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdHRvcDogNjZ2aDtcclxuXHRcdGxlZnQ6IDEwMnZoO1xyXG5cclxuXHRcdCYtb3ZlcmxheSB7XHJcblx0XHRcdHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuXHRcdFx0dG9wOiA2NnZoO1xyXG5cdFx0XHRsZWZ0OiAxMDJ2aDtcclxuXHRcdFx0b3BhY2l0eTogMC41O1xyXG5cdFx0XHRhbmltYXRpb24tZHVyYXRpb246IDAuMnM7XHJcblxyXG5cdFx0XHQvLyAmOmhvdmVyIHtcclxuXHRcdFx0Ly8gICBoZWlnaHQ6IDM0dmg7XHJcblx0XHRcdC8vICAgfVxyXG5cdFx0fVxyXG5cdFx0Ji1jbGlja2FibGUge1xyXG5cdFx0XHRoZWlnaHQ6IDI0dmg7XHJcblx0XHRcdHdpZHRoOiAyNHZoO1xyXG5cdFx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XHJcblx0XHRcdHRyYW5zZm9ybTogcm90YXRlKDQ1ZGVnKTtcclxuXHRcdFx0ei1pbmRleDogOTk5O1xyXG5cclxuXHRcdFx0dG9wOiA3MXZoO1xyXG5cdFx0XHRsZWZ0OiAxMTB2aDtcclxuXHRcdFx0Y3Vyc29yOiBwb2ludGVyO1xyXG5cdFx0fVxyXG5cdH1cclxuXHJcblx0Jl9fdGltZXIge1xyXG5cdFx0Y29sb3I6ICRwcmltYXJ5O1xyXG5cdFx0Zm9udC13ZWlnaHQ6IDgwMDtcclxuXHJcblx0XHRAaW5jbHVkZSBmb3ItcGhvbmUge1xyXG5cdFx0XHRmb250LXNpemU6IDY0cHg7XHJcblx0XHR9XHJcblxyXG5cdFx0QGluY2x1ZGUgZm9yLXRhYmxldCB7XHJcblx0XHRcdGZvbnQtc2l6ZTogNzJweDtcclxuXHRcdH1cclxuXHJcblx0XHRAaW5jbHVkZSBmb3Itc21hbGwtZGVza3RvcCB7XHJcblx0XHRcdGZvbnQtc2l6ZTogODRweDtcclxuXHRcdH1cclxuXHJcblx0XHRAaW5jbHVkZSBmb3ItZGVza3RvcCB7XHJcblx0XHRcdGZvbnQtc2l6ZTogMTAwcHg7XHJcblx0XHR9XHJcblxyXG5cdFx0QGluY2x1ZGUgZm9yLWJpZy1kZXNrdG9wIHtcclxuXHRcdFx0Zm9udC1zaXplOiAxNDBweDtcclxuXHRcdH1cclxuXHR9XHJcbn1cclxuIiwiJGRhcms6ICMyNjI3MzM7XHJcbiRkYW5nZXI6ICNjMjY3MWM7XHJcbiR3YXJuaW5nOiAjOTc1ZjA4O1xyXG4kcHJpbWFyeTogIzQ1Mjc1QTtcclxuXHJcbiRsaWdodDogI2ZlZmVmZTtcclxuIiwiQGltcG9ydCAnLi4vZ2xvYmFscy92YXJpYWJsZXMnO1xyXG5cclxuQG1peGluIHNrZXdFbGVtZW50KCRjb2xvcikge1xyXG4gIGNvbnRlbnQ6ICcnO1xyXG4gIGRpc3BsYXk6IGJsb2NrO1xyXG4gIGhlaWdodDogMjAwcHg7XHJcbiAgYmFja2dyb3VuZDogJGNvbG9yO1xyXG59XHJcblxyXG5AbWl4aW4gc2tld0FmdGVyIHtcclxuICB0cmFuc2Zvcm06IHNrZXdZKC01ZGVnKTtcclxuICB0cmFuc2Zvcm0tb3JpZ2luOiBib3R0b20gbGVmdDtcclxufVxyXG5cclxuQG1peGluIHNrZXdCZWZvcmUge1xyXG4gIHRyYW5zZm9ybTogc2tld1koNWRlZyk7XHJcbiAgdHJhbnNmb3JtLW9yaWdpbjogdG9wIGxlZnQ7XHJcbn1cclxuXHJcbkBtaXhpbiByYW5kb20tY29sb3IoKSB7XHJcbiAgY29sb3I6IHJnYihyYW5kb20oMTgwKSwgcmFuZG9tKDE4MCksIHJhbmRvbSgxODApKTtcclxufVxyXG5cclxuQG1peGluIGZvci1waG9uZSB7XHJcbiAgQG1lZGlhIChtaW4td2lkdGg6IG1hcC1nZXQoJGJyZWFrcG9pbnRzLCAncGhvbmUnKSkge1xyXG4gICAgQGNvbnRlbnQ7XHJcbiAgfVxyXG59XHJcblxyXG5AbWl4aW4gZm9yLXRhYmxldCB7XHJcbiAgQG1lZGlhIChtaW4td2lkdGg6IG1hcC1nZXQoJGJyZWFrcG9pbnRzLCAndGFibGV0JykpIHtcclxuICAgIEBjb250ZW50O1xyXG4gIH1cclxufVxyXG5cclxuQG1peGluIGZvci1kZXNrdG9wIHtcclxuICBAbWVkaWEgKG1pbi13aWR0aDogbWFwLWdldCgkYnJlYWtwb2ludHMsICdkZXNrdG9wJykpIHtcclxuICAgIEBjb250ZW50O1xyXG4gIH1cclxufVxyXG5cclxuQG1peGluIGZvci1zbWFsbC1kZXNrdG9wIHtcclxuICBAbWVkaWEgKG1pbi13aWR0aDogbWFwLWdldCgkYnJlYWtwb2ludHMsICdzbWFsbC1kZXNrdG9wJykpIHtcclxuICAgIEBjb250ZW50O1xyXG4gIH1cclxufVxyXG5cclxuQG1peGluIGZvci1iaWctZGVza3RvcCB7XHJcbiAgQG1lZGlhIChtaW4td2lkdGg6IG1hcC1nZXQoJGJyZWFrcG9pbnRzLCAnYmlnLWRlc2t0b3AnKSkge1xyXG4gICAgQGNvbnRlbnQ7XHJcbiAgfVxyXG59XHJcblxyXG5AbWl4aW4gYm94LXNoYWRvdyB7XHJcbiAgYm94LXNoYWRvdzogMCAwIDVweCByZ2JhKDAsIDAsIDAsIDAuMyk7XHJcbn1cclxuIl19 */"

/***/ }),

/***/ "./src/app/main/game/game.component.ts":
/*!*********************************************!*\
  !*** ./src/app/main/game/game.component.ts ***!
  \*********************************************/
/*! exports provided: GameComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GameComponent", function() { return GameComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _core_utils_shuffle_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/utils/shuffle-array */ "./src/app/core/utils/shuffle-array.ts");
/* harmony import */ var _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/services/sound-manager.service */ "./src/app/core/services/sound-manager.service.ts");





var GameComponent = /** @class */ (function () {
    function GameComponent(router, soundManager) {
        this.router = router;
        this.soundManager = soundManager;
        this.startTimer = 3;
        this.gameTimer = 15;
        this.time = '15';
        this.foodPaths = [
            'assets/images/bacon-2.png',
            'assets/images/beef.png',
            'assets/images/bread.png',
            'assets/images/carrots.png',
            'assets/images/chocolates.png',
            'assets/images/nori.png',
            'assets/images/pampkin seed.png',
            'assets/images/peanuts.png',
            'assets/images/potatoes.png',
            'assets/images/soy beans.png',
            'assets/images/turkey.png',
            'assets/images/watermelon.png'
        ];
        this.foodCorrectPaths = [
            'assets/images/nori.png',
            'assets/images/beef.png',
            'assets/images/soy beans.png',
            'assets/images/peanuts.png',
            'assets/images/turkey.png'
        ];
        this.foods = [];
    }
    GameComponent.prototype.ngOnInit = function () {
        if (localStorage.getItem('game')) {
            this.soundManager.playBackgroundMusic();
            this.initGame();
        }
        else {
            this.router.navigate(['']);
        }
    };
    GameComponent.prototype.selectFood = function (food) {
        if (this.foods.filter(function (f) { return f.selected; }).length < 5) {
            if (food.correct && !food.selected) {
                this.soundManager.playSoundByPath('correct');
                food.selected = !food.selected;
            }
            else if (!food.correct) {
                if (!food.selected) {
                    this.soundManager.playSoundByPath('wrong');
                }
                food.selected = !food.selected;
            }
        }
        else if (!food.correct && food.selected) {
            food.selected = !food.selected;
        }
    };
    GameComponent.prototype.initGame = function () {
        var _this = this;
        this.startTimer = 3;
        if (this.startTimerInterval) {
            clearInterval(this.startTimerInterval);
        }
        this.startTimerInterval = setInterval(function () {
            if (_this.startTimer === 0) {
                _this.initFoods();
                setTimeout(function () { return _this.startGame(); }, 500);
                clearInterval(_this.startTimerInterval);
            }
            _this.startTimer--;
        }, 1000);
    };
    GameComponent.prototype.initFoods = function () {
        var _this = this;
        this.foods = this.foodPaths.map(function (food) { return ({
            path: food,
            correct: _this.foodCorrectPaths.includes(food),
            selected: false
        }); });
        this.foods = Object(_core_utils_shuffle_array__WEBPACK_IMPORTED_MODULE_3__["shuffleArray"])(this.foods);
    };
    GameComponent.prototype.startGame = function () {
        var _this = this;
        this.gameTimer = 15;
        if (this.gameTimerInterval) {
            clearInterval(this.gameTimerInterval);
        }
        this.gameTimerInterval = setInterval(function () {
            if (_this.gameTimer === 0) {
                clearInterval(_this.gameTimerInterval);
                var score_1 = _this.foods.filter(function (food) { return food.correct && food.selected; }).length;
                if (score_1 >= 4) {
                    localStorage.setItem('congrats', 'true');
                    localStorage.setItem('score', score_1.toString());
                    _this.router.navigate(['/congrats']);
                }
                else {
                    localStorage.setItem('score', score_1.toString());
                    _this.router.navigate(['/game-over']);
                }
            }
            var score = _this.foods.filter(function (food) { return food.correct && food.selected; }).length;
            if (score === 5) {
                clearInterval(_this.gameTimerInterval);
                localStorage.setItem('congrats', 'true');
                localStorage.setItem('score', score.toString());
                _this.soundManager.stopBackgroundMusic();
                _this.soundManager.playSoundByPath('win');
                _this.router.navigate(['/congrats']);
            }
            _this.gameTimer--;
            _this.time = _this.gameTimer.toString();
            _this.time = _this.time.length < 2 ? '0' + _this.time : _this.time;
        }, 1000);
    };
    GameComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pa-game',
            template: __webpack_require__(/*! ./game.component.html */ "./src/app/main/game/game.component.html"),
            styles: [__webpack_require__(/*! ./game.component.scss */ "./src/app/main/game/game.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"], _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_4__["SoundManagerService"]])
    ], GameComponent);
    return GameComponent;
}());



/***/ }),

/***/ "./src/app/main/gameover/gameover.component.html":
/*!*******************************************************!*\
  !*** ./src/app/main/gameover/gameover.component.html ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pa-gameover\">\r\n\r\n  <span>\r\n    OOOPS! You only got\r\n  </span>\r\n  <p>\r\n    {{ score }}/5\r\n  </p>\r\n  <span>\r\n    YOU CAN TRY AGAIN TO WIN A GIFT!\r\n  </span>\r\n  <div\r\n    (click)=\"tryItAgain()\"\r\n    class=\"pa-gameover__try-it-again animate__bounceInUp animate__animated animate__delay-1s\"\r\n  >\r\n    TRY AGAIN\r\n  </div>\r\n</div>"

/***/ }),

/***/ "./src/app/main/gameover/gameover.component.scss":
/*!*******************************************************!*\
  !*** ./src/app/main/gameover/gameover.component.scss ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pa-gameover {\n  min-height: 100vh;\n  width: 100%;\n  background-image: url('bg.png');\n  background-size: cover;\n  background-position: center;\n  display: flex;\n  align-items: center;\n  flex-direction: column;\n  justify-content: center;\n  font-family: 'Abbott';\n  color: #45275A; }\n  .pa-gameover span {\n    font-weight: bolder; }\n  @media (min-width: 320px) {\n      .pa-gameover span {\n        font-size: 30px; } }\n  @media (min-width: 640px) {\n      .pa-gameover span {\n        font-size: 32px; } }\n  @media (min-width: 992px) {\n      .pa-gameover span {\n        font-size: 48px; } }\n  @media (min-width: 1200px) {\n      .pa-gameover span {\n        font-size: 64px; } }\n  @media (min-width: 1600px) {\n      .pa-gameover span {\n        font-size: 72px; } }\n  .pa-gameover p {\n    font-weight: 800;\n    margin-top: 10px;\n    margin-bottom: 10px;\n    text-align: center; }\n  @media (min-width: 320px) {\n      .pa-gameover p {\n        font-size: 48px; } }\n  @media (min-width: 640px) {\n      .pa-gameover p {\n        font-size: 52px; } }\n  @media (min-width: 992px) {\n      .pa-gameover p {\n        font-size: 84px; } }\n  @media (min-width: 1200px) {\n      .pa-gameover p {\n        font-size: 100px; } }\n  @media (min-width: 1600px) {\n      .pa-gameover p {\n        font-size: 120px; } }\n  .pa-gameover__try-it-again {\n    background-color: #45275A;\n    color: #fefefe;\n    font-weight: bold;\n    padding-top: 10px;\n    padding-left: 18px;\n    padding-right: 18px;\n    padding-bottom: 10px;\n    transition: 0.2s linear;\n    border-radius: 24px;\n    cursor: pointer; }\n  @media (min-width: 320px) {\n      .pa-gameover__try-it-again {\n        font-size: 20px;\n        margin-top: 30px; } }\n  @media (min-width: 640px) {\n      .pa-gameover__try-it-again {\n        font-size: 28px;\n        margin-top: 48px; } }\n  @media (min-width: 992px) {\n      .pa-gameover__try-it-again {\n        font-size: 32px;\n        margin-top: 72px; } }\n  @media (min-width: 1200px) {\n      .pa-gameover__try-it-again {\n        font-size: 36px;\n        margin-top: 84px; } }\n  @media (min-width: 1600px) {\n      .pa-gameover__try-it-again {\n        font-size: 42px;\n        margin-top: 100px; } }\n  .pa-gameover__try-it-again:hover {\n      padding-top: 12px;\n      padding-left: 20px;\n      padding-right: 20px;\n      padding-bottom: 12px; }\n  .pa-gameover__try-it-again:active {\n      padding-top: 8px;\n      padding-left: 16px;\n      padding-right: 16px;\n      padding-bottom: 8px; }\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/main/gameover/gameover.component.ts":
/*!*****************************************************!*\
  !*** ./src/app/main/gameover/gameover.component.ts ***!
  \*****************************************************/
/*! exports provided: GameoverComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GameoverComponent", function() { return GameoverComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/services/sound-manager.service */ "./src/app/core/services/sound-manager.service.ts");




var GameoverComponent = /** @class */ (function () {
    function GameoverComponent(router, soundManagerService) {
        this.router = router;
        this.soundManagerService = soundManagerService;
    }
    GameoverComponent.prototype.ngOnInit = function () {
        if (localStorage.getItem('score')) {
            this.score = localStorage.getItem('score');
            this.soundManagerService.stopBackgroundMusic();
            this.soundManagerService.playSoundByPath('lose');
        }
        else {
            this.router.navigate(['']);
        }
    };
    GameoverComponent.prototype.tryItAgain = function () {
        this.router.navigate(['']);
    };
    GameoverComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pa-gameover',
            template: __webpack_require__(/*! ./gameover.component.html */ "./src/app/main/gameover/gameover.component.html"),
            styles: [__webpack_require__(/*! ./gameover.component.scss */ "./src/app/main/gameover/gameover.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"], _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__["SoundManagerService"]])
    ], GameoverComponent);
    return GameoverComponent;
}());



/***/ }),

/***/ "./src/app/main/instructions/instructions.component.html":
/*!***************************************************************!*\
  !*** ./src/app/main/instructions/instructions.component.html ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pa-instruct\">\r\n  <span class=\"animate__bounceInLeft animate__animated\">\r\n    All you have to do is click on 5 food items that <br />\r\n    you think are rich in Arginine in 15 seconds.\r\n  </span>\r\n  <span class=\"animate__bounceInDown animate__animated\">\r\n    And then we'll show you if you are right!\r\n  </span>\r\n\r\n  <div\r\n    (click)=\"tryItNow()\"\r\n    class=\"pa-instruct__try-it-now animate__bounceInUp animate__animated animate__delay-1s\"\r\n  >\r\n    TRY IT NOW!\r\n  </div>\r\n</div>\r\n"

/***/ }),

/***/ "./src/app/main/instructions/instructions.component.scss":
/*!***************************************************************!*\
  !*** ./src/app/main/instructions/instructions.component.scss ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pa-instruct {\n  min-height: 100vh;\n  width: 100%;\n  background-image: url('bg.png');\n  background-size: cover;\n  background-position: center;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center; }\n  .pa-instruct span {\n    font-family: 'Abbott';\n    color: #45275A;\n    font-weight: bold; }\n  @media (min-width: 320px) {\n      .pa-instruct span:nth-child(2) {\n        margin-top: 28px; } }\n  @media (min-width: 640px) {\n      .pa-instruct span:nth-child(2) {\n        margin-top: 32px; } }\n  @media (min-width: 992px) {\n      .pa-instruct span:nth-child(2) {\n        margin-top: 42px; } }\n  @media (min-width: 1200px) {\n      .pa-instruct span:nth-child(2) {\n        margin-top: 48px; } }\n  @media (min-width: 1600px) {\n      .pa-instruct span:nth-child(2) {\n        margin-top: 64px; } }\n  @media (min-width: 320px) {\n      .pa-instruct span {\n        font-size: 20px; } }\n  @media (min-width: 640px) {\n      .pa-instruct span {\n        font-size: 24px; } }\n  @media (min-width: 992px) {\n      .pa-instruct span {\n        font-size: 36px; } }\n  @media (min-width: 1200px) {\n      .pa-instruct span {\n        font-size: 42px; } }\n  @media (min-width: 1600px) {\n      .pa-instruct span {\n        font-size: 48px; } }\n  .pa-instruct__try-it-now {\n    background-color: #45275A;\n    color: #fefefe;\n    font-family: 'Abbott';\n    font-weight: bold;\n    padding-top: 10px;\n    padding-left: 18px;\n    padding-right: 18px;\n    padding-bottom: 10px;\n    transition: 0.2s linear;\n    border-radius: 24px;\n    cursor: pointer; }\n  @media (min-width: 320px) {\n      .pa-instruct__try-it-now {\n        font-size: 20px;\n        margin-top: 48px; } }\n  @media (min-width: 640px) {\n      .pa-instruct__try-it-now {\n        font-size: 28px;\n        margin-top: 64px; } }\n  @media (min-width: 992px) {\n      .pa-instruct__try-it-now {\n        font-size: 32px;\n        margin-top: 72px; } }\n  @media (min-width: 1200px) {\n      .pa-instruct__try-it-now {\n        font-size: 36px;\n        margin-top: 84px; } }\n  @media (min-width: 1600px) {\n      .pa-instruct__try-it-now {\n        font-size: 42px;\n        margin-top: 100px; } }\n  .pa-instruct__try-it-now:hover {\n      padding-top: 12px;\n      padding-left: 20px;\n      padding-right: 20px;\n      padding-bottom: 12px; }\n  .pa-instruct__try-it-now:active {\n      padding-top: 8px;\n      padding-left: 16px;\n      padding-right: 16px;\n      padding-bottom: 8px; }\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/main/instructions/instructions.component.ts":
/*!*************************************************************!*\
  !*** ./src/app/main/instructions/instructions.component.ts ***!
  \*************************************************************/
/*! exports provided: InstructionsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "InstructionsComponent", function() { return InstructionsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");



var InstructionsComponent = /** @class */ (function () {
    function InstructionsComponent(router) {
        this.router = router;
    }
    InstructionsComponent.prototype.ngOnInit = function () {
        if (!localStorage.getItem('how-to-play')) {
            this.router.navigate(['']);
        }
    };
    InstructionsComponent.prototype.tryItNow = function () {
        localStorage.setItem('game', 'true');
        this.router.navigate(['/game']);
    };
    InstructionsComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pa-instructions',
            template: __webpack_require__(/*! ./instructions.component.html */ "./src/app/main/instructions/instructions.component.html"),
            styles: [__webpack_require__(/*! ./instructions.component.scss */ "./src/app/main/instructions/instructions.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"]])
    ], InstructionsComponent);
    return InstructionsComponent;
}());



/***/ }),

/***/ "./src/app/main/main-routing.animation.ts":
/*!************************************************!*\
  !*** ./src/app/main/main-routing.animation.ts ***!
  \************************************************/
/*! exports provided: mainRoutingAnimation */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mainRoutingAnimation", function() { return mainRoutingAnimation; });
/* harmony import */ var _angular_animations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/animations */ "./node_modules/@angular/animations/fesm5/animations.js");

var mainRoutingAnimation = Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["trigger"])('routeAnimations', [
    Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["transition"])('* <=> *', [
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ position: 'relative' }),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter, :leave', [
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                position: 'relative',
                top: 0,
                left: 0,
                width: '100%',
            }),
        ], { optional: true }),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter', [Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ left: '-100%' })], { optional: true }),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':leave', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animateChild"])(), { optional: true }),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["group"])([
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':leave', [Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animate"])('400ms ease-out', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ left: '100%' }))], {
                optional: true,
            }),
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter', [Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animate"])('400ms ease-out', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ left: '0%' }))], {
                optional: true,
            }),
        ]),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animateChild"])(), { optional: true }),
    ]),
]);


/***/ }),

/***/ "./src/app/main/main-routing.module.ts":
/*!*********************************************!*\
  !*** ./src/app/main/main-routing.module.ts ***!
  \*********************************************/
/*! exports provided: MainRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MainRoutingModule", function() { return MainRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _main_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./main.component */ "./src/app/main/main.component.ts");
/* harmony import */ var _title_title_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./title/title.component */ "./src/app/main/title/title.component.ts");
/* harmony import */ var _instructions_instructions_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./instructions/instructions.component */ "./src/app/main/instructions/instructions.component.ts");
/* harmony import */ var _game_game_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./game/game.component */ "./src/app/main/game/game.component.ts");
/* harmony import */ var _congrats_congrats_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./congrats/congrats.component */ "./src/app/main/congrats/congrats.component.ts");
/* harmony import */ var _gameover_gameover_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./gameover/gameover.component */ "./src/app/main/gameover/gameover.component.ts");









var routes = [
    {
        path: "",
        component: _main_component__WEBPACK_IMPORTED_MODULE_3__["MainComponent"],
        children: [
            {
                path: "",
                component: _title_title_component__WEBPACK_IMPORTED_MODULE_4__["TitleComponent"],
                data: {
                    animation: "Title Page",
                },
            },
            {
                path: "how-to-play",
                component: _instructions_instructions_component__WEBPACK_IMPORTED_MODULE_5__["InstructionsComponent"],
                data: {
                    animation: "Instruction Page",
                },
            },
            {
                path: "game",
                component: _game_game_component__WEBPACK_IMPORTED_MODULE_6__["GameComponent"],
                data: {
                    animation: "Game Page",
                },
            },
            {
                path: "congrats",
                component: _congrats_congrats_component__WEBPACK_IMPORTED_MODULE_7__["CongratsComponent"],
                data: {
                    animation: "Congrats Page",
                },
            },
            {
                path: "game-over",
                component: _gameover_gameover_component__WEBPACK_IMPORTED_MODULE_8__["GameoverComponent"],
                data: {
                    animation: "Gameover Page",
                },
            },
        ],
    },
];
var MainRoutingModule = /** @class */ (function () {
    function MainRoutingModule() {
    }
    MainRoutingModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]],
        })
    ], MainRoutingModule);
    return MainRoutingModule;
}());



/***/ }),

/***/ "./src/app/main/main.component.html":
/*!******************************************!*\
  !*** ./src/app/main/main.component.html ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pa-main\" [@routeAnimations]=\"prepareRoute(outlet)\">\r\n  <router-outlet #outlet=\"outlet\"></router-outlet>\r\n\r\n\r\n  <div *ngIf=\"isPortrait\" class=\"pa-main__use-landscape animate__animated animate__fadeInDown\"\r\n    [ngStyle]=\"{height: height + 'px', width: width + 'px'}\">\r\n    <img class=\"pa-main__logo\" src=\"assets/images/molecule.png\" alt=\"Logo\">\r\n    <div class=\"pa-main__landscape-text\">\r\n      <img src=\"assets/images/phone.png\" alt=\"Phone\">\r\n\r\n      <span>\r\n        This game works best <br>in landscape mode.\r\n      </span>\r\n    </div>\r\n  </div>\r\n\r\n</div>\r\n\r\n\r\n\r\n<div class=\"pa-main__use-landscape\" *ngIf=\"loadedSounds < 5\">\r\n  <img class=\"pa-main__logo\" src=\"assets/images/loader.gif\" alt=\"Loader\">\r\n</div>"

/***/ }),

/***/ "./src/app/main/main.component.scss":
/*!******************************************!*\
  !*** ./src/app/main/main.component.scss ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pa-main {\n  width: 100%;\n  height: 100vh; }\n  .pa-main__use-landscape {\n    background-color: #e3c7ad;\n    position: absolute;\n    top: 0;\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n    width: 100%;\n    height: 100%;\n    z-index: 999999; }\n  .pa-main__logo {\n    height: 18vh; }\n  .pa-main__landscape-text {\n    font-family: 'Abbott';\n    font-weight: 600;\n    letter-spacing: 4px;\n    color: #45275A;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    width: 100%;\n    padding: 30px;\n    text-align: center;\n    width: -webkit-fit-content;\n    width: -moz-fit-content;\n    width: fit-content; }\n  .pa-main__landscape-text img {\n      margin-right: 15px;\n      margin-top: -10px; }\n  @media (min-width: 320px) {\n        .pa-main__landscape-text img {\n          width: 36px; } }\n  @media (min-width: 640px) {\n        .pa-main__landscape-text img {\n          width: 42px; } }\n  @media (min-width: 992px) {\n        .pa-main__landscape-text img {\n          width: 48px; } }\n  @media (min-width: 1200px) {\n        .pa-main__landscape-text img {\n          width: 52px; } }\n  @media (min-width: 1600px) {\n        .pa-main__landscape-text img {\n          width: 60px; } }\n  @media (min-width: 320px) {\n      .pa-main__landscape-text {\n        font-size: 12px; } }\n  @media (min-width: 640px) {\n      .pa-main__landscape-text {\n        font-size: 16px; } }\n  @media (min-width: 992px) {\n      .pa-main__landscape-text {\n        font-size: 24px; } }\n  @media (min-width: 1200px) {\n      .pa-main__landscape-text {\n        font-size: 28px; } }\n  @media (min-width: 1600px) {\n      .pa-main__landscape-text {\n        font-size: 32px; } }\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/main/main.component.ts":
/*!****************************************!*\
  !*** ./src/app/main/main.component.ts ***!
  \****************************************/
/*! exports provided: MainComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MainComponent", function() { return MainComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _main_routing_animation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./main-routing.animation */ "./src/app/main/main-routing.animation.ts");
/* harmony import */ var _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/services/sound-manager.service */ "./src/app/core/services/sound-manager.service.ts");




var MainComponent = /** @class */ (function () {
    function MainComponent(soundManager, changeDetectorRef) {
        this.soundManager = soundManager;
        this.changeDetectorRef = changeDetectorRef;
    }
    MainComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.isPortrait = innerHeight > innerWidth;
        this.height = innerHeight;
        this.width = innerWidth;
        this.soundManager.playBackgroundMusic();
        this.soundManager.loadedSounds.asObservable().subscribe(function (loadedSounds) {
            _this.loadedSounds = loadedSounds;
            _this.changeDetectorRef.detectChanges();
        });
    };
    MainComponent.prototype.onResize = function () {
        this.isPortrait = innerHeight > innerWidth;
        this.height = innerHeight;
        this.width = innerWidth;
    };
    MainComponent.prototype.prepareRoute = function (outlet) {
        return outlet && outlet.activatedRouteData && outlet.activatedRouteData['animation'];
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["HostListener"])('window:resize', ['$event']),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Function),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", []),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:returntype", void 0)
    ], MainComponent.prototype, "onResize", null);
    MainComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pa-main',
            template: __webpack_require__(/*! ./main.component.html */ "./src/app/main/main.component.html"),
            animations: [_main_routing_animation__WEBPACK_IMPORTED_MODULE_2__["mainRoutingAnimation"]],
            styles: [__webpack_require__(/*! ./main.component.scss */ "./src/app/main/main.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__["SoundManagerService"], _angular_core__WEBPACK_IMPORTED_MODULE_1__["ChangeDetectorRef"]])
    ], MainComponent);
    return MainComponent;
}());



/***/ }),

/***/ "./src/app/main/main.module.ts":
/*!*************************************!*\
  !*** ./src/app/main/main.module.ts ***!
  \*************************************/
/*! exports provided: MainModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MainModule", function() { return MainModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _main_routing_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./main-routing.module */ "./src/app/main/main-routing.module.ts");
/* harmony import */ var _main_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./main.component */ "./src/app/main/main.component.ts");
/* harmony import */ var _gameover_gameover_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./gameover/gameover.component */ "./src/app/main/gameover/gameover.component.ts");
/* harmony import */ var _title_title_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./title/title.component */ "./src/app/main/title/title.component.ts");
/* harmony import */ var _instructions_instructions_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./instructions/instructions.component */ "./src/app/main/instructions/instructions.component.ts");
/* harmony import */ var _game_game_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./game/game.component */ "./src/app/main/game/game.component.ts");
/* harmony import */ var _congrats_congrats_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./congrats/congrats.component */ "./src/app/main/congrats/congrats.component.ts");
/* harmony import */ var _angular_flex_layout__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/flex-layout */ "./node_modules/@angular/flex-layout/esm5/flex-layout.es5.js");











var MainModule = /** @class */ (function () {
    function MainModule() {
    }
    MainModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            declarations: [
                _main_component__WEBPACK_IMPORTED_MODULE_4__["MainComponent"],
                _gameover_gameover_component__WEBPACK_IMPORTED_MODULE_5__["GameoverComponent"],
                _title_title_component__WEBPACK_IMPORTED_MODULE_6__["TitleComponent"],
                _instructions_instructions_component__WEBPACK_IMPORTED_MODULE_7__["InstructionsComponent"],
                _game_game_component__WEBPACK_IMPORTED_MODULE_8__["GameComponent"],
                _congrats_congrats_component__WEBPACK_IMPORTED_MODULE_9__["CongratsComponent"],
            ],
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"], _main_routing_module__WEBPACK_IMPORTED_MODULE_3__["MainRoutingModule"], _angular_flex_layout__WEBPACK_IMPORTED_MODULE_10__["FlexLayoutModule"]],
        })
    ], MainModule);
    return MainModule;
}());



/***/ }),

/***/ "./src/app/main/title/title.component.html":
/*!*************************************************!*\
  !*** ./src/app/main/title/title.component.html ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pa-title\" fxLayoutAlign=\"space-between\">\r\n  <div\r\n    fxFlex=\"70\"\r\n    class=\"pa-title__logo\"\r\n    fxLayout=\"column\"\r\n    fxLayoutAlign=\"center center\"\r\n  >\r\n    <img\r\n      class=\"animate__bounceInUp animate__animated\"\r\n      [class.animate__bounceOutUp]=\"animationFoodExited\"\r\n      [class.animate__delay-2s]=\"!animationFoodExited\"\r\n      src=\"assets/images/molecule.png\"\r\n      alt=\"Logo\"\r\n    />\r\n    <p\r\n      class=\"pa-title__title animate__bounceInLeft animate__animated\"\r\n      [class.animate__bounceOutLeft]=\"animationFoodExited\"\r\n      [class.animate__delay-2s]=\"!animationFoodExited\"\r\n    >\r\n      FASTER GROWTH <sup>1</sup> <br />\r\n      GAME\r\n    </p>\r\n\r\n    <div\r\n      class=\"pa-title__start animate__bounceInUp animate__animated\"\r\n      (click)=\"startGame()\"\r\n      [class.animate__bounceOutUp]=\"animationFoodExited\"\r\n      [class.animate__delay-3s]=\"!animationFoodExited\"\r\n    >\r\n      START\r\n    </div>\r\n  </div>\r\n  <div\r\n    *ngIf=\"false\"\r\n    class=\"pa-title__instruction animate__slideInDown animate__animated animate__delay-2s\"\r\n    fxLayoutAlign=\"center\"\r\n  >\r\n    <img src=\"assets/images/emphasis.png\" alt=\"Emphasis\" />\r\n\r\n    <div\r\n      class=\"pa-title__instruction-content\"\r\n      fxLayout=\"column\"\r\n      fxLayoutAlign=\"start center\"\r\n    >\r\n      <span class=\"pa-title__instruction-title\">\r\n        Are you familiar with ARGININE?\r\n      </span>\r\n      <span class=\"pa-title__instruction-sub-title\">\r\n        Let's check!\r\n      </span>\r\n      <div class=\"pa-title__divider\"></div>\r\n      <span class=\"pa-title__instruction-description\">\r\n        All you have to do is click on 5 food items that\r\n      </span>\r\n      <span class=\"pa-title__instruction-description\">\r\n        you think are rich in Arginine in 15 seconds.\r\n      </span>\r\n\r\n      <span class=\"pa-title__instruction-description mt-4\">\r\n        <br />\r\n        And then we'll show you if you are right!\r\n      </span>\r\n      <span\r\n        class=\"pa-title__instruction-try-it animate__headShake animate__animated animate__delay-3s animate__slow\"\r\n      >\r\n        Try it now!\r\n      </span>\r\n    </div>\r\n  </div>\r\n\r\n  <!-- <div class=\"pa-title__food-container\"> -->\r\n  <img\r\n    src=\"assets/images/apple.png\"\r\n    alt=\"Apple\"\r\n    class=\"pa-title__origin-3\"\r\n    [class.pa-title__apple]=\"animationFoodStarted\"\r\n  />\r\n  <img\r\n    src=\"assets/images/bacon.png\"\r\n    alt=\"Bacon\"\r\n    class=\"pa-title__origin-4\"\r\n    [class.pa-title__bacon]=\"animationFoodStarted\"\r\n  />\r\n  <img\r\n    src=\"assets/images/beans.png\"\r\n    alt=\"Beans\"\r\n    class=\"pa-title__origin-1\"\r\n    [class.pa-title__beans]=\"animationFoodStarted\"\r\n  />\r\n  <img\r\n    src=\"assets/images/cheese.png\"\r\n    alt=\"Cheese\"\r\n    class=\"pa-title__origin-5\"\r\n    [class.pa-title__cheese]=\"animationFoodStarted\"\r\n  />\r\n  <img\r\n    src=\"assets/images/chicken.png\"\r\n    alt=\"Chicken\"\r\n    class=\"pa-title__origin-2\"\r\n    [class.pa-title__chicken]=\"animationFoodStarted\"\r\n  />\r\n  <img\r\n    src=\"assets/images/durian.png\"\r\n    alt=\"Durian\"\r\n    class=\"pa-title__origin-3\"\r\n    [class.pa-title__durian]=\"animationFoodStarted\"\r\n  />\r\n  <img\r\n    src=\"assets/images/lettuce.png\"\r\n    alt=\"Lettuce\"\r\n    class=\"pa-title__origin-6\"\r\n    [class.pa-title__lettuce]=\"animationFoodStarted\"\r\n  />\r\n  <img\r\n    src=\"assets/images/milk.png\"\r\n    alt=\"Milk\"\r\n    class=\"pa-title__origin-4\"\r\n    [class.pa-title__milk]=\"animationFoodStarted\"\r\n  />\r\n  <img\r\n    src=\"assets/images/potato.png\"\r\n    alt=\"Potato\"\r\n    class=\"pa-title__origin-5\"\r\n    [class.pa-title__potato]=\"animationFoodStarted\"\r\n  />\r\n  <img\r\n    src=\"assets/images/meat.png\"\r\n    alt=\"Meat\"\r\n    class=\"pa-title__origin-4 pa-title__meat\"\r\n    [class.pa-title__meat]=\"animationFoodStarted\"\r\n  />\r\n\r\n  <img\r\n    src=\"assets/images/nuts.png\"\r\n    alt=\"Nuts\"\r\n    class=\"pa-title__origin-6 pa-title__nuts\"\r\n    [class.pa-title__nuts]=\"animationFoodStarted\"\r\n  />\r\n</div>\r\n"

/***/ }),

/***/ "./src/app/main/title/title.component.scss":
/*!*************************************************!*\
  !*** ./src/app/main/title/title.component.scss ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pa-title {\n  min-height: 100vh;\n  width: 100%;\n  background-image: url('bg.png');\n  background-size: cover;\n  background-position: center; }\n  .pa-title__logo {\n    width: -webkit-fit-content;\n    width: -moz-fit-content;\n    width: fit-content;\n    height: -webkit-fit-content;\n    height: -moz-fit-content;\n    height: fit-content;\n    margin-top: 5vh;\n    margin-left: 8vh; }\n  @media (min-width: 320px) {\n      .pa-title__logo img {\n        height: 80px;\n        margin-left: 3vh; } }\n  @media (min-width: 640px) {\n      .pa-title__logo img {\n        height: 100px;\n        margin-left: 4vh; } }\n  @media (min-width: 992px) {\n      .pa-title__logo img {\n        height: 120px;\n        margin-left: 0vh; } }\n  @media (min-width: 1200px) {\n      .pa-title__logo img {\n        height: 160px;\n        margin-left: 0vh; } }\n  @media (min-width: 1600px) {\n      .pa-title__logo img {\n        height: 200px;\n        margin-left: 0vh; } }\n  .pa-title__instruction {\n    height: -webkit-fit-content;\n    height: -moz-fit-content;\n    height: fit-content;\n    width: -webkit-fit-content;\n    width: -moz-fit-content;\n    width: fit-content; }\n  .pa-title__instruction img {\n      height: 60vh; }\n  .pa-title__start {\n    background-color: #45275A;\n    color: #fefefe;\n    font-family: 'Abbott';\n    font-weight: bold;\n    padding-top: 10px;\n    padding-left: 18px;\n    padding-right: 18px;\n    padding-bottom: 10px;\n    transition: 0.2s linear;\n    border-radius: 24px;\n    cursor: pointer; }\n  @media (min-width: 320px) {\n      .pa-title__start {\n        font-size: 24px;\n        margin-top: 15px; } }\n  @media (min-width: 640px) {\n      .pa-title__start {\n        font-size: 28px;\n        margin-top: 20px; } }\n  @media (min-width: 992px) {\n      .pa-title__start {\n        font-size: 32px;\n        margin-top: 25px; } }\n  @media (min-width: 1200px) {\n      .pa-title__start {\n        font-size: 36px;\n        margin-top: 30px; } }\n  @media (min-width: 1600px) {\n      .pa-title__start {\n        font-size: 42px;\n        margin-top: 35px; } }\n  .pa-title__start:hover {\n      padding-top: 12px;\n      padding-left: 20px;\n      padding-right: 20px;\n      padding-bottom: 12px; }\n  .pa-title__start:active {\n      padding-top: 8px;\n      padding-left: 16px;\n      padding-right: 16px;\n      padding-bottom: 8px; }\n  .pa-title__instruction-content {\n    position: absolute;\n    font-family: 'Abbott';\n    color: #fefefe;\n    margin-top: 30px;\n    text-align: center;\n    padding-left: 9%; }\n  @media (min-width: 320px) {\n      .pa-title__instruction-content {\n        padding-left: 19%;\n        margin-top: 12px; } }\n  @media (min-width: 640px) {\n      .pa-title__instruction-content {\n        padding-left: 19%;\n        margin-top: 16px; } }\n  @media (min-width: 992px) {\n      .pa-title__instruction-content {\n        padding-left: 12%;\n        margin-top: 20px; } }\n  @media (min-width: 1200px) {\n      .pa-title__instruction-content {\n        margin-top: 24px;\n        padding-left: 12%; } }\n  @media (min-width: 1600px) {\n      .pa-title__instruction-content {\n        padding-left: 10%;\n        margin-top: 30px; } }\n  .pa-title__instruction-title, .pa-title__instruction-try-it {\n    font-weight: bold; }\n  @media (min-width: 320px) {\n      .pa-title__instruction-title, .pa-title__instruction-try-it {\n        font-size: 12px; } }\n  @media (min-width: 640px) {\n      .pa-title__instruction-title, .pa-title__instruction-try-it {\n        font-size: 14px; } }\n  @media (min-width: 992px) {\n      .pa-title__instruction-title, .pa-title__instruction-try-it {\n        font-size: 20px; } }\n  @media (min-width: 1200px) {\n      .pa-title__instruction-title, .pa-title__instruction-try-it {\n        font-size: 24px; } }\n  @media (min-width: 1600px) {\n      .pa-title__instruction-title, .pa-title__instruction-try-it {\n        font-size: 42px; } }\n  .pa-title__instruction-try-it {\n    cursor: pointer;\n    margin-top: 20px;\n    transition: 0.3s linear; }\n  .pa-title__instruction-try-it:hover {\n      transform: scale(1.05); }\n  .pa-title__instruction-try-it:active {\n      transform: scale(0.95); }\n  .pa-title__instruction-description {\n    font-weight: bold;\n    margin-top: 6px; }\n  @media (min-width: 320px) {\n      .pa-title__instruction-description {\n        font-size: 10px;\n        font-weight: normal;\n        margin-top: 1px; } }\n  @media (min-width: 640px) {\n      .pa-title__instruction-description {\n        font-size: 11px;\n        font-weight: normal;\n        margin-top: 2px; } }\n  @media (min-width: 992px) {\n      .pa-title__instruction-description {\n        font-size: 13px;\n        font-weight: normal;\n        margin-top: 6px; } }\n  @media (min-width: 1200px) {\n      .pa-title__instruction-description {\n        font-size: 14px;\n        font-weight: bold;\n        margin-top: 6px; } }\n  @media (min-width: 1600px) {\n      .pa-title__instruction-description {\n        font-size: 20px;\n        font-weight: bold;\n        margin-top: 8px; } }\n  .pa-title__instruction-sub-title {\n    font-weight: bolder; }\n  @media (min-width: 320px) {\n      .pa-title__instruction-sub-title {\n        font-size: 16px;\n        margin-top: 5px; } }\n  @media (min-width: 640px) {\n      .pa-title__instruction-sub-title {\n        font-size: 18px;\n        margin-top: 7px; } }\n  @media (min-width: 992px) {\n      .pa-title__instruction-sub-title {\n        font-size: 24px;\n        margin-top: 15px; } }\n  @media (min-width: 1200px) {\n      .pa-title__instruction-sub-title {\n        margin-top: 15px;\n        font-size: 28px; } }\n  @media (min-width: 1600px) {\n      .pa-title__instruction-sub-title {\n        font-size: 42px;\n        margin-top: 15px; } }\n  .pa-title__divider {\n    width: 100%;\n    border-bottom: 1px solid #fefefe;\n    margin-top: 15px;\n    margin-bottom: 15px; }\n  @media (min-width: 320px) {\n      .pa-title__divider {\n        width: 80%;\n        margin-top: 4px;\n        margin-bottom: 4px; } }\n  @media (min-width: 640px) {\n      .pa-title__divider {\n        width: 90%;\n        margin-top: 6px;\n        margin-bottom: 6px; } }\n  @media (min-width: 992px) {\n      .pa-title__divider {\n        width: 100%;\n        margin-top: 15px;\n        margin-bottom: 15px; } }\n  .pa-title__title {\n    font-family: 'Abbott';\n    font-weight: 700;\n    color: #45275A;\n    text-align: center;\n    letter-spacing: 4px;\n    margin: 0; }\n  @media (min-width: 320px) {\n      .pa-title__title {\n        font-size: 28px;\n        letter-spacing: 2px; } }\n  @media (min-width: 640px) {\n      .pa-title__title {\n        font-size: 32px;\n        letter-spacing: 2px; } }\n  @media (min-width: 992px) {\n      .pa-title__title {\n        font-size: 48px;\n        letter-spacing: 4px; } }\n  @media (min-width: 1200px) {\n      .pa-title__title {\n        font-size: 64px;\n        letter-spacing: 4px; } }\n  @media (min-width: 1600px) {\n      .pa-title__title {\n        font-size: 72px;\n        letter-spacing: 4px; } }\n  .pa-title__origin-1 {\n    position: absolute;\n    right: 130%;\n    bottom: 150vh;\n    transition-timing-function: cubic-bezier(0.64, 0.57, 0.67, 1.25);\n    transition-duration: 0.8s; }\n  .pa-title__origin-2 {\n    position: absolute;\n    right: 130%;\n    bottom: 130vh;\n    transition-timing-function: cubic-bezier(0.64, 0.57, 0.67, 1.25);\n    transition-duration: 0.8s; }\n  .pa-title__origin-3 {\n    position: absolute;\n    right: 50%;\n    bottom: 150vh;\n    transition-timing-function: cubic-bezier(0.64, 0.57, 0.67, 1.25);\n    transition-duration: 0.8s; }\n  .pa-title__origin-4 {\n    position: absolute;\n    right: 25%;\n    bottom: 150vh;\n    transition-timing-function: cubic-bezier(0.64, 0.57, 0.67, 1.25);\n    transition-duration: 0.8s; }\n  .pa-title__origin-5 {\n    position: absolute;\n    right: 130%;\n    bottom: 100vh;\n    transition-timing-function: cubic-bezier(0.64, 0.57, 0.67, 1.25);\n    transition-duration: 0.8s; }\n  .pa-title__origin-6 {\n    position: absolute;\n    right: 130%;\n    bottom: 25vh;\n    transition-timing-function: cubic-bezier(0.64, 0.57, 0.67, 1.3);\n    transition-duration: 0.8s; }\n  .pa-title__bacon {\n    z-index: 1;\n    position: absolute;\n    right: 5%;\n    bottom: 3vh;\n    height: 48vh; }\n  .pa-title__lettuce {\n    z-index: 4;\n    position: absolute;\n    right: 20%;\n    bottom: 3vh;\n    height: 42vh; }\n  .pa-title__potato {\n    z-index: 3;\n    position: absolute;\n    right: 32%;\n    bottom: 3vh;\n    height: 30vh; }\n  .pa-title__cheese {\n    z-index: 8;\n    position: absolute;\n    right: 37%;\n    bottom: 0;\n    height: 16vh; }\n  .pa-title__beans {\n    z-index: 9;\n    position: absolute;\n    right: 28%;\n    bottom: 0;\n    height: 20vh; }\n  .pa-title__durian {\n    z-index: 5;\n    position: absolute;\n    right: 7%;\n    bottom: 2.5vh;\n    height: 34vh; }\n  .pa-title__nuts {\n    z-index: 10;\n    position: absolute;\n    right: 2%;\n    bottom: 0;\n    height: 18vh; }\n  .pa-title__milk {\n    z-index: 2;\n    position: absolute;\n    right: 13%;\n    bottom: 4.5vh;\n    height: 48vh; }\n  .pa-title__chicken {\n    z-index: 6;\n    position: absolute;\n    right: 13%;\n    bottom: 0;\n    height: 30vh; }\n  .pa-title__apple {\n    z-index: 11;\n    position: absolute;\n    right: 13%;\n    bottom: 0;\n    height: 30vh; }\n  .pa-title__meat {\n    z-index: 7;\n    position: absolute;\n    right: 0;\n    bottom: 0;\n    height: 30vh; }\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/main/title/title.component.ts":
/*!***********************************************!*\
  !*** ./src/app/main/title/title.component.ts ***!
  \***********************************************/
/*! exports provided: TitleComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TitleComponent", function() { return TitleComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/services/sound-manager.service */ "./src/app/core/services/sound-manager.service.ts");




var TitleComponent = /** @class */ (function () {
    function TitleComponent(router, soundManager) {
        this.router = router;
        this.soundManager = soundManager;
    }
    TitleComponent.prototype.ngOnInit = function () {
        localStorage.clear();
        this.soundManager.playBackgroundMusic();
    };
    TitleComponent.prototype.ngAfterViewInit = function () {
        var _this = this;
        setTimeout(function () { return (_this.animationFoodStarted = true); }, 1000);
    };
    TitleComponent.prototype.startGame = function () {
        var _this = this;
        this.animationFoodStarted = false;
        this.animationFoodExited = true;
        setTimeout(function () {
            localStorage.setItem('how-to-play', 'true');
            _this.router.navigate(['/how-to-play']);
        }, 1000);
    };
    TitleComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pa-title',
            template: __webpack_require__(/*! ./title.component.html */ "./src/app/main/title/title.component.html"),
            styles: [__webpack_require__(/*! ./title.component.scss */ "./src/app/main/title/title.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"], _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__["SoundManagerService"]])
    ], TitleComponent);
    return TitleComponent;
}());



/***/ })

}]);
//# sourceMappingURL=main-main-module.js.map