(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["main-main-module"],{

/***/ "./node_modules/confetti-js/dist/index.es.js":
/*!***************************************************!*\
  !*** ./node_modules/confetti-js/dist/index.es.js ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function ConfettiGenerator(params) {
  //////////////
  // Defaults
  var appstate = {
    target: 'confetti-holder', // Id of the canvas
    max: 80, // Max itens to render
    size: 1, // prop size
    animate: true, // Should animate?
    respawn: true, // Should confettis be respawned when getting out of screen?
    props: ['circle', 'square', 'triangle', 'line'], // Types of confetti
    colors: [[165,104,246],[230,61,135],[0,199,228],[253,214,126]], // Colors to render confetti
    clock: 25, // Speed of confetti fall
    interval: null, // Draw interval holder
    rotate: false, // Whenever to rotate a prop
    start_from_edge: false, // Should confettis spawn at the top/bottom of the screen?
    width: window.innerWidth, // canvas width (as int, in px)
    height: window.innerHeight // canvas height (as int, in px)
  };

  //////////////
  // Setting parameters if received
  if(params) {
    if(params.target)
      appstate.target = params.target;
    if(params.max)
      appstate.max = params.max;
    if(params.size)
      appstate.size = params.size;
    if(params.animate !== undefined && params.animate !== null)
      appstate.animate = params.animate;
    if(params.respawn !== undefined && params.respawn !== null)
      appstate.respawn = params.respawn;
    if(params.props)
      appstate.props = params.props;
    if(params.colors)
      appstate.colors = params.colors;
    if(params.clock)
      appstate.clock = params.clock;
    if(params.start_from_edge !== undefined && params.start_from_edge !== null)
      appstate.start_from_edge = params.start_from_edge;
    if(params.width)
      appstate.width = params.width;
    if(params.height)
      appstate.height = params.height;
    if(params.rotate !== undefined && params.rotate !== null)
      appstate.rotate = params.rotate;
  }

  //////////////
  // Early exit if the target is not the correct type, or is null
  if(
    typeof appstate.target != 'object' &&
    typeof appstate.target != 'string'
  ) {
    throw new TypeError('The target parameter should be a node or string');
  }

  if(
    (typeof appstate.target == 'object' && (appstate.target === null || !appstate.target instanceof HTMLCanvasElement)) ||
    (typeof appstate.target == 'string' && (document.getElementById(appstate.target) === null || !document.getElementById(appstate.target) instanceof HTMLCanvasElement))
  ) {
    throw new ReferenceError('The target element does not exist or is not a canvas element');
  }

  //////////////
  // Properties
  var cv = typeof appstate.target == 'object'
    ? appstate.target
    : document.getElementById(appstate.target);
  var ctx = cv.getContext("2d");
  var particles = [];

  //////////////
  // Random helper (to minimize typing)
  function rand(limit, floor) {
    if(!limit) limit = 1;
    var rand = Math.random() * limit;
    return !floor ? rand : Math.floor(rand);
  }

  var totalWeight = appstate.props.reduce(function(weight, prop) {
    return weight + (prop.weight || 1);
  }, 0);
  function selectProp() {
    var rand = Math.random() * totalWeight;
    for (var i = 0; i < appstate.props.length; ++i) {
      var weight = appstate.props[i].weight || 1;
      if (rand < weight) return i;
      rand -= weight;
    }
  }

  //////////////
  // Confetti particle generator
  function particleFactory() {
    var prop = appstate.props[selectProp()];
    var p = {
      prop: prop.type ? prop.type : prop, //prop type
      x: rand(appstate.width), //x-coordinate
      y: appstate.start_from_edge ? (appstate.clock >= 0 ? -10 : parseFloat(appstate.height) + 10) : rand(appstate.height), //y-coordinate
      src: prop.src,
      radius: rand(4) + 1, //radius
      size: prop.size,
      rotate: appstate.rotate,
      line: Math.floor(rand(65) - 30), // line angle
      angles: [rand(10, true) + 2, rand(10, true) + 2, rand(10, true) + 2, rand(10, true) + 2], // triangle drawing angles
      color: appstate.colors[rand(appstate.colors.length, true)], // color
      rotation: rand(360, true) * Math.PI/180,
      speed: rand(appstate.clock / 7) + (appstate.clock / 30)
    };

    return p;
  }

  //////////////
  // Confetti drawing on canvas
  function particleDraw(p) {
    if (!p) {
      return;
    }

    var op = (p.radius <= 3) ? 0.4 : 0.8;

    ctx.fillStyle = ctx.strokeStyle = "rgba(" + p.color + ", "+ op +")";
    ctx.beginPath();

    switch(p.prop) {
      case 'circle':{
        ctx.moveTo(p.x, p.y);
        ctx.arc(p.x, p.y, p.radius * appstate.size, 0, Math.PI * 2, true);
        ctx.fill();
        break;
      }
      case 'triangle': {
        ctx.moveTo(p.x, p.y);
        ctx.lineTo(p.x + (p.angles[0] * appstate.size), p.y + (p.angles[1] * appstate.size));
        ctx.lineTo(p.x + (p.angles[2] * appstate.size), p.y + (p.angles[3] * appstate.size));
        ctx.closePath();
        ctx.fill();
        break;
      }
      case 'line':{
        ctx.moveTo(p.x, p.y);
        ctx.lineTo(p.x + (p.line * appstate.size), p.y + (p.radius * 5));
        ctx.lineWidth = 2 * appstate.size;
        ctx.stroke();
        break;
      }
      case 'square': {
        ctx.save();
        ctx.translate(p.x+15, p.y+5);
        ctx.rotate(p.rotation);
        ctx.fillRect(-15 * appstate.size,-5 * appstate.size,15 * appstate.size,5 * appstate.size);
        ctx.restore();
        break;
      }
      case 'svg': {
        ctx.save();
        var image = new window.Image();
        image.src = p.src;
        var size = p.size || 15;
        ctx.translate(p.x + size / 2, p.y + size / 2);
        if(p.rotate)
          ctx.rotate(p.rotation);
        ctx.drawImage(image, -(size/2) * appstate.size, -(size/2) * appstate.size, size * appstate.size, size * appstate.size);
        ctx.restore();
        break;
      }
    }
  }

  //////////////
  // Public itens
  //////////////

  //////////////
  // Clean actual state
  var _clear = function() {
    appstate.animate = false;
    clearInterval(appstate.interval);

    requestAnimationFrame(function() {
    	ctx.clearRect(0, 0, cv.width, cv.height);
      var w = cv.width;
      cv.width = 1;
      cv.width = w;
    });
  };

  //////////////
  // Render confetti on canvas
  var _render = function() {
      cv.width = appstate.width;
      cv.height = appstate.height;
      particles = [];

      for(var i = 0; i < appstate.max; i ++)
        particles.push(particleFactory());

      function draw(){
        ctx.clearRect(0, 0, appstate.width, appstate.height);

        for(var i in particles)
          particleDraw(particles[i]);

        update();

        if(appstate.animate) requestAnimationFrame(draw);
      }

      function update() {

        for (var i = 0; i < appstate.max; i++) {
          var p = particles[i];

          if (p) {
            if(appstate.animate)
              p.y += p.speed;

            if (p.rotate)
              p.rotation += p.speed / 35;

            if ((p.speed >= 0 && p.y > appstate.height) || (p.speed < 0 && p.y < 0)) {
              if(appstate.respawn) {
                particles[i] = p;
                particles[i].x = rand(appstate.width, true);
                particles[i].y = p.speed >= 0 ? -10 : parseFloat(appstate.height);
              } else {
                particles[i] = undefined;
              }
            }
          }
        }

        if (particles.every(function(p) { return p === undefined; })) {
          _clear();
        }
      }

      return requestAnimationFrame(draw);
  };

  return {
    render: _render,
    clear: _clear
  }
}

/* harmony default export */ __webpack_exports__["default"] = (ConfettiGenerator);


/***/ }),

/***/ "./node_modules/howler/dist/howler.js":
/*!********************************************!*\
  !*** ./node_modules/howler/dist/howler.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 *  howler.js v2.2.0
 *  howlerjs.com
 *
 *  (c) 2013-2020, James Simpson of GoldFire Studios
 *  goldfirestudios.com
 *
 *  MIT License
 */

(function() {

  'use strict';

  /** Global Methods **/
  /***************************************************************************/

  /**
   * Create the global controller. All contained methods and properties apply
   * to all sounds that are currently playing or will be in the future.
   */
  var HowlerGlobal = function() {
    this.init();
  };
  HowlerGlobal.prototype = {
    /**
     * Initialize the global Howler object.
     * @return {Howler}
     */
    init: function() {
      var self = this || Howler;

      // Create a global ID counter.
      self._counter = 1000;

      // Pool of unlocked HTML5 Audio objects.
      self._html5AudioPool = [];
      self.html5PoolSize = 10;

      // Internal properties.
      self._codecs = {};
      self._howls = [];
      self._muted = false;
      self._volume = 1;
      self._canPlayEvent = 'canplaythrough';
      self._navigator = (typeof window !== 'undefined' && window.navigator) ? window.navigator : null;

      // Public properties.
      self.masterGain = null;
      self.noAudio = false;
      self.usingWebAudio = true;
      self.autoSuspend = true;
      self.ctx = null;

      // Set to false to disable the auto audio unlocker.
      self.autoUnlock = true;

      // Setup the various state values for global tracking.
      self._setup();

      return self;
    },

    /**
     * Get/set the global volume for all sounds.
     * @param  {Float} vol Volume from 0.0 to 1.0.
     * @return {Howler/Float}     Returns self or current volume.
     */
    volume: function(vol) {
      var self = this || Howler;
      vol = parseFloat(vol);

      // If we don't have an AudioContext created yet, run the setup.
      if (!self.ctx) {
        setupAudioContext();
      }

      if (typeof vol !== 'undefined' && vol >= 0 && vol <= 1) {
        self._volume = vol;

        // Don't update any of the nodes if we are muted.
        if (self._muted) {
          return self;
        }

        // When using Web Audio, we just need to adjust the master gain.
        if (self.usingWebAudio) {
          self.masterGain.gain.setValueAtTime(vol, Howler.ctx.currentTime);
        }

        // Loop through and change volume for all HTML5 audio nodes.
        for (var i=0; i<self._howls.length; i++) {
          if (!self._howls[i]._webAudio) {
            // Get all of the sounds in this Howl group.
            var ids = self._howls[i]._getSoundIds();

            // Loop through all sounds and change the volumes.
            for (var j=0; j<ids.length; j++) {
              var sound = self._howls[i]._soundById(ids[j]);

              if (sound && sound._node) {
                sound._node.volume = sound._volume * vol;
              }
            }
          }
        }

        return self;
      }

      return self._volume;
    },

    /**
     * Handle muting and unmuting globally.
     * @param  {Boolean} muted Is muted or not.
     */
    mute: function(muted) {
      var self = this || Howler;

      // If we don't have an AudioContext created yet, run the setup.
      if (!self.ctx) {
        setupAudioContext();
      }

      self._muted = muted;

      // With Web Audio, we just need to mute the master gain.
      if (self.usingWebAudio) {
        self.masterGain.gain.setValueAtTime(muted ? 0 : self._volume, Howler.ctx.currentTime);
      }

      // Loop through and mute all HTML5 Audio nodes.
      for (var i=0; i<self._howls.length; i++) {
        if (!self._howls[i]._webAudio) {
          // Get all of the sounds in this Howl group.
          var ids = self._howls[i]._getSoundIds();

          // Loop through all sounds and mark the audio node as muted.
          for (var j=0; j<ids.length; j++) {
            var sound = self._howls[i]._soundById(ids[j]);

            if (sound && sound._node) {
              sound._node.muted = (muted) ? true : sound._muted;
            }
          }
        }
      }

      return self;
    },

    /**
     * Handle stopping all sounds globally.
     */
    stop: function() {
      var self = this || Howler;

      // Loop through all Howls and stop them.
      for (var i=0; i<self._howls.length; i++) {
        self._howls[i].stop();
      }

      return self;
    },

    /**
     * Unload and destroy all currently loaded Howl objects.
     * @return {Howler}
     */
    unload: function() {
      var self = this || Howler;

      for (var i=self._howls.length-1; i>=0; i--) {
        self._howls[i].unload();
      }

      // Create a new AudioContext to make sure it is fully reset.
      if (self.usingWebAudio && self.ctx && typeof self.ctx.close !== 'undefined') {
        self.ctx.close();
        self.ctx = null;
        setupAudioContext();
      }

      return self;
    },

    /**
     * Check for codec support of specific extension.
     * @param  {String} ext Audio file extention.
     * @return {Boolean}
     */
    codecs: function(ext) {
      return (this || Howler)._codecs[ext.replace(/^x-/, '')];
    },

    /**
     * Setup various state values for global tracking.
     * @return {Howler}
     */
    _setup: function() {
      var self = this || Howler;

      // Keeps track of the suspend/resume state of the AudioContext.
      self.state = self.ctx ? self.ctx.state || 'suspended' : 'suspended';

      // Automatically begin the 30-second suspend process
      self._autoSuspend();

      // Check if audio is available.
      if (!self.usingWebAudio) {
        // No audio is available on this system if noAudio is set to true.
        if (typeof Audio !== 'undefined') {
          try {
            var test = new Audio();

            // Check if the canplaythrough event is available.
            if (typeof test.oncanplaythrough === 'undefined') {
              self._canPlayEvent = 'canplay';
            }
          } catch(e) {
            self.noAudio = true;
          }
        } else {
          self.noAudio = true;
        }
      }

      // Test to make sure audio isn't disabled in Internet Explorer.
      try {
        var test = new Audio();
        if (test.muted) {
          self.noAudio = true;
        }
      } catch (e) {}

      // Check for supported codecs.
      if (!self.noAudio) {
        self._setupCodecs();
      }

      return self;
    },

    /**
     * Check for browser support for various codecs and cache the results.
     * @return {Howler}
     */
    _setupCodecs: function() {
      var self = this || Howler;
      var audioTest = null;

      // Must wrap in a try/catch because IE11 in server mode throws an error.
      try {
        audioTest = (typeof Audio !== 'undefined') ? new Audio() : null;
      } catch (err) {
        return self;
      }

      if (!audioTest || typeof audioTest.canPlayType !== 'function') {
        return self;
      }

      var mpegTest = audioTest.canPlayType('audio/mpeg;').replace(/^no$/, '');

      // Opera version <33 has mixed MP3 support, so we need to check for and block it.
      var checkOpera = self._navigator && self._navigator.userAgent.match(/OPR\/([0-6].)/g);
      var isOldOpera = (checkOpera && parseInt(checkOpera[0].split('/')[1], 10) < 33);

      self._codecs = {
        mp3: !!(!isOldOpera && (mpegTest || audioTest.canPlayType('audio/mp3;').replace(/^no$/, ''))),
        mpeg: !!mpegTest,
        opus: !!audioTest.canPlayType('audio/ogg; codecs="opus"').replace(/^no$/, ''),
        ogg: !!audioTest.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/, ''),
        oga: !!audioTest.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/, ''),
        wav: !!audioTest.canPlayType('audio/wav; codecs="1"').replace(/^no$/, ''),
        aac: !!audioTest.canPlayType('audio/aac;').replace(/^no$/, ''),
        caf: !!audioTest.canPlayType('audio/x-caf;').replace(/^no$/, ''),
        m4a: !!(audioTest.canPlayType('audio/x-m4a;') || audioTest.canPlayType('audio/m4a;') || audioTest.canPlayType('audio/aac;')).replace(/^no$/, ''),
        m4b: !!(audioTest.canPlayType('audio/x-m4b;') || audioTest.canPlayType('audio/m4b;') || audioTest.canPlayType('audio/aac;')).replace(/^no$/, ''),
        mp4: !!(audioTest.canPlayType('audio/x-mp4;') || audioTest.canPlayType('audio/mp4;') || audioTest.canPlayType('audio/aac;')).replace(/^no$/, ''),
        weba: !!audioTest.canPlayType('audio/webm; codecs="vorbis"').replace(/^no$/, ''),
        webm: !!audioTest.canPlayType('audio/webm; codecs="vorbis"').replace(/^no$/, ''),
        dolby: !!audioTest.canPlayType('audio/mp4; codecs="ec-3"').replace(/^no$/, ''),
        flac: !!(audioTest.canPlayType('audio/x-flac;') || audioTest.canPlayType('audio/flac;')).replace(/^no$/, '')
      };

      return self;
    },

    /**
     * Some browsers/devices will only allow audio to be played after a user interaction.
     * Attempt to automatically unlock audio on the first user interaction.
     * Concept from: http://paulbakaus.com/tutorials/html5/web-audio-on-ios/
     * @return {Howler}
     */
    _unlockAudio: function() {
      var self = this || Howler;

      // Only run this if Web Audio is supported and it hasn't already been unlocked.
      if (self._audioUnlocked || !self.ctx) {
        return;
      }

      self._audioUnlocked = false;
      self.autoUnlock = false;

      // Some mobile devices/platforms have distortion issues when opening/closing tabs and/or web views.
      // Bugs in the browser (especially Mobile Safari) can cause the sampleRate to change from 44100 to 48000.
      // By calling Howler.unload(), we create a new AudioContext with the correct sampleRate.
      if (!self._mobileUnloaded && self.ctx.sampleRate !== 44100) {
        self._mobileUnloaded = true;
        self.unload();
      }

      // Scratch buffer for enabling iOS to dispose of web audio buffers correctly, as per:
      // http://stackoverflow.com/questions/24119684
      self._scratchBuffer = self.ctx.createBuffer(1, 1, 22050);

      // Call this method on touch start to create and play a buffer,
      // then check if the audio actually played to determine if
      // audio has now been unlocked on iOS, Android, etc.
      var unlock = function(e) {
        // Create a pool of unlocked HTML5 Audio objects that can
        // be used for playing sounds without user interaction. HTML5
        // Audio objects must be individually unlocked, as opposed
        // to the WebAudio API which only needs a single activation.
        // This must occur before WebAudio setup or the source.onended
        // event will not fire.
        while (self._html5AudioPool.length < self.html5PoolSize) {
          try {
            var audioNode = new Audio();

            // Mark this Audio object as unlocked to ensure it can get returned
            // to the unlocked pool when released.
            audioNode._unlocked = true;

            // Add the audio node to the pool.
            self._releaseHtml5Audio(audioNode);
          } catch (e) {
            self.noAudio = true;
            break;
          }
        }

        // Loop through any assigned audio nodes and unlock them.
        for (var i=0; i<self._howls.length; i++) {
          if (!self._howls[i]._webAudio) {
            // Get all of the sounds in this Howl group.
            var ids = self._howls[i]._getSoundIds();

            // Loop through all sounds and unlock the audio nodes.
            for (var j=0; j<ids.length; j++) {
              var sound = self._howls[i]._soundById(ids[j]);

              if (sound && sound._node && !sound._node._unlocked) {
                sound._node._unlocked = true;
                sound._node.load();
              }
            }
          }
        }

        // Fix Android can not play in suspend state.
        self._autoResume();

        // Create an empty buffer.
        var source = self.ctx.createBufferSource();
        source.buffer = self._scratchBuffer;
        source.connect(self.ctx.destination);

        // Play the empty buffer.
        if (typeof source.start === 'undefined') {
          source.noteOn(0);
        } else {
          source.start(0);
        }

        // Calling resume() on a stack initiated by user gesture is what actually unlocks the audio on Android Chrome >= 55.
        if (typeof self.ctx.resume === 'function') {
          self.ctx.resume();
        }

        // Setup a timeout to check that we are unlocked on the next event loop.
        source.onended = function() {
          source.disconnect(0);

          // Update the unlocked state and prevent this check from happening again.
          self._audioUnlocked = true;

          // Remove the touch start listener.
          document.removeEventListener('touchstart', unlock, true);
          document.removeEventListener('touchend', unlock, true);
          document.removeEventListener('click', unlock, true);

          // Let all sounds know that audio has been unlocked.
          for (var i=0; i<self._howls.length; i++) {
            self._howls[i]._emit('unlock');
          }
        };
      };

      // Setup a touch start listener to attempt an unlock in.
      document.addEventListener('touchstart', unlock, true);
      document.addEventListener('touchend', unlock, true);
      document.addEventListener('click', unlock, true);

      return self;
    },

    /**
     * Get an unlocked HTML5 Audio object from the pool. If none are left,
     * return a new Audio object and throw a warning.
     * @return {Audio} HTML5 Audio object.
     */
    _obtainHtml5Audio: function() {
      var self = this || Howler;

      // Return the next object from the pool if one exists.
      if (self._html5AudioPool.length) {
        return self._html5AudioPool.pop();
      }

      //.Check if the audio is locked and throw a warning.
      var testPlay = new Audio().play();
      if (testPlay && typeof Promise !== 'undefined' && (testPlay instanceof Promise || typeof testPlay.then === 'function')) {
        testPlay.catch(function() {
          console.warn('HTML5 Audio pool exhausted, returning potentially locked audio object.');
        });
      }

      return new Audio();
    },

    /**
     * Return an activated HTML5 Audio object to the pool.
     * @return {Howler}
     */
    _releaseHtml5Audio: function(audio) {
      var self = this || Howler;

      // Don't add audio to the pool if we don't know if it has been unlocked.
      if (audio._unlocked) {
        self._html5AudioPool.push(audio);
      }

      return self;
    },

    /**
     * Automatically suspend the Web Audio AudioContext after no sound has played for 30 seconds.
     * This saves processing/energy and fixes various browser-specific bugs with audio getting stuck.
     * @return {Howler}
     */
    _autoSuspend: function() {
      var self = this;

      if (!self.autoSuspend || !self.ctx || typeof self.ctx.suspend === 'undefined' || !Howler.usingWebAudio) {
        return;
      }

      // Check if any sounds are playing.
      for (var i=0; i<self._howls.length; i++) {
        if (self._howls[i]._webAudio) {
          for (var j=0; j<self._howls[i]._sounds.length; j++) {
            if (!self._howls[i]._sounds[j]._paused) {
              return self;
            }
          }
        }
      }

      if (self._suspendTimer) {
        clearTimeout(self._suspendTimer);
      }

      // If no sound has played after 30 seconds, suspend the context.
      self._suspendTimer = setTimeout(function() {
        if (!self.autoSuspend) {
          return;
        }

        self._suspendTimer = null;
        self.state = 'suspending';

        // Handle updating the state of the audio context after suspending.
        var handleSuspension = function() {
          self.state = 'suspended';

          if (self._resumeAfterSuspend) {
            delete self._resumeAfterSuspend;
            self._autoResume();
          }
        };

        // Either the state gets suspended or it is interrupted.
        // Either way, we need to update the state to suspended.
        self.ctx.suspend().then(handleSuspension, handleSuspension);
      }, 30000);

      return self;
    },

    /**
     * Automatically resume the Web Audio AudioContext when a new sound is played.
     * @return {Howler}
     */
    _autoResume: function() {
      var self = this;

      if (!self.ctx || typeof self.ctx.resume === 'undefined' || !Howler.usingWebAudio) {
        return;
      }

      if (self.state === 'running' && self.ctx.state !== 'interrupted' && self._suspendTimer) {
        clearTimeout(self._suspendTimer);
        self._suspendTimer = null;
      } else if (self.state === 'suspended' || self.state === 'running' && self.ctx.state === 'interrupted') {
        self.ctx.resume().then(function() {
          self.state = 'running';

          // Emit to all Howls that the audio has resumed.
          for (var i=0; i<self._howls.length; i++) {
            self._howls[i]._emit('resume');
          }
        });

        if (self._suspendTimer) {
          clearTimeout(self._suspendTimer);
          self._suspendTimer = null;
        }
      } else if (self.state === 'suspending') {
        self._resumeAfterSuspend = true;
      }

      return self;
    }
  };

  // Setup the global audio controller.
  var Howler = new HowlerGlobal();

  /** Group Methods **/
  /***************************************************************************/

  /**
   * Create an audio group controller.
   * @param {Object} o Passed in properties for this group.
   */
  var Howl = function(o) {
    var self = this;

    // Throw an error if no source is provided.
    if (!o.src || o.src.length === 0) {
      console.error('An array of source files must be passed with any new Howl.');
      return;
    }

    self.init(o);
  };
  Howl.prototype = {
    /**
     * Initialize a new Howl group object.
     * @param  {Object} o Passed in properties for this group.
     * @return {Howl}
     */
    init: function(o) {
      var self = this;

      // If we don't have an AudioContext created yet, run the setup.
      if (!Howler.ctx) {
        setupAudioContext();
      }

      // Setup user-defined default properties.
      self._autoplay = o.autoplay || false;
      self._format = (typeof o.format !== 'string') ? o.format : [o.format];
      self._html5 = o.html5 || false;
      self._muted = o.mute || false;
      self._loop = o.loop || false;
      self._pool = o.pool || 5;
      self._preload = (typeof o.preload === 'boolean' || o.preload === 'metadata') ? o.preload : true;
      self._rate = o.rate || 1;
      self._sprite = o.sprite || {};
      self._src = (typeof o.src !== 'string') ? o.src : [o.src];
      self._volume = o.volume !== undefined ? o.volume : 1;
      self._xhr = {
        method: o.xhr && o.xhr.method ? o.xhr.method : 'GET',
        headers: o.xhr && o.xhr.headers ? o.xhr.headers : null,
        withCredentials: o.xhr && o.xhr.withCredentials ? o.xhr.withCredentials : false,
      };

      // Setup all other default properties.
      self._duration = 0;
      self._state = 'unloaded';
      self._sounds = [];
      self._endTimers = {};
      self._queue = [];
      self._playLock = false;

      // Setup event listeners.
      self._onend = o.onend ? [{fn: o.onend}] : [];
      self._onfade = o.onfade ? [{fn: o.onfade}] : [];
      self._onload = o.onload ? [{fn: o.onload}] : [];
      self._onloaderror = o.onloaderror ? [{fn: o.onloaderror}] : [];
      self._onplayerror = o.onplayerror ? [{fn: o.onplayerror}] : [];
      self._onpause = o.onpause ? [{fn: o.onpause}] : [];
      self._onplay = o.onplay ? [{fn: o.onplay}] : [];
      self._onstop = o.onstop ? [{fn: o.onstop}] : [];
      self._onmute = o.onmute ? [{fn: o.onmute}] : [];
      self._onvolume = o.onvolume ? [{fn: o.onvolume}] : [];
      self._onrate = o.onrate ? [{fn: o.onrate}] : [];
      self._onseek = o.onseek ? [{fn: o.onseek}] : [];
      self._onunlock = o.onunlock ? [{fn: o.onunlock}] : [];
      self._onresume = [];

      // Web Audio or HTML5 Audio?
      self._webAudio = Howler.usingWebAudio && !self._html5;

      // Automatically try to enable audio.
      if (typeof Howler.ctx !== 'undefined' && Howler.ctx && Howler.autoUnlock) {
        Howler._unlockAudio();
      }

      // Keep track of this Howl group in the global controller.
      Howler._howls.push(self);

      // If they selected autoplay, add a play event to the load queue.
      if (self._autoplay) {
        self._queue.push({
          event: 'play',
          action: function() {
            self.play();
          }
        });
      }

      // Load the source file unless otherwise specified.
      if (self._preload && self._preload !== 'none') {
        self.load();
      }

      return self;
    },

    /**
     * Load the audio file.
     * @return {Howler}
     */
    load: function() {
      var self = this;
      var url = null;

      // If no audio is available, quit immediately.
      if (Howler.noAudio) {
        self._emit('loaderror', null, 'No audio support.');
        return;
      }

      // Make sure our source is in an array.
      if (typeof self._src === 'string') {
        self._src = [self._src];
      }

      // Loop through the sources and pick the first one that is compatible.
      for (var i=0; i<self._src.length; i++) {
        var ext, str;

        if (self._format && self._format[i]) {
          // If an extension was specified, use that instead.
          ext = self._format[i];
        } else {
          // Make sure the source is a string.
          str = self._src[i];
          if (typeof str !== 'string') {
            self._emit('loaderror', null, 'Non-string found in selected audio sources - ignoring.');
            continue;
          }

          // Extract the file extension from the URL or base64 data URI.
          ext = /^data:audio\/([^;,]+);/i.exec(str);
          if (!ext) {
            ext = /\.([^.]+)$/.exec(str.split('?', 1)[0]);
          }

          if (ext) {
            ext = ext[1].toLowerCase();
          }
        }

        // Log a warning if no extension was found.
        if (!ext) {
          console.warn('No file extension was found. Consider using the "format" property or specify an extension.');
        }

        // Check if this extension is available.
        if (ext && Howler.codecs(ext)) {
          url = self._src[i];
          break;
        }
      }

      if (!url) {
        self._emit('loaderror', null, 'No codec support for selected audio sources.');
        return;
      }

      self._src = url;
      self._state = 'loading';

      // If the hosting page is HTTPS and the source isn't,
      // drop down to HTML5 Audio to avoid Mixed Content errors.
      if (window.location.protocol === 'https:' && url.slice(0, 5) === 'http:') {
        self._html5 = true;
        self._webAudio = false;
      }

      // Create a new sound object and add it to the pool.
      new Sound(self);

      // Load and decode the audio data for playback.
      if (self._webAudio) {
        loadBuffer(self);
      }

      return self;
    },

    /**
     * Play a sound or resume previous playback.
     * @param  {String/Number} sprite   Sprite name for sprite playback or sound id to continue previous.
     * @param  {Boolean} internal Internal Use: true prevents event firing.
     * @return {Number}          Sound ID.
     */
    play: function(sprite, internal) {
      var self = this;
      var id = null;

      // Determine if a sprite, sound id or nothing was passed
      if (typeof sprite === 'number') {
        id = sprite;
        sprite = null;
      } else if (typeof sprite === 'string' && self._state === 'loaded' && !self._sprite[sprite]) {
        // If the passed sprite doesn't exist, do nothing.
        return null;
      } else if (typeof sprite === 'undefined') {
        // Use the default sound sprite (plays the full audio length).
        sprite = '__default';

        // Check if there is a single paused sound that isn't ended.
        // If there is, play that sound. If not, continue as usual.
        if (!self._playLock) {
          var num = 0;
          for (var i=0; i<self._sounds.length; i++) {
            if (self._sounds[i]._paused && !self._sounds[i]._ended) {
              num++;
              id = self._sounds[i]._id;
            }
          }

          if (num === 1) {
            sprite = null;
          } else {
            id = null;
          }
        }
      }

      // Get the selected node, or get one from the pool.
      var sound = id ? self._soundById(id) : self._inactiveSound();

      // If the sound doesn't exist, do nothing.
      if (!sound) {
        return null;
      }

      // Select the sprite definition.
      if (id && !sprite) {
        sprite = sound._sprite || '__default';
      }

      // If the sound hasn't loaded, we must wait to get the audio's duration.
      // We also need to wait to make sure we don't run into race conditions with
      // the order of function calls.
      if (self._state !== 'loaded') {
        // Set the sprite value on this sound.
        sound._sprite = sprite;

        // Mark this sound as not ended in case another sound is played before this one loads.
        sound._ended = false;

        // Add the sound to the queue to be played on load.
        var soundId = sound._id;
        self._queue.push({
          event: 'play',
          action: function() {
            self.play(soundId);
          }
        });

        return soundId;
      }

      // Don't play the sound if an id was passed and it is already playing.
      if (id && !sound._paused) {
        // Trigger the play event, in order to keep iterating through queue.
        if (!internal) {
          self._loadQueue('play');
        }

        return sound._id;
      }

      // Make sure the AudioContext isn't suspended, and resume it if it is.
      if (self._webAudio) {
        Howler._autoResume();
      }

      // Determine how long to play for and where to start playing.
      var seek = Math.max(0, sound._seek > 0 ? sound._seek : self._sprite[sprite][0] / 1000);
      var duration = Math.max(0, ((self._sprite[sprite][0] + self._sprite[sprite][1]) / 1000) - seek);
      var timeout = (duration * 1000) / Math.abs(sound._rate);
      var start = self._sprite[sprite][0] / 1000;
      var stop = (self._sprite[sprite][0] + self._sprite[sprite][1]) / 1000;
      sound._sprite = sprite;

      // Mark the sound as ended instantly so that this async playback
      // doesn't get grabbed by another call to play while this one waits to start.
      sound._ended = false;

      // Update the parameters of the sound.
      var setParams = function() {
        sound._paused = false;
        sound._seek = seek;
        sound._start = start;
        sound._stop = stop;
        sound._loop = !!(sound._loop || self._sprite[sprite][2]);
      };

      // End the sound instantly if seek is at the end.
      if (seek >= stop) {
        self._ended(sound);
        return;
      }

      // Begin the actual playback.
      var node = sound._node;
      if (self._webAudio) {
        // Fire this when the sound is ready to play to begin Web Audio playback.
        var playWebAudio = function() {
          self._playLock = false;
          setParams();
          self._refreshBuffer(sound);

          // Setup the playback params.
          var vol = (sound._muted || self._muted) ? 0 : sound._volume;
          node.gain.setValueAtTime(vol, Howler.ctx.currentTime);
          sound._playStart = Howler.ctx.currentTime;

          // Play the sound using the supported method.
          if (typeof node.bufferSource.start === 'undefined') {
            sound._loop ? node.bufferSource.noteGrainOn(0, seek, 86400) : node.bufferSource.noteGrainOn(0, seek, duration);
          } else {
            sound._loop ? node.bufferSource.start(0, seek, 86400) : node.bufferSource.start(0, seek, duration);
          }

          // Start a new timer if none is present.
          if (timeout !== Infinity) {
            self._endTimers[sound._id] = setTimeout(self._ended.bind(self, sound), timeout);
          }

          if (!internal) {
            setTimeout(function() {
              self._emit('play', sound._id);
              self._loadQueue();
            }, 0);
          }
        };

        if (Howler.state === 'running' && Howler.ctx.state !== 'interrupted') {
          playWebAudio();
        } else {
          self._playLock = true;

          // Wait for the audio context to resume before playing.
          self.once('resume', playWebAudio);

          // Cancel the end timer.
          self._clearTimer(sound._id);
        }
      } else {
        // Fire this when the sound is ready to play to begin HTML5 Audio playback.
        var playHtml5 = function() {
          node.currentTime = seek;
          node.muted = sound._muted || self._muted || Howler._muted || node.muted;
          node.volume = sound._volume * Howler.volume();
          node.playbackRate = sound._rate;

          // Some browsers will throw an error if this is called without user interaction.
          try {
            var play = node.play();

            // Support older browsers that don't support promises, and thus don't have this issue.
            if (play && typeof Promise !== 'undefined' && (play instanceof Promise || typeof play.then === 'function')) {
              // Implements a lock to prevent DOMException: The play() request was interrupted by a call to pause().
              self._playLock = true;

              // Set param values immediately.
              setParams();

              // Releases the lock and executes queued actions.
              play
                .then(function() {
                  self._playLock = false;
                  node._unlocked = true;
                  if (!internal) {
                    self._emit('play', sound._id);
                    self._loadQueue();
                  }
                })
                .catch(function() {
                  self._playLock = false;
                  self._emit('playerror', sound._id, 'Playback was unable to start. This is most commonly an issue ' +
                    'on mobile devices and Chrome where playback was not within a user interaction.');

                  // Reset the ended and paused values.
                  sound._ended = true;
                  sound._paused = true;
                });
            } else if (!internal) {
              self._playLock = false;
              setParams();
              self._emit('play', sound._id);
              self._loadQueue();
            }

            // Setting rate before playing won't work in IE, so we set it again here.
            node.playbackRate = sound._rate;

            // If the node is still paused, then we can assume there was a playback issue.
            if (node.paused) {
              self._emit('playerror', sound._id, 'Playback was unable to start. This is most commonly an issue ' +
                'on mobile devices and Chrome where playback was not within a user interaction.');
              return;
            }

            // Setup the end timer on sprites or listen for the ended event.
            if (sprite !== '__default' || sound._loop) {
              self._endTimers[sound._id] = setTimeout(self._ended.bind(self, sound), timeout);
            } else {
              self._endTimers[sound._id] = function() {
                // Fire ended on this audio node.
                self._ended(sound);

                // Clear this listener.
                node.removeEventListener('ended', self._endTimers[sound._id], false);
              };
              node.addEventListener('ended', self._endTimers[sound._id], false);
            }
          } catch (err) {
            self._emit('playerror', sound._id, err);
          }
        };

        // If this is streaming audio, make sure the src is set and load again.
        if (node.src === 'data:audio/wav;base64,UklGRigAAABXQVZFZm10IBIAAAABAAEARKwAAIhYAQACABAAAABkYXRhAgAAAAEA') {
          node.src = self._src;
          node.load();
        }

        // Play immediately if ready, or wait for the 'canplaythrough'e vent.
        var loadedNoReadyState = (window && window.ejecta) || (!node.readyState && Howler._navigator.isCocoonJS);
        if (node.readyState >= 3 || loadedNoReadyState) {
          playHtml5();
        } else {
          self._playLock = true;

          var listener = function() {
            // Begin playback.
            playHtml5();

            // Clear this listener.
            node.removeEventListener(Howler._canPlayEvent, listener, false);
          };
          node.addEventListener(Howler._canPlayEvent, listener, false);

          // Cancel the end timer.
          self._clearTimer(sound._id);
        }
      }

      return sound._id;
    },

    /**
     * Pause playback and save current position.
     * @param  {Number} id The sound ID (empty to pause all in group).
     * @return {Howl}
     */
    pause: function(id) {
      var self = this;

      // If the sound hasn't loaded or a play() promise is pending, add it to the load queue to pause when capable.
      if (self._state !== 'loaded' || self._playLock) {
        self._queue.push({
          event: 'pause',
          action: function() {
            self.pause(id);
          }
        });

        return self;
      }

      // If no id is passed, get all ID's to be paused.
      var ids = self._getSoundIds(id);

      for (var i=0; i<ids.length; i++) {
        // Clear the end timer.
        self._clearTimer(ids[i]);

        // Get the sound.
        var sound = self._soundById(ids[i]);

        if (sound && !sound._paused) {
          // Reset the seek position.
          sound._seek = self.seek(ids[i]);
          sound._rateSeek = 0;
          sound._paused = true;

          // Stop currently running fades.
          self._stopFade(ids[i]);

          if (sound._node) {
            if (self._webAudio) {
              // Make sure the sound has been created.
              if (!sound._node.bufferSource) {
                continue;
              }

              if (typeof sound._node.bufferSource.stop === 'undefined') {
                sound._node.bufferSource.noteOff(0);
              } else {
                sound._node.bufferSource.stop(0);
              }

              // Clean up the buffer source.
              self._cleanBuffer(sound._node);
            } else if (!isNaN(sound._node.duration) || sound._node.duration === Infinity) {
              sound._node.pause();
            }
          }
        }

        // Fire the pause event, unless `true` is passed as the 2nd argument.
        if (!arguments[1]) {
          self._emit('pause', sound ? sound._id : null);
        }
      }

      return self;
    },

    /**
     * Stop playback and reset to start.
     * @param  {Number} id The sound ID (empty to stop all in group).
     * @param  {Boolean} internal Internal Use: true prevents event firing.
     * @return {Howl}
     */
    stop: function(id, internal) {
      var self = this;

      // If the sound hasn't loaded, add it to the load queue to stop when capable.
      if (self._state !== 'loaded' || self._playLock) {
        self._queue.push({
          event: 'stop',
          action: function() {
            self.stop(id);
          }
        });

        return self;
      }

      // If no id is passed, get all ID's to be stopped.
      var ids = self._getSoundIds(id);

      for (var i=0; i<ids.length; i++) {
        // Clear the end timer.
        self._clearTimer(ids[i]);

        // Get the sound.
        var sound = self._soundById(ids[i]);

        if (sound) {
          // Reset the seek position.
          sound._seek = sound._start || 0;
          sound._rateSeek = 0;
          sound._paused = true;
          sound._ended = true;

          // Stop currently running fades.
          self._stopFade(ids[i]);

          if (sound._node) {
            if (self._webAudio) {
              // Make sure the sound's AudioBufferSourceNode has been created.
              if (sound._node.bufferSource) {
                if (typeof sound._node.bufferSource.stop === 'undefined') {
                  sound._node.bufferSource.noteOff(0);
                } else {
                  sound._node.bufferSource.stop(0);
                }

                // Clean up the buffer source.
                self._cleanBuffer(sound._node);
              }
            } else if (!isNaN(sound._node.duration) || sound._node.duration === Infinity) {
              sound._node.currentTime = sound._start || 0;
              sound._node.pause();

              // If this is a live stream, stop download once the audio is stopped.
              if (sound._node.duration === Infinity) {
                self._clearSound(sound._node);
              }
            }
          }

          if (!internal) {
            self._emit('stop', sound._id);
          }
        }
      }

      return self;
    },

    /**
     * Mute/unmute a single sound or all sounds in this Howl group.
     * @param  {Boolean} muted Set to true to mute and false to unmute.
     * @param  {Number} id    The sound ID to update (omit to mute/unmute all).
     * @return {Howl}
     */
    mute: function(muted, id) {
      var self = this;

      // If the sound hasn't loaded, add it to the load queue to mute when capable.
      if (self._state !== 'loaded'|| self._playLock) {
        self._queue.push({
          event: 'mute',
          action: function() {
            self.mute(muted, id);
          }
        });

        return self;
      }

      // If applying mute/unmute to all sounds, update the group's value.
      if (typeof id === 'undefined') {
        if (typeof muted === 'boolean') {
          self._muted = muted;
        } else {
          return self._muted;
        }
      }

      // If no id is passed, get all ID's to be muted.
      var ids = self._getSoundIds(id);

      for (var i=0; i<ids.length; i++) {
        // Get the sound.
        var sound = self._soundById(ids[i]);

        if (sound) {
          sound._muted = muted;

          // Cancel active fade and set the volume to the end value.
          if (sound._interval) {
            self._stopFade(sound._id);
          }

          if (self._webAudio && sound._node) {
            sound._node.gain.setValueAtTime(muted ? 0 : sound._volume, Howler.ctx.currentTime);
          } else if (sound._node) {
            sound._node.muted = Howler._muted ? true : muted;
          }

          self._emit('mute', sound._id);
        }
      }

      return self;
    },

    /**
     * Get/set the volume of this sound or of the Howl group. This method can optionally take 0, 1 or 2 arguments.
     *   volume() -> Returns the group's volume value.
     *   volume(id) -> Returns the sound id's current volume.
     *   volume(vol) -> Sets the volume of all sounds in this Howl group.
     *   volume(vol, id) -> Sets the volume of passed sound id.
     * @return {Howl/Number} Returns self or current volume.
     */
    volume: function() {
      var self = this;
      var args = arguments;
      var vol, id;

      // Determine the values based on arguments.
      if (args.length === 0) {
        // Return the value of the groups' volume.
        return self._volume;
      } else if (args.length === 1 || args.length === 2 && typeof args[1] === 'undefined') {
        // First check if this is an ID, and if not, assume it is a new volume.
        var ids = self._getSoundIds();
        var index = ids.indexOf(args[0]);
        if (index >= 0) {
          id = parseInt(args[0], 10);
        } else {
          vol = parseFloat(args[0]);
        }
      } else if (args.length >= 2) {
        vol = parseFloat(args[0]);
        id = parseInt(args[1], 10);
      }

      // Update the volume or return the current volume.
      var sound;
      if (typeof vol !== 'undefined' && vol >= 0 && vol <= 1) {
        // If the sound hasn't loaded, add it to the load queue to change volume when capable.
        if (self._state !== 'loaded'|| self._playLock) {
          self._queue.push({
            event: 'volume',
            action: function() {
              self.volume.apply(self, args);
            }
          });

          return self;
        }

        // Set the group volume.
        if (typeof id === 'undefined') {
          self._volume = vol;
        }

        // Update one or all volumes.
        id = self._getSoundIds(id);
        for (var i=0; i<id.length; i++) {
          // Get the sound.
          sound = self._soundById(id[i]);

          if (sound) {
            sound._volume = vol;

            // Stop currently running fades.
            if (!args[2]) {
              self._stopFade(id[i]);
            }

            if (self._webAudio && sound._node && !sound._muted) {
              sound._node.gain.setValueAtTime(vol, Howler.ctx.currentTime);
            } else if (sound._node && !sound._muted) {
              sound._node.volume = vol * Howler.volume();
            }

            self._emit('volume', sound._id);
          }
        }
      } else {
        sound = id ? self._soundById(id) : self._sounds[0];
        return sound ? sound._volume : 0;
      }

      return self;
    },

    /**
     * Fade a currently playing sound between two volumes (if no id is passed, all sounds will fade).
     * @param  {Number} from The value to fade from (0.0 to 1.0).
     * @param  {Number} to   The volume to fade to (0.0 to 1.0).
     * @param  {Number} len  Time in milliseconds to fade.
     * @param  {Number} id   The sound id (omit to fade all sounds).
     * @return {Howl}
     */
    fade: function(from, to, len, id) {
      var self = this;

      // If the sound hasn't loaded, add it to the load queue to fade when capable.
      if (self._state !== 'loaded' || self._playLock) {
        self._queue.push({
          event: 'fade',
          action: function() {
            self.fade(from, to, len, id);
          }
        });

        return self;
      }

      // Make sure the to/from/len values are numbers.
      from = Math.min(Math.max(0, parseFloat(from)), 1);
      to = Math.min(Math.max(0, parseFloat(to)), 1);
      len = parseFloat(len);

      // Set the volume to the start position.
      self.volume(from, id);

      // Fade the volume of one or all sounds.
      var ids = self._getSoundIds(id);
      for (var i=0; i<ids.length; i++) {
        // Get the sound.
        var sound = self._soundById(ids[i]);

        // Create a linear fade or fall back to timeouts with HTML5 Audio.
        if (sound) {
          // Stop the previous fade if no sprite is being used (otherwise, volume handles this).
          if (!id) {
            self._stopFade(ids[i]);
          }

          // If we are using Web Audio, let the native methods do the actual fade.
          if (self._webAudio && !sound._muted) {
            var currentTime = Howler.ctx.currentTime;
            var end = currentTime + (len / 1000);
            sound._volume = from;
            sound._node.gain.setValueAtTime(from, currentTime);
            sound._node.gain.linearRampToValueAtTime(to, end);
          }

          self._startFadeInterval(sound, from, to, len, ids[i], typeof id === 'undefined');
        }
      }

      return self;
    },

    /**
     * Starts the internal interval to fade a sound.
     * @param  {Object} sound Reference to sound to fade.
     * @param  {Number} from The value to fade from (0.0 to 1.0).
     * @param  {Number} to   The volume to fade to (0.0 to 1.0).
     * @param  {Number} len  Time in milliseconds to fade.
     * @param  {Number} id   The sound id to fade.
     * @param  {Boolean} isGroup   If true, set the volume on the group.
     */
    _startFadeInterval: function(sound, from, to, len, id, isGroup) {
      var self = this;
      var vol = from;
      var diff = to - from;
      var steps = Math.abs(diff / 0.01);
      var stepLen = Math.max(4, (steps > 0) ? len / steps : len);
      var lastTick = Date.now();

      // Store the value being faded to.
      sound._fadeTo = to;

      // Update the volume value on each interval tick.
      sound._interval = setInterval(function() {
        // Update the volume based on the time since the last tick.
        var tick = (Date.now() - lastTick) / len;
        lastTick = Date.now();
        vol += diff * tick;

        // Make sure the volume is in the right bounds.
        if (diff < 0) {
          vol = Math.max(to, vol);
        } else {
          vol = Math.min(to, vol);
        }

        // Round to within 2 decimal points.
        vol = Math.round(vol * 100) / 100;

        // Change the volume.
        if (self._webAudio) {
          sound._volume = vol;
        } else {
          self.volume(vol, sound._id, true);
        }

        // Set the group's volume.
        if (isGroup) {
          self._volume = vol;
        }

        // When the fade is complete, stop it and fire event.
        if ((to < from && vol <= to) || (to > from && vol >= to)) {
          clearInterval(sound._interval);
          sound._interval = null;
          sound._fadeTo = null;
          self.volume(to, sound._id);
          self._emit('fade', sound._id);
        }
      }, stepLen);
    },

    /**
     * Internal method that stops the currently playing fade when
     * a new fade starts, volume is changed or the sound is stopped.
     * @param  {Number} id The sound id.
     * @return {Howl}
     */
    _stopFade: function(id) {
      var self = this;
      var sound = self._soundById(id);

      if (sound && sound._interval) {
        if (self._webAudio) {
          sound._node.gain.cancelScheduledValues(Howler.ctx.currentTime);
        }

        clearInterval(sound._interval);
        sound._interval = null;
        self.volume(sound._fadeTo, id);
        sound._fadeTo = null;
        self._emit('fade', id);
      }

      return self;
    },

    /**
     * Get/set the loop parameter on a sound. This method can optionally take 0, 1 or 2 arguments.
     *   loop() -> Returns the group's loop value.
     *   loop(id) -> Returns the sound id's loop value.
     *   loop(loop) -> Sets the loop value for all sounds in this Howl group.
     *   loop(loop, id) -> Sets the loop value of passed sound id.
     * @return {Howl/Boolean} Returns self or current loop value.
     */
    loop: function() {
      var self = this;
      var args = arguments;
      var loop, id, sound;

      // Determine the values for loop and id.
      if (args.length === 0) {
        // Return the grou's loop value.
        return self._loop;
      } else if (args.length === 1) {
        if (typeof args[0] === 'boolean') {
          loop = args[0];
          self._loop = loop;
        } else {
          // Return this sound's loop value.
          sound = self._soundById(parseInt(args[0], 10));
          return sound ? sound._loop : false;
        }
      } else if (args.length === 2) {
        loop = args[0];
        id = parseInt(args[1], 10);
      }

      // If no id is passed, get all ID's to be looped.
      var ids = self._getSoundIds(id);
      for (var i=0; i<ids.length; i++) {
        sound = self._soundById(ids[i]);

        if (sound) {
          sound._loop = loop;
          if (self._webAudio && sound._node && sound._node.bufferSource) {
            sound._node.bufferSource.loop = loop;
            if (loop) {
              sound._node.bufferSource.loopStart = sound._start || 0;
              sound._node.bufferSource.loopEnd = sound._stop;
            }
          }
        }
      }

      return self;
    },

    /**
     * Get/set the playback rate of a sound. This method can optionally take 0, 1 or 2 arguments.
     *   rate() -> Returns the first sound node's current playback rate.
     *   rate(id) -> Returns the sound id's current playback rate.
     *   rate(rate) -> Sets the playback rate of all sounds in this Howl group.
     *   rate(rate, id) -> Sets the playback rate of passed sound id.
     * @return {Howl/Number} Returns self or the current playback rate.
     */
    rate: function() {
      var self = this;
      var args = arguments;
      var rate, id;

      // Determine the values based on arguments.
      if (args.length === 0) {
        // We will simply return the current rate of the first node.
        id = self._sounds[0]._id;
      } else if (args.length === 1) {
        // First check if this is an ID, and if not, assume it is a new rate value.
        var ids = self._getSoundIds();
        var index = ids.indexOf(args[0]);
        if (index >= 0) {
          id = parseInt(args[0], 10);
        } else {
          rate = parseFloat(args[0]);
        }
      } else if (args.length === 2) {
        rate = parseFloat(args[0]);
        id = parseInt(args[1], 10);
      }

      // Update the playback rate or return the current value.
      var sound;
      if (typeof rate === 'number') {
        // If the sound hasn't loaded, add it to the load queue to change playback rate when capable.
        if (self._state !== 'loaded' || self._playLock) {
          self._queue.push({
            event: 'rate',
            action: function() {
              self.rate.apply(self, args);
            }
          });

          return self;
        }

        // Set the group rate.
        if (typeof id === 'undefined') {
          self._rate = rate;
        }

        // Update one or all volumes.
        id = self._getSoundIds(id);
        for (var i=0; i<id.length; i++) {
          // Get the sound.
          sound = self._soundById(id[i]);

          if (sound) {
            // Keep track of our position when the rate changed and update the playback
            // start position so we can properly adjust the seek position for time elapsed.
            if (self.playing(id[i])) {
              sound._rateSeek = self.seek(id[i]);
              sound._playStart = self._webAudio ? Howler.ctx.currentTime : sound._playStart;
            }
            sound._rate = rate;

            // Change the playback rate.
            if (self._webAudio && sound._node && sound._node.bufferSource) {
              sound._node.bufferSource.playbackRate.setValueAtTime(rate, Howler.ctx.currentTime);
            } else if (sound._node) {
              sound._node.playbackRate = rate;
            }

            // Reset the timers.
            var seek = self.seek(id[i]);
            var duration = ((self._sprite[sound._sprite][0] + self._sprite[sound._sprite][1]) / 1000) - seek;
            var timeout = (duration * 1000) / Math.abs(sound._rate);

            // Start a new end timer if sound is already playing.
            if (self._endTimers[id[i]] || !sound._paused) {
              self._clearTimer(id[i]);
              self._endTimers[id[i]] = setTimeout(self._ended.bind(self, sound), timeout);
            }

            self._emit('rate', sound._id);
          }
        }
      } else {
        sound = self._soundById(id);
        return sound ? sound._rate : self._rate;
      }

      return self;
    },

    /**
     * Get/set the seek position of a sound. This method can optionally take 0, 1 or 2 arguments.
     *   seek() -> Returns the first sound node's current seek position.
     *   seek(id) -> Returns the sound id's current seek position.
     *   seek(seek) -> Sets the seek position of the first sound node.
     *   seek(seek, id) -> Sets the seek position of passed sound id.
     * @return {Howl/Number} Returns self or the current seek position.
     */
    seek: function() {
      var self = this;
      var args = arguments;
      var seek, id;

      // Determine the values based on arguments.
      if (args.length === 0) {
        // We will simply return the current position of the first node.
        id = self._sounds[0]._id;
      } else if (args.length === 1) {
        // First check if this is an ID, and if not, assume it is a new seek position.
        var ids = self._getSoundIds();
        var index = ids.indexOf(args[0]);
        if (index >= 0) {
          id = parseInt(args[0], 10);
        } else if (self._sounds.length) {
          id = self._sounds[0]._id;
          seek = parseFloat(args[0]);
        }
      } else if (args.length === 2) {
        seek = parseFloat(args[0]);
        id = parseInt(args[1], 10);
      }

      // If there is no ID, bail out.
      if (typeof id === 'undefined') {
        return self;
      }

      // If the sound hasn't loaded, add it to the load queue to seek when capable.
      if (self._state !== 'loaded' || self._playLock) {
        self._queue.push({
          event: 'seek',
          action: function() {
            self.seek.apply(self, args);
          }
        });

        return self;
      }

      // Get the sound.
      var sound = self._soundById(id);

      if (sound) {
        if (typeof seek === 'number' && seek >= 0) {
          // Pause the sound and update position for restarting playback.
          var playing = self.playing(id);
          if (playing) {
            self.pause(id, true);
          }

          // Move the position of the track and cancel timer.
          sound._seek = seek;
          sound._ended = false;
          self._clearTimer(id);

          // Update the seek position for HTML5 Audio.
          if (!self._webAudio && sound._node && !isNaN(sound._node.duration)) {
            sound._node.currentTime = seek;
          }

          // Seek and emit when ready.
          var seekAndEmit = function() {
            self._emit('seek', id);

            // Restart the playback if the sound was playing.
            if (playing) {
              self.play(id, true);
            }
          };

          // Wait for the play lock to be unset before emitting (HTML5 Audio).
          if (playing && !self._webAudio) {
            var emitSeek = function() {
              if (!self._playLock) {
                seekAndEmit();
              } else {
                setTimeout(emitSeek, 0);
              }
            };
            setTimeout(emitSeek, 0);
          } else {
            seekAndEmit();
          }
        } else {
          if (self._webAudio) {
            var realTime = self.playing(id) ? Howler.ctx.currentTime - sound._playStart : 0;
            var rateSeek = sound._rateSeek ? sound._rateSeek - sound._seek : 0;
            return sound._seek + (rateSeek + realTime * Math.abs(sound._rate));
          } else {
            return sound._node.currentTime;
          }
        }
      }

      return self;
    },

    /**
     * Check if a specific sound is currently playing or not (if id is provided), or check if at least one of the sounds in the group is playing or not.
     * @param  {Number}  id The sound id to check. If none is passed, the whole sound group is checked.
     * @return {Boolean} True if playing and false if not.
     */
    playing: function(id) {
      var self = this;

      // Check the passed sound ID (if any).
      if (typeof id === 'number') {
        var sound = self._soundById(id);
        return sound ? !sound._paused : false;
      }

      // Otherwise, loop through all sounds and check if any are playing.
      for (var i=0; i<self._sounds.length; i++) {
        if (!self._sounds[i]._paused) {
          return true;
        }
      }

      return false;
    },

    /**
     * Get the duration of this sound. Passing a sound id will return the sprite duration.
     * @param  {Number} id The sound id to check. If none is passed, return full source duration.
     * @return {Number} Audio duration in seconds.
     */
    duration: function(id) {
      var self = this;
      var duration = self._duration;

      // If we pass an ID, get the sound and return the sprite length.
      var sound = self._soundById(id);
      if (sound) {
        duration = self._sprite[sound._sprite][1] / 1000;
      }

      return duration;
    },

    /**
     * Returns the current loaded state of this Howl.
     * @return {String} 'unloaded', 'loading', 'loaded'
     */
    state: function() {
      return this._state;
    },

    /**
     * Unload and destroy the current Howl object.
     * This will immediately stop all sound instances attached to this group.
     */
    unload: function() {
      var self = this;

      // Stop playing any active sounds.
      var sounds = self._sounds;
      for (var i=0; i<sounds.length; i++) {
        // Stop the sound if it is currently playing.
        if (!sounds[i]._paused) {
          self.stop(sounds[i]._id);
        }

        // Remove the source or disconnect.
        if (!self._webAudio) {
          // Set the source to 0-second silence to stop any downloading (except in IE).
          self._clearSound(sounds[i]._node);

          // Remove any event listeners.
          sounds[i]._node.removeEventListener('error', sounds[i]._errorFn, false);
          sounds[i]._node.removeEventListener(Howler._canPlayEvent, sounds[i]._loadFn, false);

          // Release the Audio object back to the pool.
          Howler._releaseHtml5Audio(sounds[i]._node);
        }

        // Empty out all of the nodes.
        delete sounds[i]._node;

        // Make sure all timers are cleared out.
        self._clearTimer(sounds[i]._id);
      }

      // Remove the references in the global Howler object.
      var index = Howler._howls.indexOf(self);
      if (index >= 0) {
        Howler._howls.splice(index, 1);
      }

      // Delete this sound from the cache (if no other Howl is using it).
      var remCache = true;
      for (i=0; i<Howler._howls.length; i++) {
        if (Howler._howls[i]._src === self._src || self._src.indexOf(Howler._howls[i]._src) >= 0) {
          remCache = false;
          break;
        }
      }

      if (cache && remCache) {
        delete cache[self._src];
      }

      // Clear global errors.
      Howler.noAudio = false;

      // Clear out `self`.
      self._state = 'unloaded';
      self._sounds = [];
      self = null;

      return null;
    },

    /**
     * Listen to a custom event.
     * @param  {String}   event Event name.
     * @param  {Function} fn    Listener to call.
     * @param  {Number}   id    (optional) Only listen to events for this sound.
     * @param  {Number}   once  (INTERNAL) Marks event to fire only once.
     * @return {Howl}
     */
    on: function(event, fn, id, once) {
      var self = this;
      var events = self['_on' + event];

      if (typeof fn === 'function') {
        events.push(once ? {id: id, fn: fn, once: once} : {id: id, fn: fn});
      }

      return self;
    },

    /**
     * Remove a custom event. Call without parameters to remove all events.
     * @param  {String}   event Event name.
     * @param  {Function} fn    Listener to remove. Leave empty to remove all.
     * @param  {Number}   id    (optional) Only remove events for this sound.
     * @return {Howl}
     */
    off: function(event, fn, id) {
      var self = this;
      var events = self['_on' + event];
      var i = 0;

      // Allow passing just an event and ID.
      if (typeof fn === 'number') {
        id = fn;
        fn = null;
      }

      if (fn || id) {
        // Loop through event store and remove the passed function.
        for (i=0; i<events.length; i++) {
          var isId = (id === events[i].id);
          if (fn === events[i].fn && isId || !fn && isId) {
            events.splice(i, 1);
            break;
          }
        }
      } else if (event) {
        // Clear out all events of this type.
        self['_on' + event] = [];
      } else {
        // Clear out all events of every type.
        var keys = Object.keys(self);
        for (i=0; i<keys.length; i++) {
          if ((keys[i].indexOf('_on') === 0) && Array.isArray(self[keys[i]])) {
            self[keys[i]] = [];
          }
        }
      }

      return self;
    },

    /**
     * Listen to a custom event and remove it once fired.
     * @param  {String}   event Event name.
     * @param  {Function} fn    Listener to call.
     * @param  {Number}   id    (optional) Only listen to events for this sound.
     * @return {Howl}
     */
    once: function(event, fn, id) {
      var self = this;

      // Setup the event listener.
      self.on(event, fn, id, 1);

      return self;
    },

    /**
     * Emit all events of a specific type and pass the sound id.
     * @param  {String} event Event name.
     * @param  {Number} id    Sound ID.
     * @param  {Number} msg   Message to go with event.
     * @return {Howl}
     */
    _emit: function(event, id, msg) {
      var self = this;
      var events = self['_on' + event];

      // Loop through event store and fire all functions.
      for (var i=events.length-1; i>=0; i--) {
        // Only fire the listener if the correct ID is used.
        if (!events[i].id || events[i].id === id || event === 'load') {
          setTimeout(function(fn) {
            fn.call(this, id, msg);
          }.bind(self, events[i].fn), 0);

          // If this event was setup with `once`, remove it.
          if (events[i].once) {
            self.off(event, events[i].fn, events[i].id);
          }
        }
      }

      // Pass the event type into load queue so that it can continue stepping.
      self._loadQueue(event);

      return self;
    },

    /**
     * Queue of actions initiated before the sound has loaded.
     * These will be called in sequence, with the next only firing
     * after the previous has finished executing (even if async like play).
     * @return {Howl}
     */
    _loadQueue: function(event) {
      var self = this;

      if (self._queue.length > 0) {
        var task = self._queue[0];

        // Remove this task if a matching event was passed.
        if (task.event === event) {
          self._queue.shift();
          self._loadQueue();
        }

        // Run the task if no event type is passed.
        if (!event) {
          task.action();
        }
      }

      return self;
    },

    /**
     * Fired when playback ends at the end of the duration.
     * @param  {Sound} sound The sound object to work with.
     * @return {Howl}
     */
    _ended: function(sound) {
      var self = this;
      var sprite = sound._sprite;

      // If we are using IE and there was network latency we may be clipping
      // audio before it completes playing. Lets check the node to make sure it
      // believes it has completed, before ending the playback.
      if (!self._webAudio && sound._node && !sound._node.paused && !sound._node.ended && sound._node.currentTime < sound._stop) {
        setTimeout(self._ended.bind(self, sound), 100);
        return self;
      }

      // Should this sound loop?
      var loop = !!(sound._loop || self._sprite[sprite][2]);

      // Fire the ended event.
      self._emit('end', sound._id);

      // Restart the playback for HTML5 Audio loop.
      if (!self._webAudio && loop) {
        self.stop(sound._id, true).play(sound._id);
      }

      // Restart this timer if on a Web Audio loop.
      if (self._webAudio && loop) {
        self._emit('play', sound._id);
        sound._seek = sound._start || 0;
        sound._rateSeek = 0;
        sound._playStart = Howler.ctx.currentTime;

        var timeout = ((sound._stop - sound._start) * 1000) / Math.abs(sound._rate);
        self._endTimers[sound._id] = setTimeout(self._ended.bind(self, sound), timeout);
      }

      // Mark the node as paused.
      if (self._webAudio && !loop) {
        sound._paused = true;
        sound._ended = true;
        sound._seek = sound._start || 0;
        sound._rateSeek = 0;
        self._clearTimer(sound._id);

        // Clean up the buffer source.
        self._cleanBuffer(sound._node);

        // Attempt to auto-suspend AudioContext if no sounds are still playing.
        Howler._autoSuspend();
      }

      // When using a sprite, end the track.
      if (!self._webAudio && !loop) {
        self.stop(sound._id, true);
      }

      return self;
    },

    /**
     * Clear the end timer for a sound playback.
     * @param  {Number} id The sound ID.
     * @return {Howl}
     */
    _clearTimer: function(id) {
      var self = this;

      if (self._endTimers[id]) {
        // Clear the timeout or remove the ended listener.
        if (typeof self._endTimers[id] !== 'function') {
          clearTimeout(self._endTimers[id]);
        } else {
          var sound = self._soundById(id);
          if (sound && sound._node) {
            sound._node.removeEventListener('ended', self._endTimers[id], false);
          }
        }

        delete self._endTimers[id];
      }

      return self;
    },

    /**
     * Return the sound identified by this ID, or return null.
     * @param  {Number} id Sound ID
     * @return {Object}    Sound object or null.
     */
    _soundById: function(id) {
      var self = this;

      // Loop through all sounds and find the one with this ID.
      for (var i=0; i<self._sounds.length; i++) {
        if (id === self._sounds[i]._id) {
          return self._sounds[i];
        }
      }

      return null;
    },

    /**
     * Return an inactive sound from the pool or create a new one.
     * @return {Sound} Sound playback object.
     */
    _inactiveSound: function() {
      var self = this;

      self._drain();

      // Find the first inactive node to recycle.
      for (var i=0; i<self._sounds.length; i++) {
        if (self._sounds[i]._ended) {
          return self._sounds[i].reset();
        }
      }

      // If no inactive node was found, create a new one.
      return new Sound(self);
    },

    /**
     * Drain excess inactive sounds from the pool.
     */
    _drain: function() {
      var self = this;
      var limit = self._pool;
      var cnt = 0;
      var i = 0;

      // If there are less sounds than the max pool size, we are done.
      if (self._sounds.length < limit) {
        return;
      }

      // Count the number of inactive sounds.
      for (i=0; i<self._sounds.length; i++) {
        if (self._sounds[i]._ended) {
          cnt++;
        }
      }

      // Remove excess inactive sounds, going in reverse order.
      for (i=self._sounds.length - 1; i>=0; i--) {
        if (cnt <= limit) {
          return;
        }

        if (self._sounds[i]._ended) {
          // Disconnect the audio source when using Web Audio.
          if (self._webAudio && self._sounds[i]._node) {
            self._sounds[i]._node.disconnect(0);
          }

          // Remove sounds until we have the pool size.
          self._sounds.splice(i, 1);
          cnt--;
        }
      }
    },

    /**
     * Get all ID's from the sounds pool.
     * @param  {Number} id Only return one ID if one is passed.
     * @return {Array}    Array of IDs.
     */
    _getSoundIds: function(id) {
      var self = this;

      if (typeof id === 'undefined') {
        var ids = [];
        for (var i=0; i<self._sounds.length; i++) {
          ids.push(self._sounds[i]._id);
        }

        return ids;
      } else {
        return [id];
      }
    },

    /**
     * Load the sound back into the buffer source.
     * @param  {Sound} sound The sound object to work with.
     * @return {Howl}
     */
    _refreshBuffer: function(sound) {
      var self = this;

      // Setup the buffer source for playback.
      sound._node.bufferSource = Howler.ctx.createBufferSource();
      sound._node.bufferSource.buffer = cache[self._src];

      // Connect to the correct node.
      if (sound._panner) {
        sound._node.bufferSource.connect(sound._panner);
      } else {
        sound._node.bufferSource.connect(sound._node);
      }

      // Setup looping and playback rate.
      sound._node.bufferSource.loop = sound._loop;
      if (sound._loop) {
        sound._node.bufferSource.loopStart = sound._start || 0;
        sound._node.bufferSource.loopEnd = sound._stop || 0;
      }
      sound._node.bufferSource.playbackRate.setValueAtTime(sound._rate, Howler.ctx.currentTime);

      return self;
    },

    /**
     * Prevent memory leaks by cleaning up the buffer source after playback.
     * @param  {Object} node Sound's audio node containing the buffer source.
     * @return {Howl}
     */
    _cleanBuffer: function(node) {
      var self = this;
      var isIOS = Howler._navigator && Howler._navigator.vendor.indexOf('Apple') >= 0;

      if (Howler._scratchBuffer && node.bufferSource) {
        node.bufferSource.onended = null;
        node.bufferSource.disconnect(0);
        if (isIOS) {
          try { node.bufferSource.buffer = Howler._scratchBuffer; } catch(e) {}
        }
      }
      node.bufferSource = null;

      return self;
    },

    /**
     * Set the source to a 0-second silence to stop any downloading (except in IE).
     * @param  {Object} node Audio node to clear.
     */
    _clearSound: function(node) {
      var checkIE = /MSIE |Trident\//.test(Howler._navigator && Howler._navigator.userAgent);
      if (!checkIE) {
        node.src = 'data:audio/wav;base64,UklGRigAAABXQVZFZm10IBIAAAABAAEARKwAAIhYAQACABAAAABkYXRhAgAAAAEA';
      }
    }
  };

  /** Single Sound Methods **/
  /***************************************************************************/

  /**
   * Setup the sound object, which each node attached to a Howl group is contained in.
   * @param {Object} howl The Howl parent group.
   */
  var Sound = function(howl) {
    this._parent = howl;
    this.init();
  };
  Sound.prototype = {
    /**
     * Initialize a new Sound object.
     * @return {Sound}
     */
    init: function() {
      var self = this;
      var parent = self._parent;

      // Setup the default parameters.
      self._muted = parent._muted;
      self._loop = parent._loop;
      self._volume = parent._volume;
      self._rate = parent._rate;
      self._seek = 0;
      self._paused = true;
      self._ended = true;
      self._sprite = '__default';

      // Generate a unique ID for this sound.
      self._id = ++Howler._counter;

      // Add itself to the parent's pool.
      parent._sounds.push(self);

      // Create the new node.
      self.create();

      return self;
    },

    /**
     * Create and setup a new sound object, whether HTML5 Audio or Web Audio.
     * @return {Sound}
     */
    create: function() {
      var self = this;
      var parent = self._parent;
      var volume = (Howler._muted || self._muted || self._parent._muted) ? 0 : self._volume;

      if (parent._webAudio) {
        // Create the gain node for controlling volume (the source will connect to this).
        self._node = (typeof Howler.ctx.createGain === 'undefined') ? Howler.ctx.createGainNode() : Howler.ctx.createGain();
        self._node.gain.setValueAtTime(volume, Howler.ctx.currentTime);
        self._node.paused = true;
        self._node.connect(Howler.masterGain);
      } else if (!Howler.noAudio) {
        // Get an unlocked Audio object from the pool.
        self._node = Howler._obtainHtml5Audio();

        // Listen for errors (http://dev.w3.org/html5/spec-author-view/spec.html#mediaerror).
        self._errorFn = self._errorListener.bind(self);
        self._node.addEventListener('error', self._errorFn, false);

        // Listen for 'canplaythrough' event to let us know the sound is ready.
        self._loadFn = self._loadListener.bind(self);
        self._node.addEventListener(Howler._canPlayEvent, self._loadFn, false);

        // Setup the new audio node.
        self._node.src = parent._src;
        self._node.preload = parent._preload === true ? 'auto' : parent._preload;
        self._node.volume = volume * Howler.volume();

        // Begin loading the source.
        self._node.load();
      }

      return self;
    },

    /**
     * Reset the parameters of this sound to the original state (for recycle).
     * @return {Sound}
     */
    reset: function() {
      var self = this;
      var parent = self._parent;

      // Reset all of the parameters of this sound.
      self._muted = parent._muted;
      self._loop = parent._loop;
      self._volume = parent._volume;
      self._rate = parent._rate;
      self._seek = 0;
      self._rateSeek = 0;
      self._paused = true;
      self._ended = true;
      self._sprite = '__default';

      // Generate a new ID so that it isn't confused with the previous sound.
      self._id = ++Howler._counter;

      return self;
    },

    /**
     * HTML5 Audio error listener callback.
     */
    _errorListener: function() {
      var self = this;

      // Fire an error event and pass back the code.
      self._parent._emit('loaderror', self._id, self._node.error ? self._node.error.code : 0);

      // Clear the event listener.
      self._node.removeEventListener('error', self._errorFn, false);
    },

    /**
     * HTML5 Audio canplaythrough listener callback.
     */
    _loadListener: function() {
      var self = this;
      var parent = self._parent;

      // Round up the duration to account for the lower precision in HTML5 Audio.
      parent._duration = Math.ceil(self._node.duration * 10) / 10;

      // Setup a sprite if none is defined.
      if (Object.keys(parent._sprite).length === 0) {
        parent._sprite = {__default: [0, parent._duration * 1000]};
      }

      if (parent._state !== 'loaded') {
        parent._state = 'loaded';
        parent._emit('load');
        parent._loadQueue();
      }

      // Clear the event listener.
      self._node.removeEventListener(Howler._canPlayEvent, self._loadFn, false);
    }
  };

  /** Helper Methods **/
  /***************************************************************************/

  var cache = {};

  /**
   * Buffer a sound from URL, Data URI or cache and decode to audio source (Web Audio API).
   * @param  {Howl} self
   */
  var loadBuffer = function(self) {
    var url = self._src;

    // Check if the buffer has already been cached and use it instead.
    if (cache[url]) {
      // Set the duration from the cache.
      self._duration = cache[url].duration;

      // Load the sound into this Howl.
      loadSound(self);

      return;
    }

    if (/^data:[^;]+;base64,/.test(url)) {
      // Decode the base64 data URI without XHR, since some browsers don't support it.
      var data = atob(url.split(',')[1]);
      var dataView = new Uint8Array(data.length);
      for (var i=0; i<data.length; ++i) {
        dataView[i] = data.charCodeAt(i);
      }

      decodeAudioData(dataView.buffer, self);
    } else {
      // Load the buffer from the URL.
      var xhr = new XMLHttpRequest();
      xhr.open(self._xhr.method, url, true);
      xhr.withCredentials = self._xhr.withCredentials;
      xhr.responseType = 'arraybuffer';

      // Apply any custom headers to the request.
      if (self._xhr.headers) {
        Object.keys(self._xhr.headers).forEach(function(key) {
          xhr.setRequestHeader(key, self._xhr.headers[key]);
        });
      }

      xhr.onload = function() {
        // Make sure we get a successful response back.
        var code = (xhr.status + '')[0];
        if (code !== '0' && code !== '2' && code !== '3') {
          self._emit('loaderror', null, 'Failed loading audio file with status: ' + xhr.status + '.');
          return;
        }

        decodeAudioData(xhr.response, self);
      };
      xhr.onerror = function() {
        // If there is an error, switch to HTML5 Audio.
        if (self._webAudio) {
          self._html5 = true;
          self._webAudio = false;
          self._sounds = [];
          delete cache[url];
          self.load();
        }
      };
      safeXhrSend(xhr);
    }
  };

  /**
   * Send the XHR request wrapped in a try/catch.
   * @param  {Object} xhr XHR to send.
   */
  var safeXhrSend = function(xhr) {
    try {
      xhr.send();
    } catch (e) {
      xhr.onerror();
    }
  };

  /**
   * Decode audio data from an array buffer.
   * @param  {ArrayBuffer} arraybuffer The audio data.
   * @param  {Howl}        self
   */
  var decodeAudioData = function(arraybuffer, self) {
    // Fire a load error if something broke.
    var error = function() {
      self._emit('loaderror', null, 'Decoding audio data failed.');
    };

    // Load the sound on success.
    var success = function(buffer) {
      if (buffer && self._sounds.length > 0) {
        cache[self._src] = buffer;
        loadSound(self, buffer);
      } else {
        error();
      }
    };

    // Decode the buffer into an audio source.
    if (typeof Promise !== 'undefined' && Howler.ctx.decodeAudioData.length === 1) {
      Howler.ctx.decodeAudioData(arraybuffer).then(success).catch(error);
    } else {
      Howler.ctx.decodeAudioData(arraybuffer, success, error);
    }
  }

  /**
   * Sound is now loaded, so finish setting everything up and fire the loaded event.
   * @param  {Howl} self
   * @param  {Object} buffer The decoded buffer sound source.
   */
  var loadSound = function(self, buffer) {
    // Set the duration.
    if (buffer && !self._duration) {
      self._duration = buffer.duration;
    }

    // Setup a sprite if none is defined.
    if (Object.keys(self._sprite).length === 0) {
      self._sprite = {__default: [0, self._duration * 1000]};
    }

    // Fire the loaded event.
    if (self._state !== 'loaded') {
      self._state = 'loaded';
      self._emit('load');
      self._loadQueue();
    }
  };

  /**
   * Setup the audio context when available, or switch to HTML5 Audio mode.
   */
  var setupAudioContext = function() {
    // If we have already detected that Web Audio isn't supported, don't run this step again.
    if (!Howler.usingWebAudio) {
      return;
    }

    // Check if we are using Web Audio and setup the AudioContext if we are.
    try {
      if (typeof AudioContext !== 'undefined') {
        Howler.ctx = new AudioContext();
      } else if (typeof webkitAudioContext !== 'undefined') {
        Howler.ctx = new webkitAudioContext();
      } else {
        Howler.usingWebAudio = false;
      }
    } catch(e) {
      Howler.usingWebAudio = false;
    }

    // If the audio context creation still failed, set using web audio to false.
    if (!Howler.ctx) {
      Howler.usingWebAudio = false;
    }

    // Check if a webview is being used on iOS8 or earlier (rather than the browser).
    // If it is, disable Web Audio as it causes crashing.
    var iOS = (/iP(hone|od|ad)/.test(Howler._navigator && Howler._navigator.platform));
    var appVersion = Howler._navigator && Howler._navigator.appVersion.match(/OS (\d+)_(\d+)_?(\d+)?/);
    var version = appVersion ? parseInt(appVersion[1], 10) : null;
    if (iOS && version && version < 9) {
      var safari = /safari/.test(Howler._navigator && Howler._navigator.userAgent.toLowerCase());
      if (Howler._navigator && !safari) {
        Howler.usingWebAudio = false;
      }
    }

    // Create and expose the master GainNode when using Web Audio (useful for plugins or advanced usage).
    if (Howler.usingWebAudio) {
      Howler.masterGain = (typeof Howler.ctx.createGain === 'undefined') ? Howler.ctx.createGainNode() : Howler.ctx.createGain();
      Howler.masterGain.gain.setValueAtTime(Howler._muted ? 0 : Howler._volume, Howler.ctx.currentTime);
      Howler.masterGain.connect(Howler.ctx.destination);
    }

    // Re-run the setup on Howler.
    Howler._setup();
  };

  // Add support for AMD (Asynchronous Module Definition) libraries such as require.js.
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
      return {
        Howler: Howler,
        Howl: Howl
      };
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  }

  // Add support for CommonJS libraries such as browserify.
  if (true) {
    exports.Howler = Howler;
    exports.Howl = Howl;
  }

  // Add to global in Node.js (for testing, etc).
  if (typeof global !== 'undefined') {
    global.HowlerGlobal = HowlerGlobal;
    global.Howler = Howler;
    global.Howl = Howl;
    global.Sound = Sound;
  } else if (typeof window !== 'undefined') {  // Define globally in case AMD is not available or unused.
    window.HowlerGlobal = HowlerGlobal;
    window.Howler = Howler;
    window.Howl = Howl;
    window.Sound = Sound;
  }
})();


/*!
 *  Spatial Plugin - Adds support for stereo and 3D audio where Web Audio is supported.
 *  
 *  howler.js v2.2.0
 *  howlerjs.com
 *
 *  (c) 2013-2020, James Simpson of GoldFire Studios
 *  goldfirestudios.com
 *
 *  MIT License
 */

(function() {

  'use strict';

  // Setup default properties.
  HowlerGlobal.prototype._pos = [0, 0, 0];
  HowlerGlobal.prototype._orientation = [0, 0, -1, 0, 1, 0];

  /** Global Methods **/
  /***************************************************************************/

  /**
   * Helper method to update the stereo panning position of all current Howls.
   * Future Howls will not use this value unless explicitly set.
   * @param  {Number} pan A value of -1.0 is all the way left and 1.0 is all the way right.
   * @return {Howler/Number}     Self or current stereo panning value.
   */
  HowlerGlobal.prototype.stereo = function(pan) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self.ctx || !self.ctx.listener) {
      return self;
    }

    // Loop through all Howls and update their stereo panning.
    for (var i=self._howls.length-1; i>=0; i--) {
      self._howls[i].stereo(pan);
    }

    return self;
  };

  /**
   * Get/set the position of the listener in 3D cartesian space. Sounds using
   * 3D position will be relative to the listener's position.
   * @param  {Number} x The x-position of the listener.
   * @param  {Number} y The y-position of the listener.
   * @param  {Number} z The z-position of the listener.
   * @return {Howler/Array}   Self or current listener position.
   */
  HowlerGlobal.prototype.pos = function(x, y, z) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self.ctx || !self.ctx.listener) {
      return self;
    }

    // Set the defaults for optional 'y' & 'z'.
    y = (typeof y !== 'number') ? self._pos[1] : y;
    z = (typeof z !== 'number') ? self._pos[2] : z;

    if (typeof x === 'number') {
      self._pos = [x, y, z];

      if (typeof self.ctx.listener.positionX !== 'undefined') {
        self.ctx.listener.positionX.setTargetAtTime(self._pos[0], Howler.ctx.currentTime, 0.1);
        self.ctx.listener.positionY.setTargetAtTime(self._pos[1], Howler.ctx.currentTime, 0.1);
        self.ctx.listener.positionZ.setTargetAtTime(self._pos[2], Howler.ctx.currentTime, 0.1);
      } else {
        self.ctx.listener.setPosition(self._pos[0], self._pos[1], self._pos[2]);
      }
    } else {
      return self._pos;
    }

    return self;
  };

  /**
   * Get/set the direction the listener is pointing in the 3D cartesian space.
   * A front and up vector must be provided. The front is the direction the
   * face of the listener is pointing, and up is the direction the top of the
   * listener is pointing. Thus, these values are expected to be at right angles
   * from each other.
   * @param  {Number} x   The x-orientation of the listener.
   * @param  {Number} y   The y-orientation of the listener.
   * @param  {Number} z   The z-orientation of the listener.
   * @param  {Number} xUp The x-orientation of the top of the listener.
   * @param  {Number} yUp The y-orientation of the top of the listener.
   * @param  {Number} zUp The z-orientation of the top of the listener.
   * @return {Howler/Array}     Returns self or the current orientation vectors.
   */
  HowlerGlobal.prototype.orientation = function(x, y, z, xUp, yUp, zUp) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self.ctx || !self.ctx.listener) {
      return self;
    }

    // Set the defaults for optional 'y' & 'z'.
    var or = self._orientation;
    y = (typeof y !== 'number') ? or[1] : y;
    z = (typeof z !== 'number') ? or[2] : z;
    xUp = (typeof xUp !== 'number') ? or[3] : xUp;
    yUp = (typeof yUp !== 'number') ? or[4] : yUp;
    zUp = (typeof zUp !== 'number') ? or[5] : zUp;

    if (typeof x === 'number') {
      self._orientation = [x, y, z, xUp, yUp, zUp];

      if (typeof self.ctx.listener.forwardX !== 'undefined') {
        self.ctx.listener.forwardX.setTargetAtTime(x, Howler.ctx.currentTime, 0.1);
        self.ctx.listener.forwardY.setTargetAtTime(y, Howler.ctx.currentTime, 0.1);
        self.ctx.listener.forwardZ.setTargetAtTime(z, Howler.ctx.currentTime, 0.1);
        self.ctx.listener.upX.setTargetAtTime(xUp, Howler.ctx.currentTime, 0.1);
        self.ctx.listener.upY.setTargetAtTime(yUp, Howler.ctx.currentTime, 0.1);
        self.ctx.listener.upZ.setTargetAtTime(zUp, Howler.ctx.currentTime, 0.1);
      } else {
        self.ctx.listener.setOrientation(x, y, z, xUp, yUp, zUp);
      }
    } else {
      return or;
    }

    return self;
  };

  /** Group Methods **/
  /***************************************************************************/

  /**
   * Add new properties to the core init.
   * @param  {Function} _super Core init method.
   * @return {Howl}
   */
  Howl.prototype.init = (function(_super) {
    return function(o) {
      var self = this;

      // Setup user-defined default properties.
      self._orientation = o.orientation || [1, 0, 0];
      self._stereo = o.stereo || null;
      self._pos = o.pos || null;
      self._pannerAttr = {
        coneInnerAngle: typeof o.coneInnerAngle !== 'undefined' ? o.coneInnerAngle : 360,
        coneOuterAngle: typeof o.coneOuterAngle !== 'undefined' ? o.coneOuterAngle : 360,
        coneOuterGain: typeof o.coneOuterGain !== 'undefined' ? o.coneOuterGain : 0,
        distanceModel: typeof o.distanceModel !== 'undefined' ? o.distanceModel : 'inverse',
        maxDistance: typeof o.maxDistance !== 'undefined' ? o.maxDistance : 10000,
        panningModel: typeof o.panningModel !== 'undefined' ? o.panningModel : 'HRTF',
        refDistance: typeof o.refDistance !== 'undefined' ? o.refDistance : 1,
        rolloffFactor: typeof o.rolloffFactor !== 'undefined' ? o.rolloffFactor : 1
      };

      // Setup event listeners.
      self._onstereo = o.onstereo ? [{fn: o.onstereo}] : [];
      self._onpos = o.onpos ? [{fn: o.onpos}] : [];
      self._onorientation = o.onorientation ? [{fn: o.onorientation}] : [];

      // Complete initilization with howler.js core's init function.
      return _super.call(this, o);
    };
  })(Howl.prototype.init);

  /**
   * Get/set the stereo panning of the audio source for this sound or all in the group.
   * @param  {Number} pan  A value of -1.0 is all the way left and 1.0 is all the way right.
   * @param  {Number} id (optional) The sound ID. If none is passed, all in group will be updated.
   * @return {Howl/Number}    Returns self or the current stereo panning value.
   */
  Howl.prototype.stereo = function(pan, id) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self._webAudio) {
      return self;
    }

    // If the sound hasn't loaded, add it to the load queue to change stereo pan when capable.
    if (self._state !== 'loaded') {
      self._queue.push({
        event: 'stereo',
        action: function() {
          self.stereo(pan, id);
        }
      });

      return self;
    }

    // Check for PannerStereoNode support and fallback to PannerNode if it doesn't exist.
    var pannerType = (typeof Howler.ctx.createStereoPanner === 'undefined') ? 'spatial' : 'stereo';

    // Setup the group's stereo panning if no ID is passed.
    if (typeof id === 'undefined') {
      // Return the group's stereo panning if no parameters are passed.
      if (typeof pan === 'number') {
        self._stereo = pan;
        self._pos = [pan, 0, 0];
      } else {
        return self._stereo;
      }
    }

    // Change the streo panning of one or all sounds in group.
    var ids = self._getSoundIds(id);
    for (var i=0; i<ids.length; i++) {
      // Get the sound.
      var sound = self._soundById(ids[i]);

      if (sound) {
        if (typeof pan === 'number') {
          sound._stereo = pan;
          sound._pos = [pan, 0, 0];

          if (sound._node) {
            // If we are falling back, make sure the panningModel is equalpower.
            sound._pannerAttr.panningModel = 'equalpower';

            // Check if there is a panner setup and create a new one if not.
            if (!sound._panner || !sound._panner.pan) {
              setupPanner(sound, pannerType);
            }

            if (pannerType === 'spatial') {
              if (typeof sound._panner.positionX !== 'undefined') {
                sound._panner.positionX.setValueAtTime(pan, Howler.ctx.currentTime);
                sound._panner.positionY.setValueAtTime(0, Howler.ctx.currentTime);
                sound._panner.positionZ.setValueAtTime(0, Howler.ctx.currentTime);
              } else {
                sound._panner.setPosition(pan, 0, 0);
              }
            } else {
              sound._panner.pan.setValueAtTime(pan, Howler.ctx.currentTime);
            }
          }

          self._emit('stereo', sound._id);
        } else {
          return sound._stereo;
        }
      }
    }

    return self;
  };

  /**
   * Get/set the 3D spatial position of the audio source for this sound or group relative to the global listener.
   * @param  {Number} x  The x-position of the audio source.
   * @param  {Number} y  The y-position of the audio source.
   * @param  {Number} z  The z-position of the audio source.
   * @param  {Number} id (optional) The sound ID. If none is passed, all in group will be updated.
   * @return {Howl/Array}    Returns self or the current 3D spatial position: [x, y, z].
   */
  Howl.prototype.pos = function(x, y, z, id) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self._webAudio) {
      return self;
    }

    // If the sound hasn't loaded, add it to the load queue to change position when capable.
    if (self._state !== 'loaded') {
      self._queue.push({
        event: 'pos',
        action: function() {
          self.pos(x, y, z, id);
        }
      });

      return self;
    }

    // Set the defaults for optional 'y' & 'z'.
    y = (typeof y !== 'number') ? 0 : y;
    z = (typeof z !== 'number') ? -0.5 : z;

    // Setup the group's spatial position if no ID is passed.
    if (typeof id === 'undefined') {
      // Return the group's spatial position if no parameters are passed.
      if (typeof x === 'number') {
        self._pos = [x, y, z];
      } else {
        return self._pos;
      }
    }

    // Change the spatial position of one or all sounds in group.
    var ids = self._getSoundIds(id);
    for (var i=0; i<ids.length; i++) {
      // Get the sound.
      var sound = self._soundById(ids[i]);

      if (sound) {
        if (typeof x === 'number') {
          sound._pos = [x, y, z];

          if (sound._node) {
            // Check if there is a panner setup and create a new one if not.
            if (!sound._panner || sound._panner.pan) {
              setupPanner(sound, 'spatial');
            }

            if (typeof sound._panner.positionX !== 'undefined') {
              sound._panner.positionX.setValueAtTime(x, Howler.ctx.currentTime);
              sound._panner.positionY.setValueAtTime(y, Howler.ctx.currentTime);
              sound._panner.positionZ.setValueAtTime(z, Howler.ctx.currentTime);
            } else {
              sound._panner.setPosition(x, y, z);
            }
          }

          self._emit('pos', sound._id);
        } else {
          return sound._pos;
        }
      }
    }

    return self;
  };

  /**
   * Get/set the direction the audio source is pointing in the 3D cartesian coordinate
   * space. Depending on how direction the sound is, based on the `cone` attributes,
   * a sound pointing away from the listener can be quiet or silent.
   * @param  {Number} x  The x-orientation of the source.
   * @param  {Number} y  The y-orientation of the source.
   * @param  {Number} z  The z-orientation of the source.
   * @param  {Number} id (optional) The sound ID. If none is passed, all in group will be updated.
   * @return {Howl/Array}    Returns self or the current 3D spatial orientation: [x, y, z].
   */
  Howl.prototype.orientation = function(x, y, z, id) {
    var self = this;

    // Stop right here if not using Web Audio.
    if (!self._webAudio) {
      return self;
    }

    // If the sound hasn't loaded, add it to the load queue to change orientation when capable.
    if (self._state !== 'loaded') {
      self._queue.push({
        event: 'orientation',
        action: function() {
          self.orientation(x, y, z, id);
        }
      });

      return self;
    }

    // Set the defaults for optional 'y' & 'z'.
    y = (typeof y !== 'number') ? self._orientation[1] : y;
    z = (typeof z !== 'number') ? self._orientation[2] : z;

    // Setup the group's spatial orientation if no ID is passed.
    if (typeof id === 'undefined') {
      // Return the group's spatial orientation if no parameters are passed.
      if (typeof x === 'number') {
        self._orientation = [x, y, z];
      } else {
        return self._orientation;
      }
    }

    // Change the spatial orientation of one or all sounds in group.
    var ids = self._getSoundIds(id);
    for (var i=0; i<ids.length; i++) {
      // Get the sound.
      var sound = self._soundById(ids[i]);

      if (sound) {
        if (typeof x === 'number') {
          sound._orientation = [x, y, z];

          if (sound._node) {
            // Check if there is a panner setup and create a new one if not.
            if (!sound._panner) {
              // Make sure we have a position to setup the node with.
              if (!sound._pos) {
                sound._pos = self._pos || [0, 0, -0.5];
              }

              setupPanner(sound, 'spatial');
            }

            if (typeof sound._panner.orientationX !== 'undefined') {
              sound._panner.orientationX.setValueAtTime(x, Howler.ctx.currentTime);
              sound._panner.orientationY.setValueAtTime(y, Howler.ctx.currentTime);
              sound._panner.orientationZ.setValueAtTime(z, Howler.ctx.currentTime);
            } else {
              sound._panner.setOrientation(x, y, z);
            }
          }

          self._emit('orientation', sound._id);
        } else {
          return sound._orientation;
        }
      }
    }

    return self;
  };

  /**
   * Get/set the panner node's attributes for a sound or group of sounds.
   * This method can optionall take 0, 1 or 2 arguments.
   *   pannerAttr() -> Returns the group's values.
   *   pannerAttr(id) -> Returns the sound id's values.
   *   pannerAttr(o) -> Set's the values of all sounds in this Howl group.
   *   pannerAttr(o, id) -> Set's the values of passed sound id.
   *
   *   Attributes:
   *     coneInnerAngle - (360 by default) A parameter for directional audio sources, this is an angle, in degrees,
   *                      inside of which there will be no volume reduction.
   *     coneOuterAngle - (360 by default) A parameter for directional audio sources, this is an angle, in degrees,
   *                      outside of which the volume will be reduced to a constant value of `coneOuterGain`.
   *     coneOuterGain - (0 by default) A parameter for directional audio sources, this is the gain outside of the
   *                     `coneOuterAngle`. It is a linear value in the range `[0, 1]`.
   *     distanceModel - ('inverse' by default) Determines algorithm used to reduce volume as audio moves away from
   *                     listener. Can be `linear`, `inverse` or `exponential.
   *     maxDistance - (10000 by default) The maximum distance between source and listener, after which the volume
   *                   will not be reduced any further.
   *     refDistance - (1 by default) A reference distance for reducing volume as source moves further from the listener.
   *                   This is simply a variable of the distance model and has a different effect depending on which model
   *                   is used and the scale of your coordinates. Generally, volume will be equal to 1 at this distance.
   *     rolloffFactor - (1 by default) How quickly the volume reduces as source moves from listener. This is simply a
   *                     variable of the distance model and can be in the range of `[0, 1]` with `linear` and `[0, ∞]`
   *                     with `inverse` and `exponential`.
   *     panningModel - ('HRTF' by default) Determines which spatialization algorithm is used to position audio.
   *                     Can be `HRTF` or `equalpower`.
   *
   * @return {Howl/Object} Returns self or current panner attributes.
   */
  Howl.prototype.pannerAttr = function() {
    var self = this;
    var args = arguments;
    var o, id, sound;

    // Stop right here if not using Web Audio.
    if (!self._webAudio) {
      return self;
    }

    // Determine the values based on arguments.
    if (args.length === 0) {
      // Return the group's panner attribute values.
      return self._pannerAttr;
    } else if (args.length === 1) {
      if (typeof args[0] === 'object') {
        o = args[0];

        // Set the grou's panner attribute values.
        if (typeof id === 'undefined') {
          if (!o.pannerAttr) {
            o.pannerAttr = {
              coneInnerAngle: o.coneInnerAngle,
              coneOuterAngle: o.coneOuterAngle,
              coneOuterGain: o.coneOuterGain,
              distanceModel: o.distanceModel,
              maxDistance: o.maxDistance,
              refDistance: o.refDistance,
              rolloffFactor: o.rolloffFactor,
              panningModel: o.panningModel
            };
          }

          self._pannerAttr = {
            coneInnerAngle: typeof o.pannerAttr.coneInnerAngle !== 'undefined' ? o.pannerAttr.coneInnerAngle : self._coneInnerAngle,
            coneOuterAngle: typeof o.pannerAttr.coneOuterAngle !== 'undefined' ? o.pannerAttr.coneOuterAngle : self._coneOuterAngle,
            coneOuterGain: typeof o.pannerAttr.coneOuterGain !== 'undefined' ? o.pannerAttr.coneOuterGain : self._coneOuterGain,
            distanceModel: typeof o.pannerAttr.distanceModel !== 'undefined' ? o.pannerAttr.distanceModel : self._distanceModel,
            maxDistance: typeof o.pannerAttr.maxDistance !== 'undefined' ? o.pannerAttr.maxDistance : self._maxDistance,
            refDistance: typeof o.pannerAttr.refDistance !== 'undefined' ? o.pannerAttr.refDistance : self._refDistance,
            rolloffFactor: typeof o.pannerAttr.rolloffFactor !== 'undefined' ? o.pannerAttr.rolloffFactor : self._rolloffFactor,
            panningModel: typeof o.pannerAttr.panningModel !== 'undefined' ? o.pannerAttr.panningModel : self._panningModel
          };
        }
      } else {
        // Return this sound's panner attribute values.
        sound = self._soundById(parseInt(args[0], 10));
        return sound ? sound._pannerAttr : self._pannerAttr;
      }
    } else if (args.length === 2) {
      o = args[0];
      id = parseInt(args[1], 10);
    }

    // Update the values of the specified sounds.
    var ids = self._getSoundIds(id);
    for (var i=0; i<ids.length; i++) {
      sound = self._soundById(ids[i]);

      if (sound) {
        // Merge the new values into the sound.
        var pa = sound._pannerAttr;
        pa = {
          coneInnerAngle: typeof o.coneInnerAngle !== 'undefined' ? o.coneInnerAngle : pa.coneInnerAngle,
          coneOuterAngle: typeof o.coneOuterAngle !== 'undefined' ? o.coneOuterAngle : pa.coneOuterAngle,
          coneOuterGain: typeof o.coneOuterGain !== 'undefined' ? o.coneOuterGain : pa.coneOuterGain,
          distanceModel: typeof o.distanceModel !== 'undefined' ? o.distanceModel : pa.distanceModel,
          maxDistance: typeof o.maxDistance !== 'undefined' ? o.maxDistance : pa.maxDistance,
          refDistance: typeof o.refDistance !== 'undefined' ? o.refDistance : pa.refDistance,
          rolloffFactor: typeof o.rolloffFactor !== 'undefined' ? o.rolloffFactor : pa.rolloffFactor,
          panningModel: typeof o.panningModel !== 'undefined' ? o.panningModel : pa.panningModel
        };

        // Update the panner values or create a new panner if none exists.
        var panner = sound._panner;
        if (panner) {
          panner.coneInnerAngle = pa.coneInnerAngle;
          panner.coneOuterAngle = pa.coneOuterAngle;
          panner.coneOuterGain = pa.coneOuterGain;
          panner.distanceModel = pa.distanceModel;
          panner.maxDistance = pa.maxDistance;
          panner.refDistance = pa.refDistance;
          panner.rolloffFactor = pa.rolloffFactor;
          panner.panningModel = pa.panningModel;
        } else {
          // Make sure we have a position to setup the node with.
          if (!sound._pos) {
            sound._pos = self._pos || [0, 0, -0.5];
          }

          // Create a new panner node.
          setupPanner(sound, 'spatial');
        }
      }
    }

    return self;
  };

  /** Single Sound Methods **/
  /***************************************************************************/

  /**
   * Add new properties to the core Sound init.
   * @param  {Function} _super Core Sound init method.
   * @return {Sound}
   */
  Sound.prototype.init = (function(_super) {
    return function() {
      var self = this;
      var parent = self._parent;

      // Setup user-defined default properties.
      self._orientation = parent._orientation;
      self._stereo = parent._stereo;
      self._pos = parent._pos;
      self._pannerAttr = parent._pannerAttr;

      // Complete initilization with howler.js core Sound's init function.
      _super.call(this);

      // If a stereo or position was specified, set it up.
      if (self._stereo) {
        parent.stereo(self._stereo);
      } else if (self._pos) {
        parent.pos(self._pos[0], self._pos[1], self._pos[2], self._id);
      }
    };
  })(Sound.prototype.init);

  /**
   * Override the Sound.reset method to clean up properties from the spatial plugin.
   * @param  {Function} _super Sound reset method.
   * @return {Sound}
   */
  Sound.prototype.reset = (function(_super) {
    return function() {
      var self = this;
      var parent = self._parent;

      // Reset all spatial plugin properties on this sound.
      self._orientation = parent._orientation;
      self._stereo = parent._stereo;
      self._pos = parent._pos;
      self._pannerAttr = parent._pannerAttr;

      // If a stereo or position was specified, set it up.
      if (self._stereo) {
        parent.stereo(self._stereo);
      } else if (self._pos) {
        parent.pos(self._pos[0], self._pos[1], self._pos[2], self._id);
      } else if (self._panner) {
        // Disconnect the panner.
        self._panner.disconnect(0);
        self._panner = undefined;
        parent._refreshBuffer(self);
      }

      // Complete resetting of the sound.
      return _super.call(this);
    };
  })(Sound.prototype.reset);

  /** Helper Methods **/
  /***************************************************************************/

  /**
   * Create a new panner node and save it on the sound.
   * @param  {Sound} sound Specific sound to setup panning on.
   * @param {String} type Type of panner to create: 'stereo' or 'spatial'.
   */
  var setupPanner = function(sound, type) {
    type = type || 'spatial';

    // Create the new panner node.
    if (type === 'spatial') {
      sound._panner = Howler.ctx.createPanner();
      sound._panner.coneInnerAngle = sound._pannerAttr.coneInnerAngle;
      sound._panner.coneOuterAngle = sound._pannerAttr.coneOuterAngle;
      sound._panner.coneOuterGain = sound._pannerAttr.coneOuterGain;
      sound._panner.distanceModel = sound._pannerAttr.distanceModel;
      sound._panner.maxDistance = sound._pannerAttr.maxDistance;
      sound._panner.refDistance = sound._pannerAttr.refDistance;
      sound._panner.rolloffFactor = sound._pannerAttr.rolloffFactor;
      sound._panner.panningModel = sound._pannerAttr.panningModel;

      if (typeof sound._panner.positionX !== 'undefined') {
        sound._panner.positionX.setValueAtTime(sound._pos[0], Howler.ctx.currentTime);
        sound._panner.positionY.setValueAtTime(sound._pos[1], Howler.ctx.currentTime);
        sound._panner.positionZ.setValueAtTime(sound._pos[2], Howler.ctx.currentTime);
      } else {
        sound._panner.setPosition(sound._pos[0], sound._pos[1], sound._pos[2]);
      }

      if (typeof sound._panner.orientationX !== 'undefined') {
        sound._panner.orientationX.setValueAtTime(sound._orientation[0], Howler.ctx.currentTime);
        sound._panner.orientationY.setValueAtTime(sound._orientation[1], Howler.ctx.currentTime);
        sound._panner.orientationZ.setValueAtTime(sound._orientation[2], Howler.ctx.currentTime);
      } else {
        sound._panner.setOrientation(sound._orientation[0], sound._orientation[1], sound._orientation[2]);
      }
    } else {
      sound._panner = Howler.ctx.createStereoPanner();
      sound._panner.pan.setValueAtTime(sound._stereo, Howler.ctx.currentTime);
    }

    sound._panner.connect(sound._node);

    // Update the connections.
    if (!sound._paused) {
      sound._parent.pause(sound._id, true).play(sound._id, true);
    }
  };
})();


/***/ }),

/***/ "./src/app/core/services/sound-manager.service.ts":
/*!********************************************************!*\
  !*** ./src/app/core/services/sound-manager.service.ts ***!
  \********************************************************/
/*! exports provided: SoundManagerService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SoundManagerService", function() { return SoundManagerService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var howler__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! howler */ "./node_modules/howler/dist/howler.js");
/* harmony import */ var howler__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(howler__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ "./node_modules/rxjs/_esm5/index.js");




var SoundManagerService = /** @class */ (function () {
    function SoundManagerService() {
        var _this = this;
        this.backgroundPaused = true;
        this.loadedSounds = new rxjs__WEBPACK_IMPORTED_MODULE_3__["BehaviorSubject"](0);
        if (!this.backgroundMusic) {
            this.backgroundMusic = new howler__WEBPACK_IMPORTED_MODULE_2__["Howl"]({
                src: ['assets/sounds/BGM1.mp3', 'assets/sounds/BGM2.mp3'],
                autoplay: false,
                loop: true,
                volume: 0.5,
                onload: function () { return _this.loadedSounds.next(_this.loadedSounds.getValue() + 1); }
            });
            this.sound = {
                win: new howler__WEBPACK_IMPORTED_MODULE_2__["Howl"]({
                    src: ['assets/sounds/win.mp3'],
                    autoplay: false,
                    loop: false,
                    volume: 0.5,
                    onload: function () { return _this.loadedSounds.next(_this.loadedSounds.getValue() + 1); }
                }),
                lose: new howler__WEBPACK_IMPORTED_MODULE_2__["Howl"]({
                    src: ['assets/sounds/lose.mp3'],
                    autoplay: false,
                    loop: false,
                    volume: 0.5,
                    onload: function () { return _this.loadedSounds.next(_this.loadedSounds.getValue() + 1); }
                }),
                correct: new howler__WEBPACK_IMPORTED_MODULE_2__["Howl"]({
                    src: ['assets/sounds/correct.mp3'],
                    autoplay: false,
                    loop: false,
                    volume: 0.5,
                    onload: function () { return _this.loadedSounds.next(_this.loadedSounds.getValue() + 1); }
                }),
                wrong: new howler__WEBPACK_IMPORTED_MODULE_2__["Howl"]({
                    src: ['assets/sounds/wrong.mp3'],
                    autoplay: false,
                    loop: false,
                    volume: 0.5,
                    onload: function () { return _this.loadedSounds.next(_this.loadedSounds.getValue() + 1); }
                })
            };
        }
    }
    Object.defineProperty(SoundManagerService.prototype, "sounds", {
        get: function () {
            return this.loadedSounds;
        },
        enumerable: true,
        configurable: true
    });
    SoundManagerService.prototype.stopBackgroundMusic = function () {
        this.backgroundPaused = true;
        this.backgroundMusic.pause();
    };
    SoundManagerService.prototype.playBackgroundMusic = function () {
        if (this.backgroundPaused) {
            this.backgroundPaused = false;
            this.backgroundMusic.play();
        }
    };
    SoundManagerService.prototype.stopAllSounds = function () {
        // Object.keys(this.sound).forEach((key) => this.sound[key].stop());
        this.sound.win.stop();
    };
    SoundManagerService.prototype.playSoundByPath = function (path) {
        this.sound[path].play();
    };
    SoundManagerService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
            providedIn: 'root'
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [])
    ], SoundManagerService);
    return SoundManagerService;
}());



/***/ }),

/***/ "./src/app/main/congrats/congrats.component.html":
/*!*******************************************************!*\
  !*** ./src/app/main/congrats/congrats.component.html ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pl-congrats\">\r\n    <canvas id=\"confetti\">\r\n      </canvas>\r\n  <div class=\"pl-congrats__content\">\r\n    <p class=\"pl-congrats__text pl-congrats__congrats-text\">CONGRATULATIONS!</p>\r\n    <p class=\"pl-congrats__text pl-congrats__text--sm\">You got </p>\r\n    <p class=\"pl-congrats__text pl-congrats__text--lg\">{{score}}/5</p>\r\n    <!-- <p class=\"pl-congrats__text pl-congrats__text--sm\">You earned a gift!</p> -->\r\n    <button (click)=\"tryItAgain()\" type=\"button\" class=\"pl-btn pl-congrats__try-again-btn\">Play Again</button>\r\n  </div>\r\n</div>"

/***/ }),

/***/ "./src/app/main/congrats/congrats.component.scss":
/*!*******************************************************!*\
  !*** ./src/app/main/congrats/congrats.component.scss ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pl-congrats {\n  height: 100vh;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  text-align: center; }\n  .pl-congrats__try-again-btn {\n    margin-top: 15px;\n    cursor: pointer; }\n  @media (min-width: 1025px) {\n      .pl-congrats__try-again-btn {\n        font-size: 25px; } }\n  .pl-congrats__congrats-text {\n    font-weight: bold;\n    font-size: 32px;\n    margin-bottom: 8px; }\n  @media (min-width: 600px) {\n      .pl-congrats__congrats-text {\n        font-size: 36px; } }\n  @media (min-width: 1025px) {\n      .pl-congrats__congrats-text {\n        font-size: 55px; } }\n  .pl-congrats__content {\n    width: 100%;\n    font-size: 25px;\n    padding: 0 20px;\n    z-index: 3; }\n  .pl-congrats__text {\n    font-weight: bold;\n    color: #5b108b;\n    letter-spacing: 1.5px;\n    text-transform: uppercase; }\n  .pl-congrats__text--lg {\n      font-weight: 900;\n      font-size: 47px; }\n  @media (min-width: 600px) {\n        .pl-congrats__text--lg {\n          font-size: 65px; } }\n  @media (min-width: 1025px) {\n        .pl-congrats__text--lg {\n          font-size: 80px; } }\n  .pl-congrats__text--sm {\n      font-size: 20px; }\n  @media (min-width: 1025px) {\n        .pl-congrats__text--sm {\n          font-size: 32px; } }\n  @media (min-width: 1281px) {\n        .pl-congrats__text--sm {\n          font-size: 40px; } }\n  #confetti {\n  position: absolute;\n  top: 0;\n  left: 0; }\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/main/congrats/congrats.component.ts":
/*!*****************************************************!*\
  !*** ./src/app/main/congrats/congrats.component.ts ***!
  \*****************************************************/
/*! exports provided: CongratsComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CongratsComponent", function() { return CongratsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var confetti_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! confetti-js */ "./node_modules/confetti-js/dist/index.es.js");
/* harmony import */ var _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/services/sound-manager.service */ "./src/app/core/services/sound-manager.service.ts");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");





var CongratsComponent = /** @class */ (function () {
    function CongratsComponent(soundManagerService, router) {
        this.soundManagerService = soundManagerService;
        this.router = router;
    }
    CongratsComponent.prototype.ngOnInit = function () {
        if (localStorage.getItem('congrats')) {
            this.initConffetti();
            this.score = localStorage.getItem('score');
        }
        else {
            this.router.navigate(['']);
        }
    };
    CongratsComponent.prototype.tryItAgain = function () {
        this.soundManagerService.stopAllSounds();
        this.router.navigate(['']);
    };
    CongratsComponent.prototype.initConffetti = function () {
        var confettiSettings = { target: 'confetti', size: 3, rotate: true, props: ['square', 'line'], max: 120 };
        this.confetti = new confetti_js__WEBPACK_IMPORTED_MODULE_2__["default"](confettiSettings);
        this.confetti.render();
    };
    CongratsComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pl-congrats',
            template: __webpack_require__(/*! ./congrats.component.html */ "./src/app/main/congrats/congrats.component.html"),
            styles: [__webpack_require__(/*! ./congrats.component.scss */ "./src/app/main/congrats/congrats.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__["SoundManagerService"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"]])
    ], CongratsComponent);
    return CongratsComponent;
}());



/***/ }),

/***/ "./src/app/main/game-over/game-over.component.html":
/*!*********************************************************!*\
  !*** ./src/app/main/game-over/game-over.component.html ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pl-game-over\">\r\n  <div class=\"pl-game-over__content\">\r\n    <p class=\"pl-game-over__text pl-game-over__text--lg\">OOOPS!</p>\r\n    <p class=\"pl-game-over__text pl-game-over__text--sm\">You got only</p>\r\n    <p class=\"pl-game-over__text pl-game-over__text--lg\">{{ score }}/5</p>\r\n    <!-- <p class=\"pl-game-over__text pl-game-over__text--sm\">You can try again to get a gift!</p> -->\r\n\r\n    <button (click)=\"tryItAgain()\" type=\"button\" class=\"pl-btn pl-game-over__try-again-btn\">Try Again</button>\r\n  </div>\r\n</div>"

/***/ }),

/***/ "./src/app/main/game-over/game-over.component.scss":
/*!*********************************************************!*\
  !*** ./src/app/main/game-over/game-over.component.scss ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pl-game-over {\n  height: 100vh;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  text-align: center; }\n  .pl-game-over__content {\n    width: 100%;\n    font-size: 25px;\n    padding: 0 20px; }\n  .pl-game-over__text {\n    font-weight: bold;\n    color: #5b108b;\n    letter-spacing: 1.5px;\n    text-transform: uppercase; }\n  .pl-game-over__text--lg {\n      font-weight: 900;\n      font-size: 47px; }\n  @media (min-width: 600px) {\n        .pl-game-over__text--lg {\n          font-size: 65px; } }\n  @media (min-width: 1025px) {\n        .pl-game-over__text--lg {\n          font-size: 80px; } }\n  .pl-game-over__text--sm {\n      font-size: 20px; }\n  @media (min-width: 1025px) {\n        .pl-game-over__text--sm {\n          font-size: 32px; } }\n  @media (min-width: 1281px) {\n        .pl-game-over__text--sm {\n          font-size: 40px; } }\n  .pl-game-over__try-again-btn {\n    margin-top: 15px; }\n  @media (min-width: 1025px) {\n      .pl-game-over__try-again-btn {\n        font-size: 25px; } }\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/main/game-over/game-over.component.ts":
/*!*******************************************************!*\
  !*** ./src/app/main/game-over/game-over.component.ts ***!
  \*******************************************************/
/*! exports provided: GameOverComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GameOverComponent", function() { return GameOverComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/services/sound-manager.service */ "./src/app/core/services/sound-manager.service.ts");




var GameOverComponent = /** @class */ (function () {
    function GameOverComponent(router, soundManagerService) {
        this.router = router;
        this.soundManagerService = soundManagerService;
    }
    GameOverComponent.prototype.ngOnInit = function () {
        if (localStorage.getItem('score')) {
            this.score = localStorage.getItem('score');
            this.soundManagerService.stopBackgroundMusic();
            this.soundManagerService.playSoundByPath('lose');
        }
        else {
            this.router.navigate(['']);
        }
    };
    GameOverComponent.prototype.tryItAgain = function () {
        this.soundManagerService.stopAllSounds();
        this.router.navigate(['']);
    };
    GameOverComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pl-game-over',
            template: __webpack_require__(/*! ./game-over.component.html */ "./src/app/main/game-over/game-over.component.html"),
            styles: [__webpack_require__(/*! ./game-over.component.scss */ "./src/app/main/game-over/game-over.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"], _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__["SoundManagerService"]])
    ], GameOverComponent);
    return GameOverComponent;
}());



/***/ }),

/***/ "./src/app/main/game/game.component.html":
/*!***********************************************!*\
  !*** ./src/app/main/game/game.component.html ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pl-game\">\r\n  <div class=\"pl-game__logo-container\">\r\n    <img class=\" animate__animated animate__bounceInRight\" src=\"assets/images/pl-title-sm.png\">\r\n  </div>\r\n\r\n  <div class=\"pl-game__ribbon-container\">\r\n    <img class=\"animate__animated animate__bounceInLeft\" src=\"assets/images/pl-ribbon.png\">\r\n\r\n    <!-- Question -->\r\n    <div *ngIf=\"showQuestions\" class=\"pl-circle pl-circle--blue pl-game__circle pl-game__circle--blue animate__animated animate__bounceInDown\">\r\n      <div class=\"pl-box pl-game__box pl-game__box--question\">\r\n        <p [innerHTML]=\"questions[activeQuestionIndex].question\"></p>\r\n      </div>\r\n    </div>\r\n\r\n    <!-- Answer -->\r\n    <div *ngIf=\"showQuestions\" class=\"pl-circle pl-circle--yellow pl-game__circle pl-game__circle--yellow  animate__animated animate__bounceInLeft animate__delay-1s\">\r\n      <div class=\"pl-box pl-game__box pl-game__box--answer\">\r\n        <ng-container *ngIf=\"!selectedAnswer\">\r\n        <p *ngFor=\"let answer of questions[activeQuestionIndex].answers\" (click)=\"selectAnswer(answer)\" class=\"pl-game__text pl-game__text-answer\" [innerHTML]=\"answer.answer\"></p>\r\n      </ng-container>\r\n      <ng-container  *ngIf=\"selectedAnswer\">\r\n        <p class=\"pl-game__text pl-game__text-answer animate__animated animate__bounceInLeft\" [innerHTML]=\"selectedAnswer.answer\"></p>\r\n        <p class=\"animate__animated animate__bounceInLeft\" [innerHTML]=\"selectedAnswer.description\">\r\n        </p>\r\n\r\n        <p *ngIf=\"!selectedAnswer.correct\" class=\"pl-game__text pl-game__text-answer-correct animate__animated animate__bounceInLeft\" [innerHTML]=\"correctAnswer.answer\"></p>\r\n        <p *ngIf=\"!selectedAnswer.correct\" class=\"animate__animated animate__bounceInLeft animate__delay-1s\" [innerHTML]=\"correctAnswer.description\">\r\n        </p>\r\n        \r\n      </ng-container>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  <button *ngIf=\"selectedAnswer\" class=\"pl-game__next  animate__bounceInUp animate__animated animate__delay-1s\" (click)=\"next()\">\r\n    Next\r\n  </button>\r\n</div>"

/***/ }),

/***/ "./src/app/main/game/game.component.scss":
/*!***********************************************!*\
  !*** ./src/app/main/game/game.component.scss ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pl-game {\n  background-image: url('pl-background.png');\n  background-size: cover;\n  background-position: center;\n  height: 100vh;\n  position: relative; }\n  .pl-game__box {\n    display: inline-block;\n    padding: 10px 15px;\n    z-index: 9;\n    color: #5b108b;\n    font-size: 12px;\n    font-weight: 600;\n    position: absolute;\n    left: -25px;\n    line-height: 1.2;\n    overflow-y: auto; }\n  .pl-game__box::-webkit-scrollbar {\n      width: 5px;\n      height: 6px; }\n  .pl-game__box::-webkit-scrollbar-track {\n      background: #fff;\n      border-radius: 0;\n      box-shadow: inset 0 5px 5px 0 rgba(193, 205, 205, 0.28); }\n  .pl-game__box::-webkit-scrollbar-thumb {\n      border-radius: 0;\n      background: #5b108b; }\n  @media (min-width: 600px) {\n      .pl-game__box {\n        font-size: 16px; } }\n  @media (min-width: 801px) {\n      .pl-game__box {\n        font-size: 20px; } }\n  @media (min-width: 1025px) {\n      .pl-game__box {\n        font-size: 24px; } }\n  .pl-game__box--answer {\n      top: 20vh;\n      max-height: 40vh;\n      min-width: 65vw; }\n  @media screen and (min-height: 320px) {\n        .pl-game__box--answer {\n          max-height: 32vh; } }\n  @media (min-width: 1025px) {\n        .pl-game__box--answer {\n          min-width: 650px; } }\n  .pl-game__box--question {\n      top: 15vh;\n      min-width: 54vw;\n      max-height: 20vh;\n      -webkit-animation-delay: 0.5s;\n              animation-delay: 0.5s; }\n  @media (min-width: 600px) {\n        .pl-game__box--question {\n          min-width: 50vw; } }\n  @media (min-width: 1025px) {\n        .pl-game__box--question {\n          max-width: 500px; } }\n  .pl-game__circle {\n    position: absolute; }\n  .pl-game__circle::before {\n      content: '';\n      display: block;\n      width: 2px;\n      background-color: #fff;\n      position: absolute;\n      left: 50%;\n      transform: translate(-50%, 10px); }\n  @media (min-width: 600px) {\n      .pl-game__circle {\n        width: 17px;\n        height: 17px; }\n        .pl-game__circle::before {\n          transform: translateY(15px); } }\n  @media (min-width: 801px) {\n      .pl-game__circle {\n        width: 25px;\n        height: 25px;\n        border-width: 3px; }\n        .pl-game__circle::before {\n          transform: translateY(20px);\n          width: 3px; } }\n  @media (min-width: 1025px) {\n      .pl-game__circle {\n        width: 27px;\n        height: 27px; }\n        .pl-game__circle::before {\n          transform: translateY(24px); } }\n  .pl-game__circle--blue {\n      top: 24%;\n      left: 55%; }\n  .pl-game__circle--blue::before {\n        height: 15vh; }\n  @media (min-width: 1025px) {\n        .pl-game__circle--blue {\n          left: 56%; } }\n  .pl-game__circle--yellow {\n      top: 54%;\n      left: 30%; }\n  .pl-game__circle--yellow::before {\n        height: 25vh; }\n  @media (min-width: 1025px) {\n        .pl-game__circle--yellow {\n          top: 50%;\n          left: 34%; } }\n  .pl-game__logo-container {\n    width: 25%;\n    padding: 10px;\n    z-index: 1; }\n  .pl-game__logo-container img {\n      width: 100%; }\n  .pl-game__ribbon-container {\n    position: absolute;\n    top: 0;\n    width: 85%; }\n  .pl-game__ribbon-container img {\n      width: 100%; }\n  .pl-game__gold {\n    color: #b47d3b; }\n  .pl-game__next {\n    background-color: #5b108b;\n    color: #fff;\n    cursor: pointer;\n    border: none;\n    outline: none;\n    float: right;\n    margin-top: 10px;\n    padding-left: 14px;\n    padding-right: 14px;\n    padding-top: 7px;\n    padding-bottom: 7px;\n    right: 5vh;\n    bottom: 10vh;\n    position: absolute; }\n  @media (min-width: 600px) {\n      .pl-game__next {\n        font-size: 24px;\n        padding-left: 14px;\n        padding-right: 14px;\n        padding-top: 7px;\n        padding-bottom: 7px; } }\n  @media (min-width: 801px) {\n      .pl-game__next {\n        font-size: 28px;\n        padding-left: 14px;\n        padding-right: 14px;\n        padding-top: 7px;\n        padding-bottom: 7px; } }\n  @media (min-width: 1025px) {\n      .pl-game__next {\n        font-size: 32px;\n        padding-left: 14px;\n        padding-right: 14px;\n        padding-top: 7px;\n        padding-bottom: 7px; } }\n  .pl-game__text-answer {\n    color: #5b108b;\n    margin-bottom: 10px;\n    cursor: pointer;\n    font-size: 16px;\n    transition: 0.2s linear; }\n  .pl-game__text-answer:hover {\n      color: #b47d3b;\n      transform: scale(1.03); }\n  @media (min-width: 600px) {\n      .pl-game__text-answer {\n        font-size: 24px; } }\n  @media (min-width: 801px) {\n      .pl-game__text-answer {\n        font-size: 28px; } }\n  @media (min-width: 1025px) {\n      .pl-game__text-answer {\n        font-size: 32px; } }\n  .pl-game__text-answer-correct {\n    color: #b47d3b;\n    margin-bottom: 10px;\n    cursor: pointer;\n    font-size: 16px;\n    -webkit-animation-delay: 0.5s;\n            animation-delay: 0.5s;\n    margin-top: 10px; }\n  @media (min-width: 600px) {\n      .pl-game__text-answer-correct {\n        font-size: 24px; } }\n  @media (min-width: 801px) {\n      .pl-game__text-answer-correct {\n        font-size: 28px; } }\n  @media (min-width: 1025px) {\n      .pl-game__text-answer-correct {\n        font-size: 32px; } }\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/main/game/game.component.ts":
/*!*********************************************!*\
  !*** ./src/app/main/game/game.component.ts ***!
  \*********************************************/
/*! exports provided: GameComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GameComponent", function() { return GameComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _shared_data_questions_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../shared/data/questions.data */ "./src/app/shared/data/questions.data.ts");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core/services/sound-manager.service */ "./src/app/core/services/sound-manager.service.ts");





var GameComponent = /** @class */ (function () {
    function GameComponent(router, soundManager) {
        this.router = router;
        this.soundManager = soundManager;
        this.questions = _shared_data_questions_data__WEBPACK_IMPORTED_MODULE_2__["QuestionsData"];
        this.activeQuestionIndex = 0;
        this.correctAnwsers = 0;
        this.showQuestions = true;
        this.selectedAnswer = null;
        this.correctAnswer = null;
    }
    GameComponent.prototype.ngOnInit = function () {
        if (localStorage.getItem('game')) {
            this.soundManager.playBackgroundMusic();
            this.correctAnswer = this.questions[this.activeQuestionIndex].answers.find(function (a) { return a.correct; });
        }
        else {
            this.router.navigate(['']);
        }
    };
    GameComponent.prototype.selectAnswer = function (answer) {
        this.selectedAnswer = answer;
        if (answer.correct) {
            this.soundManager.playSoundByPath('correct');
            this.correctAnwsers++;
        }
        else {
            this.soundManager.playSoundByPath('wrong');
        }
    };
    GameComponent.prototype.next = function () {
        var _this = this;
        this.showQuestions = false;
        setTimeout(function () {
            if (_this.correctAnwsers >= 4 && _this.activeQuestionIndex === 4) {
                localStorage.setItem('congrats', 'true');
                localStorage.setItem('score', _this.correctAnwsers.toString());
                _this.soundManager.stopBackgroundMusic();
                _this.soundManager.playSoundByPath('win');
                _this.router.navigate(['/congrats']);
            }
            else if (_this.correctAnwsers < 4 && _this.activeQuestionIndex === 4) {
                localStorage.setItem('score', _this.correctAnwsers.toString());
                _this.router.navigate(['/game-over']);
            }
            _this.showQuestions = true;
            _this.selectedAnswer = null;
            _this.activeQuestionIndex++;
            _this.correctAnswer = _this.questions[_this.activeQuestionIndex].answers.find(function (a) { return a.correct; });
        }, 200);
    };
    GameComponent.prototype.startGame = function () {
        this.correctAnwsers = 0;
        this.activeQuestionIndex = 0;
        this.showQuestions = true;
    };
    GameComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pl-game',
            template: __webpack_require__(/*! ./game.component.html */ "./src/app/main/game/game.component.html"),
            styles: [__webpack_require__(/*! ./game.component.scss */ "./src/app/main/game/game.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_3__["Router"], _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_4__["SoundManagerService"]])
    ], GameComponent);
    return GameComponent;
}());



/***/ }),

/***/ "./src/app/main/main-routing.animation.ts":
/*!************************************************!*\
  !*** ./src/app/main/main-routing.animation.ts ***!
  \************************************************/
/*! exports provided: mainRoutingAnimation */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mainRoutingAnimation", function() { return mainRoutingAnimation; });
/* harmony import */ var _angular_animations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/animations */ "./node_modules/@angular/animations/fesm5/animations.js");

var mainRoutingAnimation = Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["trigger"])('routeAnimations', [
    Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["transition"])('* <=> *', [
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ position: 'relative' }),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter, :leave', [
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({
                position: 'relative',
                top: 0,
                left: 0,
                width: '100%',
            }),
        ], { optional: true }),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter', [Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ left: '-100%' })], { optional: true }),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':leave', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animateChild"])(), { optional: true }),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["group"])([
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':leave', [Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animate"])('400ms ease-out', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ left: '100%' }))], {
                optional: true,
            }),
            Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter', [Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animate"])('400ms ease-out', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["style"])({ left: '0%' }))], {
                optional: true,
            }),
        ]),
        Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["query"])(':enter', Object(_angular_animations__WEBPACK_IMPORTED_MODULE_0__["animateChild"])(), { optional: true }),
    ]),
]);


/***/ }),

/***/ "./src/app/main/main-routing.module.ts":
/*!*********************************************!*\
  !*** ./src/app/main/main-routing.module.ts ***!
  \*********************************************/
/*! exports provided: MainRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MainRoutingModule", function() { return MainRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _main_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./main.component */ "./src/app/main/main.component.ts");
/* harmony import */ var _title_title_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./title/title.component */ "./src/app/main/title/title.component.ts");
/* harmony import */ var _game_game_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./game/game.component */ "./src/app/main/game/game.component.ts");
/* harmony import */ var _congrats_congrats_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./congrats/congrats.component */ "./src/app/main/congrats/congrats.component.ts");
/* harmony import */ var _game_over_game_over_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./game-over/game-over.component */ "./src/app/main/game-over/game-over.component.ts");








var routes = [
    {
        path: '',
        component: _main_component__WEBPACK_IMPORTED_MODULE_3__["MainComponent"],
        children: [
            {
                path: '',
                component: _title_title_component__WEBPACK_IMPORTED_MODULE_4__["TitleComponent"]
            },
            {
                path: 'game',
                component: _game_game_component__WEBPACK_IMPORTED_MODULE_5__["GameComponent"]
            },
            {
                path: 'congrats',
                component: _congrats_congrats_component__WEBPACK_IMPORTED_MODULE_6__["CongratsComponent"]
            },
            {
                path: 'game-over',
                component: _game_over_game_over_component__WEBPACK_IMPORTED_MODULE_7__["GameOverComponent"]
            }
        ]
    }
];
var MainRoutingModule = /** @class */ (function () {
    function MainRoutingModule() {
    }
    MainRoutingModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
        })
    ], MainRoutingModule);
    return MainRoutingModule;
}());



/***/ }),

/***/ "./src/app/main/main.component.html":
/*!******************************************!*\
  !*** ./src/app/main/main.component.html ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pl-main\" [@routeAnimations]=\"prepareRoute(outlet)\">\r\n    <router-outlet #outlet=\"outlet\"></router-outlet>\r\n  \r\n  <div *ngIf=\"isPortrait\" class=\"pl-main__use-landscape animate__animated animate__fadeInDown\">\r\n    <div class=\"pl-main__landscape-text\">\r\n      <div class=\"pl-main__landscape-message\">\r\n        <img src=\"assets/images/pl-phone.png\" alt=\"Phone\">\r\n\r\n        <span>\r\n          This game works best\r\n          <br>in landscape mode.\r\n        </span>\r\n      </div>\r\n    </div>\r\n  </div>\r\n\r\n\r\n</div>\r\n\r\n<div class=\"pl-main__use-landscape\" *ngIf=\"loadedSounds < 5\">\r\n  <img src=\"assets/images/loader.gif\" alt=\"Loader\">\r\n</div>"

/***/ }),

/***/ "./src/app/main/main.component.scss":
/*!******************************************!*\
  !*** ./src/app/main/main.component.scss ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pl-main__landscape-message {\n  font-family: 'Abbott';\n  font-weight: 600;\n  letter-spacing: 3px;\n  font-size: 14px;\n  color: #45275a;\n  display: flex;\n  align-items: center;\n  justify-content: center; }\n  .pl-main__landscape-message img {\n    margin-right: 15px;\n    height: 32px; }\n  .pl-main__landscape-text {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  width: 100%; }\n  .pl-main__logo {\n  height: 18vh;\n  width: 150px; }\n  .pl-main__use-landscape {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  position: absolute;\n  height: 100vh;\n  width: 100%;\n  top: 0;\n  left: 0;\n  z-index: 9999;\n  background-color: #fff; }\n  .pl-main__use-landscape img {\n    margin-right: 15px;\n    width: auto; }\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/main/main.component.ts":
/*!****************************************!*\
  !*** ./src/app/main/main.component.ts ***!
  \****************************************/
/*! exports provided: MainComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MainComponent", function() { return MainComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _main_routing_animation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./main-routing.animation */ "./src/app/main/main-routing.animation.ts");
/* harmony import */ var _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/services/sound-manager.service */ "./src/app/core/services/sound-manager.service.ts");




var MainComponent = /** @class */ (function () {
    function MainComponent(soundManager, changeDetectorRef) {
        this.soundManager = soundManager;
        this.changeDetectorRef = changeDetectorRef;
    }
    MainComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.isPortrait = innerHeight > innerWidth;
        this.height = innerHeight;
        this.width = innerWidth;
        this.soundManager.playBackgroundMusic();
        this.soundManager.loadedSounds.asObservable().subscribe(function (loadedSounds) {
            _this.loadedSounds = loadedSounds;
            _this.changeDetectorRef.detectChanges();
        });
    };
    MainComponent.prototype.onResize = function () {
        this.isPortrait = innerHeight > innerWidth;
        this.height = innerHeight;
        this.width = innerWidth;
    };
    MainComponent.prototype.prepareRoute = function (outlet) {
        return outlet && outlet.activatedRouteData && outlet.activatedRouteData['animation'];
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["HostListener"])('window:resize', ['$event']),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Function),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", []),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:returntype", void 0)
    ], MainComponent.prototype, "onResize", null);
    MainComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pl-main',
            template: __webpack_require__(/*! ./main.component.html */ "./src/app/main/main.component.html"),
            animations: [_main_routing_animation__WEBPACK_IMPORTED_MODULE_2__["mainRoutingAnimation"]],
            styles: [__webpack_require__(/*! ./main.component.scss */ "./src/app/main/main.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__["SoundManagerService"], _angular_core__WEBPACK_IMPORTED_MODULE_1__["ChangeDetectorRef"]])
    ], MainComponent);
    return MainComponent;
}());



/***/ }),

/***/ "./src/app/main/main.module.ts":
/*!*************************************!*\
  !*** ./src/app/main/main.module.ts ***!
  \*************************************/
/*! exports provided: MainModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MainModule", function() { return MainModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _main_routing_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./main-routing.module */ "./src/app/main/main-routing.module.ts");
/* harmony import */ var _main_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./main.component */ "./src/app/main/main.component.ts");
/* harmony import */ var _congrats_congrats_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./congrats/congrats.component */ "./src/app/main/congrats/congrats.component.ts");
/* harmony import */ var _game_over_game_over_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./game-over/game-over.component */ "./src/app/main/game-over/game-over.component.ts");
/* harmony import */ var _title_title_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./title/title.component */ "./src/app/main/title/title.component.ts");
/* harmony import */ var _game_game_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./game/game.component */ "./src/app/main/game/game.component.ts");









var MainModule = /** @class */ (function () {
    function MainModule() {
    }
    MainModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            declarations: [_main_component__WEBPACK_IMPORTED_MODULE_4__["MainComponent"], _congrats_congrats_component__WEBPACK_IMPORTED_MODULE_5__["CongratsComponent"], _game_over_game_over_component__WEBPACK_IMPORTED_MODULE_6__["GameOverComponent"], _title_title_component__WEBPACK_IMPORTED_MODULE_7__["TitleComponent"], _game_game_component__WEBPACK_IMPORTED_MODULE_8__["GameComponent"]],
            imports: [
                _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
                _main_routing_module__WEBPACK_IMPORTED_MODULE_3__["MainRoutingModule"]
            ]
        })
    ], MainModule);
    return MainModule;
}());



/***/ }),

/***/ "./src/app/main/title/title.component.html":
/*!*************************************************!*\
  !*** ./src/app/main/title/title.component.html ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"pl-title\">\r\n  <div class=\"pl-title__brand-wrapper\">\r\n    <img src=\"assets/images/pl-title-lg.png\" class=\"pl-title__brand-logo animate__animated animate__bounceInRight\">\r\n  </div>\r\n\r\n  <div class=\"pl-title__arrow-wrapper\">\r\n    <img src=\"assets/images/pl-title-arrow.png\" class=\"pl-title__arrow-img  animate__animated animate__bounceInLeft\">\r\n    <div class=\"pl-circle pl-circle--pink pl-title__circle animate__animated animate__bounceInUp animate__delay-1s\">\r\n      <div class=\"pl-box pl-title__box\">\r\n        <p>Watch the PediaSure plus <br>Legacy video and play the game.</p>\r\n      </div>\r\n    </div>\r\n  </div>\r\n\r\n  <button (click)=\"start()\" type=\"button\" class=\"pl-btn pl-title__start-btn  animate__animated animate__bounceInUp\">Start</button>\r\n</div>"

/***/ }),

/***/ "./src/app/main/title/title.component.scss":
/*!*************************************************!*\
  !*** ./src/app/main/title/title.component.scss ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".pl-title {\n  position: relative;\n  height: 100vh;\n  overflow-y: hidden;\n  background-image: url('pl-background.png');\n  background-size: cover;\n  background-position: center; }\n  .pl-title__arrow-img {\n    width: 100%;\n    -webkit-animation-delay: 0.5s;\n            animation-delay: 0.5s;\n    z-index: 1; }\n  .pl-title__arrow-wrapper {\n    position: fixed;\n    bottom: -5px;\n    width: 85vw;\n    left: 5%; }\n  @media (min-width: 500px) {\n      .pl-title__arrow-wrapper {\n        width: 80vw; } }\n  @media (min-width: 600px) {\n      .pl-title__arrow-wrapper {\n        width: 70vw;\n        left: 15%; } }\n  @media (min-width: 700px) {\n      .pl-title__arrow-wrapper {\n        width: 60vw;\n        left: 20%; } }\n  @media (min-width: 801px) {\n      .pl-title__arrow-wrapper {\n        width: 55vw;\n        left: 25%; } }\n  @media (min-width: 1025px) {\n      .pl-title__arrow-wrapper {\n        width: 70vw;\n        left: 13%; } }\n  @media screen and (min-width: 1024px) and (min-height: 768px) {\n      .pl-title__arrow-wrapper {\n        left: 15px;\n        width: 90vw; } }\n  @media screen and (min-width: 1366px) and (min-height: 768px) {\n      .pl-title__arrow-wrapper {\n        width: 65vw;\n        left: 12%; } }\n  .pl-title__brand-logo {\n    width: 100%;\n    position: relative;\n    z-index: 2; }\n  .pl-title__brand-wrapper {\n    width: 55%;\n    padding: 20px; }\n  @media (min-width: 550px) {\n      .pl-title__brand-wrapper {\n        width: 50%; } }\n  @media (min-width: 700px) {\n      .pl-title__brand-wrapper {\n        width: 47%; } }\n  @media screen and (min-width: 1024px) and (min-height: 768px) {\n      .pl-title__brand-wrapper {\n        width: 48%; } }\n  .pl-title__box {\n    position: absolute;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    text-align: center;\n    padding: 10px;\n    color: #5b108b;\n    width: 38vw;\n    top: -50.5vh;\n    left: -47px; }\n  .pl-title__box p {\n      text-align: center; }\n  @media (min-width: 801px) {\n      .pl-title__box {\n        min-height: 25vh;\n        font-size: 16px; } }\n  @media (min-width: 1025px) {\n      .pl-title__box {\n        font-size: 24px;\n        height: auto;\n        left: -148px;\n        width: 475px;\n        padding: 10px 15px; } }\n  @media screen and (min-width: 1024px) and (min-height: 768px) {\n      .pl-title__box {\n        font-size: 22px; } }\n  @media (min-width: 1366px) {\n      .pl-title__box {\n        width: 600px;\n        font-size: 30px;\n        left: -90px; } }\n  @media (min-width: 1600px) {\n      .pl-title__box {\n        width: 665px;\n        font-size: 32px; } }\n  @media (min-width: 1920px) {\n      .pl-title__box {\n        width: 775px;\n        font-size: 35px; } }\n  .pl-title__circle {\n    position: absolute;\n    right: 30%;\n    top: 27%; }\n  .pl-title__circle::before {\n      content: '';\n      display: block;\n      width: 2px;\n      background-color: #fff;\n      position: absolute;\n      left: 50%;\n      transform: translate(-50%, -35vh);\n      height: 35vh; }\n  @media (min-width: 700px) {\n      .pl-title__circle {\n        width: 17px;\n        height: 17px; } }\n  @media (min-width: 801px) {\n      .pl-title__circle {\n        width: 25px;\n        height: 25px;\n        border-width: 3px; } }\n  .pl-title__start-btn {\n    position: absolute;\n    right: 35px;\n    bottom: 40px;\n    transition: 0.2s linear;\n    -webkit-animation-delay: 1.5s;\n            animation-delay: 1.5s;\n    cursor: pointer; }\n  @media (min-width: 801px) {\n      .pl-title__start-btn {\n        font-size: 32px;\n        right: 100px;\n        bottom: 90px; } }\n\n/*# sourceMappingURL=data:application/json;base64,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 */"

/***/ }),

/***/ "./src/app/main/title/title.component.ts":
/*!***********************************************!*\
  !*** ./src/app/main/title/title.component.ts ***!
  \***********************************************/
/*! exports provided: TitleComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TitleComponent", function() { return TitleComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/services/sound-manager.service */ "./src/app/core/services/sound-manager.service.ts");




var TitleComponent = /** @class */ (function () {
    function TitleComponent(router, soundManager) {
        this.router = router;
        this.soundManager = soundManager;
    }
    TitleComponent.prototype.ngOnInit = function () {
        this.soundManager.playBackgroundMusic();
    };
    TitleComponent.prototype.start = function () {
        localStorage.setItem('game', 'true');
        this.router.navigate(['/game']);
    };
    TitleComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'pl-title',
            template: __webpack_require__(/*! ./title.component.html */ "./src/app/main/title/title.component.html"),
            styles: [__webpack_require__(/*! ./title.component.scss */ "./src/app/main/title/title.component.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"], _core_services_sound_manager_service__WEBPACK_IMPORTED_MODULE_3__["SoundManagerService"]])
    ], TitleComponent);
    return TitleComponent;
}());



/***/ }),

/***/ "./src/app/shared/data/questions.data.ts":
/*!***********************************************!*\
  !*** ./src/app/shared/data/questions.data.ts ***!
  \***********************************************/
/*! exports provided: QuestionsData */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionsData", function() { return QuestionsData; });
var QuestionsData = [
    {
        question: '1. In what year was the brand <br> first launched in the market?',
        answers: [
            {
                answer: 'A. 2020',
                description: 'Wrong!'
            },
            {
                answer: 'B. 1988',
                description: 'The brand was first introduced in the USA',
                correct: true
            },
            {
                answer: 'C. 1969',
                description: 'Wrong!'
            }
        ]
    },
    {
        question: "2. True or False. <br>Prebiotics and Probiotics were added<br> to the brand's formulation in 2004.",
        answers: [
            {
                answer: 'A. TRUE',
                description: "A Unique synbiotic blend of prebiotics and probiotics<br>was added to the brand's formula innovation in 2004<br>to promote a healthy gut and enhance absorption<br>of nutrients for healthy growth.",
                correct: true
            },
            {
                answer: 'B. FALSE',
                description: 'Wrong!'
            }
        ]
    },
    {
        question: "3. What was added to the brand's<br>formulation in 2010 that helps support<br>muscle and bone growth?",
        answers: [
            {
                answer: 'A. Iron',
                description: 'Wrong!'
            },
            {
                answer: 'B. Triple Protein System',
                description: 'The brand is formulated with complete and<br>high quality protein blend that supports muscle<br>and bone growth.',
                correct: true
            },
            {
                answer: 'C. Soy Protein Isolate',
                description: 'Wrong!'
            }
        ]
    },
    {
        question: '4. The brand has over <u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</u> years of <br>scientific leadership.',
        answers: [
            {
                answer: 'A. 20 years',
                description: 'Wrong!'
            },
            {
                answer: 'B. 30 years',
                description: 'The brand celebrates over 30 years of scientific<br>leadership as the #1 Child Nutrional Supplement<br>in over 86 countries.',
                correct: true
            },
            {
                answer: 'C. 50 years',
                description: 'Wrong!'
            }
        ]
    },
    {
        question: "5. What are the two key ingredients<br>in the brand's latest formula innovation?",
        answers: [
            {
                answer: 'A. Vitamins K2 and prebiotics',
                description: 'Wrong!'
            },
            {
                answer: 'B. Milk, casein, and soy protein',
                description: 'Wrong!'
            },
            {
                answer: 'C. Arginine and Natural Vitamin K2',
                description: 'The brand is now fomulated with Natural Vitamin K2<br>and Arginine to help support strong bones and<br> facilitate 1.5x faster growth.',
                correct: true
            }
        ]
    }
];


/***/ })

}]);
//# sourceMappingURL=main-main-module.js.map